/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.utilities;

import io.fabric8.maven.Maven;
import io.fabric8.maven.XMLFormat;
import io.quarkus.maven.utilities.SortedProperties;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import org.apache.maven.cli.transfer.QuietMavenTransferListener;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.transfer.TransferListener;

public class MojoUtils {
    public static final String JAVA_FILE_EXTENSION = ".java";
    public static final String KOTLIN_FILE_EXTENSION = ".kt";
    public static final String SCALA_FILE_EXTENSION = ".scala";
    public static final String JAVA_EXTENSION_NAME = "java";
    public static final String KOTLIN_EXTENSION_NAME = "kotlin";
    public static final String SCALA_EXTENSION_NAME = "scala";
    public static final String TEMPLATE_PROPERTY_QUARKUS_VERSION_NAME = "quarkus.version";
    public static final String TEMPLATE_PROPERTY_QUARKUS_VERSION_VALUE = MojoUtils.toPropExpr("quarkus.version");
    public static final String TEMPLATE_PROPERTY_QUARKUS_PLATFORM_GROUP_ID_NAME = "quarkus.platform.group-id";
    public static final String TEMPLATE_PROPERTY_QUARKUS_PLATFORM_GROUP_ID_VALUE = MojoUtils.toPropExpr("quarkus.platform.group-id");
    public static final String TEMPLATE_PROPERTY_QUARKUS_PLATFORM_ARTIFACT_ID_NAME = "quarkus.platform.artifact-id";
    public static final String TEMPLATE_PROPERTY_QUARKUS_PLATFORM_ARTIFACT_ID_VALUE = MojoUtils.toPropExpr("quarkus.platform.artifact-id");
    public static final String TEMPLATE_PROPERTY_QUARKUS_PLATFORM_VERSION_NAME = "quarkus.platform.version";
    public static final String TEMPLATE_PROPERTY_QUARKUS_PLATFORM_VERSION_VALUE = MojoUtils.toPropExpr("quarkus.platform.version");
    public static final String TEMPLATE_PROPERTY_QUARKUS_PLUGIN_VERSION_NAME = "quarkus-plugin.version";
    public static final String TEMPLATE_PROPERTY_QUARKUS_PLUGIN_VERSION_VALUE = MojoUtils.toPropExpr("quarkus-plugin.version");

    private static String toPropExpr(String name) {
        return "${" + name + "}";
    }

    private MojoUtils() {
    }

    public static RepositorySystemSession muteTransferListener(RepositorySystemSession session) {
        if (session.getTransferListener() == null) {
            return session;
        }
        DefaultRepositorySystemSession newSession = new DefaultRepositorySystemSession(session);
        newSession.setTransferListener((TransferListener)new QuietMavenTransferListener());
        return newSession;
    }

    public static boolean hasDependency(Model model, String groupId, String artifactId) {
        return model.getDependencies().stream().anyMatch(d -> groupId.equals(d.getGroupId()) && artifactId.equals(d.getArtifactId()));
    }

    public static Dependency parse(String dependency) {
        Dependency res = new Dependency();
        String[] segments = dependency.split(":");
        if (segments.length >= 2) {
            res.setGroupId(segments[0].toLowerCase());
            res.setArtifactId(segments[1].toLowerCase());
            if (segments.length >= 3 && !segments[2].isEmpty()) {
                res.setVersion(segments[2]);
            }
            if (segments.length >= 4) {
                res.setClassifier(segments[3].toLowerCase());
            }
            return res;
        }
        throw new IllegalArgumentException("Invalid dependency description '" + dependency + "'");
    }

    public static Xpp3Dom configuration(Element ... elements) {
        Xpp3Dom dom = new Xpp3Dom("configuration");
        for (Element e : elements) {
            dom.addChild(e.toDom());
        }
        return dom;
    }

    public static Plugin plugin(String groupId, String artifactId) {
        return MojoUtils.plugin(groupId, artifactId, null);
    }

    public static Plugin plugin(String groupId, String artifactId, String version) {
        return MojoUtils.plugin(groupId, artifactId, version, Collections.emptyList());
    }

    public static Plugin plugin(String groupId, String artifactId, String version, List<Dependency> dependencies) {
        Plugin plugin = new Plugin();
        plugin.setArtifactId(artifactId);
        plugin.setGroupId(groupId);
        plugin.setVersion(version);
        plugin.setDependencies(dependencies);
        return plugin;
    }

    public static Model readPom(File pom) throws IOException {
        try {
            return Maven.readModel((Path)pom.toPath());
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
        catch (RuntimeException e) {
            throw new IOException("Failed to read model", e.getCause());
        }
    }

    public static Model readPom(InputStream resourceAsStream) throws IOException {
        Model model;
        block9: {
            InputStream is = resourceAsStream;
            try {
                model = Maven.readModel((InputStream)is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UncheckedIOException e) {
                    throw e.getCause();
                }
                catch (RuntimeException e) {
                    throw new IOException("Failed to read model", e.getCause());
                }
            }
            is.close();
        }
        return model;
    }

    public static String[] readGavFromPom(InputStream resourceAsStream) throws IOException {
        Model model = MojoUtils.readPom(resourceAsStream);
        return new String[]{model.getGroupId(), model.getArtifactId(), model.getVersion()};
    }

    public static void write(Model model, File outputFile) throws IOException {
        try {
            Maven.writeModel((Model)model, (Path)outputFile.toPath());
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public static void writeFormatted(Model model, File outputFile) throws IOException {
        try {
            Maven.writeModel((Model)model, (Path)outputFile.toPath(), (XMLFormat)XMLFormat.builder().indent("    ").insertLineBreakBetweenMajorSections().build());
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public static void write(Model model, OutputStream fileOutputStream) throws IOException {
        Properties props = model.getProperties();
        if (!props.isEmpty() && !(props instanceof SortedProperties)) {
            SortedProperties sorted = new SortedProperties();
            sorted.putAll((Map<?, ?>)props);
            model.setProperties((Properties)sorted);
        }
        try (XmlStreamWriter writer = WriterFactory.newXmlWriter((OutputStream)fileOutputStream);){
            Maven.writeModel((Model)model, (Writer)writer);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public static String credentials(Dependency d) {
        return String.format("%s:%s", d.getGroupId(), d.getArtifactId());
    }

    public static String[] readGavFromSettingsGradle(ByteArrayInputStream buildFileInputStream, String[] gavIn) {
        String[] gavOut = Arrays.copyOf(gavIn, gavIn.length);
        try (Scanner scanner = new Scanner((InputStream)buildFileInputStream, StandardCharsets.UTF_8.name());){
            while (scanner.hasNextLine()) {
                String currentLine = scanner.nextLine();
                if (currentLine.startsWith("group")) {
                    gavOut[0] = currentLine.substring(currentLine.indexOf(39) + 1, currentLine.lastIndexOf(39));
                    continue;
                }
                if (currentLine.startsWith("rootProject.name")) {
                    gavOut[1] = currentLine.substring(currentLine.indexOf(39) + 1, currentLine.lastIndexOf(39));
                    continue;
                }
                if (!currentLine.startsWith("version")) continue;
                gavOut[2] = currentLine.substring(currentLine.indexOf(39) + 1, currentLine.lastIndexOf(39));
            }
        }
        return gavOut;
    }

    public static Path getClassOrigin(Class<?> cls) throws IOException {
        return MojoUtils.getResourceOrigin(cls.getClassLoader(), cls.getName().replace('.', '/') + ".class");
    }

    public static Path getResourceOrigin(ClassLoader cl, String name) throws IOException {
        URL url = cl.getResource(name);
        if (url == null) {
            throw new IOException("Failed to locate the origin of " + name);
        }
        String classLocation = url.toExternalForm();
        classLocation = url.getProtocol().equals("jar") ? classLocation.substring(4, classLocation.length() - name.length() - 2) : classLocation.substring(0, classLocation.length() - name.length());
        return MojoUtils.urlSpecToPath(classLocation);
    }

    private static Path urlSpecToPath(String urlSpec) throws IOException {
        try {
            return Paths.get(new URL(urlSpec).toURI());
        }
        catch (Throwable e) {
            throw new IOException("Failed to create an instance of " + Path.class.getName() + " from " + urlSpec, e);
        }
    }

    public static class Element {
        private final Element[] children;
        private final String name;
        private final String text;
        private final Attributes attributes;

        public Element(String name, Element ... children) {
            this(name, null, new Attributes(new Attribute[0]), children);
        }

        public Element(String name, Attributes attributes, Element ... children) {
            this(name, null, attributes, children);
        }

        public Element(String name, String text, Element ... children) {
            this.name = name;
            this.text = text;
            this.children = children;
            this.attributes = new Attributes(new Attribute[0]);
        }

        public Element(String name, String text, Attributes attributes, Element ... children) {
            this.name = name;
            this.text = text;
            this.children = children;
            this.attributes = attributes;
        }

        public Xpp3Dom toDom() {
            Xpp3Dom dom = new Xpp3Dom(this.name);
            if (this.text != null) {
                dom.setValue(this.text);
            }
            for (Element e : this.children) {
                dom.addChild(e.toDom());
            }
            for (Attribute attribute : this.attributes.attributes) {
                dom.setAttribute(attribute.name, attribute.value);
            }
            return dom;
        }
    }

    public static class Attribute {
        private final String name;
        private final String value;

        public Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class Attributes {
        private List<Attribute> attributes;

        public Attributes(Attribute ... attributes) {
            this.attributes = Arrays.asList(attributes);
        }
    }
}

