/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.config;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.registry.config.RegistryConfig;
import io.quarkus.registry.config.RegistryDescriptorConfig;
import io.quarkus.registry.config.RegistryDescriptorConfigImpl;
import io.quarkus.registry.config.RegistryMavenConfig;
import io.quarkus.registry.config.RegistryMavenConfigImpl;
import io.quarkus.registry.config.RegistryMavenRepoConfig;
import io.quarkus.registry.config.RegistryNonPlatformExtensionsConfig;
import io.quarkus.registry.config.RegistryNonPlatformExtensionsConfigImpl;
import io.quarkus.registry.config.RegistryPlatformsConfig;
import io.quarkus.registry.config.RegistryPlatformsConfigImpl;
import io.quarkus.registry.config.RegistryQuarkusVersionsConfig;
import io.quarkus.registry.config.RegistryQuarkusVersionsConfigImpl;
import io.quarkus.registry.json.JsonBooleanTrueFilter;
import io.quarkus.registry.json.JsonBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonSerialize(using=Serializer.class)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class RegistryConfigImpl
implements RegistryConfig {
    private static RegistryConfig defaultRegistry;
    private final String id;
    private final boolean enabled;
    private final String updatePolicy;
    private final RegistryDescriptorConfig descriptor;
    private final RegistryPlatformsConfig platforms;
    private final RegistryNonPlatformExtensionsConfig nonPlatformExtensions;
    private final RegistryMavenConfig mavenConfig;
    private final RegistryQuarkusVersionsConfig versionsConfig;
    private final Map<String, Object> extra;

    private RegistryConfigImpl(Builder builder) {
        this.id = builder.id;
        this.enabled = builder.enabled;
        this.updatePolicy = JsonBuilder.buildIfBuilder(builder.updatePolicy);
        this.descriptor = builder.descriptor == null || builder.descriptor.getArtifact() == null ? new RegistryDescriptorConfigImpl(this.repoIdToArtifact(this.id), true) : JsonBuilder.buildIfBuilder(builder.descriptor);
        this.platforms = JsonBuilder.buildIfBuilder(builder.platforms);
        this.nonPlatformExtensions = JsonBuilder.buildIfBuilder(builder.nonPlatformExtensions);
        this.mavenConfig = JsonBuilder.buildIfBuilder(builder.mavenConfig);
        this.versionsConfig = JsonBuilder.buildIfBuilder(builder.versionsConfig);
        this.extra = JsonBuilder.toUnmodifiableMap(builder.extra);
    }

    @Override
    @JsonIgnore
    public String getId() {
        return this.id;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=JsonBooleanTrueFilter.class)
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getUpdatePolicy() {
        return this.updatePolicy;
    }

    @Override
    public RegistryDescriptorConfig getDescriptor() {
        return this.descriptor;
    }

    @Override
    public RegistryPlatformsConfig getPlatforms() {
        return this.platforms;
    }

    @Override
    public RegistryNonPlatformExtensionsConfig getNonPlatformExtensions() {
        return this.nonPlatformExtensions;
    }

    @Override
    public RegistryMavenConfig getMaven() {
        return this.mavenConfig;
    }

    @Override
    public RegistryQuarkusVersionsConfig getQuarkusVersions() {
        return this.versionsConfig;
    }

    @Override
    @JsonAnyGetter
    public Map<String, Object> getExtra() {
        return this.extra;
    }

    private ArtifactCoords repoIdToArtifact(String id) {
        String[] parts = id.split("\\.");
        StringBuilder buf = new StringBuilder(id.length());
        int i = parts.length;
        buf.append(parts[--i]);
        while (--i >= 0) {
            buf.append('.').append(parts[i]);
        }
        return ArtifactCoords.of((String)buf.toString(), (String)"quarkus-registry-descriptor", null, (String)"json", (String)"1.0-SNAPSHOT");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegistryConfigImpl that = (RegistryConfigImpl)o;
        return this.enabled == that.enabled && Objects.equals(this.id, that.id) && Objects.equals(this.updatePolicy, that.updatePolicy) && Objects.equals(this.descriptor, that.descriptor) && Objects.equals(this.platforms, that.platforms) && Objects.equals(this.nonPlatformExtensions, that.nonPlatformExtensions) && Objects.equals(this.mavenConfig, that.mavenConfig) && Objects.equals(this.versionsConfig, that.versionsConfig) && Objects.equals(this.extra, that.extra);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.enabled, this.updatePolicy, this.descriptor, this.platforms, this.nonPlatformExtensions, this.mavenConfig, this.versionsConfig, this.extra);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{id='" + this.id + "', enabled=" + this.enabled + ", updatePolicy='" + this.updatePolicy + "', descriptor=" + this.descriptor + ", platforms=" + this.platforms + ", nonPlatformExtensions=" + this.nonPlatformExtensions + ", mavenConfig=" + this.mavenConfig + ", versionsConfig=" + this.versionsConfig + ", extra=" + this.extra + "}";
    }

    static boolean onlyId(RegistryConfig value) {
        if (value.getId().equals("registry.quarkus.io")) {
            return value.equals(RegistryConfigImpl.getDefaultRegistry());
        }
        return !(value.getMaven() != null || !value.isEnabled() || value.getDescriptor() != null && !RegistryDescriptorConfigImpl.isGenerated(value.getDescriptor()) || value.getNonPlatformExtensions() != null || value.getPlatforms() != null || value.getUpdatePolicy() != null || value.getQuarkusVersions() != null || value.getExtra() != null && !value.getExtra().isEmpty());
    }

    static boolean isDefaultList(List<RegistryConfig> list) {
        return list.size() == 1 && list.get(0) == RegistryConfig.defaultConfig();
    }

    static RegistryConfig getDefaultRegistry() {
        if (defaultRegistry == null) {
            defaultRegistry = RegistryConfig.builder().setId("registry.quarkus.io").setDescriptor(RegistryDescriptorConfig.builder().setArtifact(ArtifactCoords.of((String)"io.quarkus.registry", (String)"quarkus-registry-descriptor", null, (String)"json", (String)"1.0-SNAPSHOT")).build()).setMaven(RegistryMavenConfig.builder().setRepository(RegistryMavenRepoConfig.builder().setId("registry.quarkus.io").setUrl("https://registry.quarkus.io/maven").build()).build()).setPlatforms(RegistryPlatformsConfig.builder().setArtifact(ArtifactCoords.of((String)"io.quarkus.registry", (String)"quarkus-platforms", null, (String)"json", (String)"1.0-SNAPSHOT")).build()).setNonPlatformExtensions(RegistryNonPlatformExtensionsConfig.builder().setArtifact(ArtifactCoords.of((String)"io.quarkus.registry", (String)"quarkus-non-platform-extensions", null, (String)"json", (String)"1.0-SNAPSHOT")).build()).build();
            return defaultRegistry;
        }
        return defaultRegistry;
    }

    static class BuilderDeserializer
    extends JsonDeserializer<Builder> {
        BuilderDeserializer() {
        }

        public Builder deserialize(JsonParser p, DeserializationContext dctx) throws IOException {
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                return new Builder().setId(p.getText());
            }
            if (p.getCurrentToken() == JsonToken.START_OBJECT) {
                Builder builder;
                JsonStreamContext ctx = p.getParsingContext();
                if (ctx.getParent() == null || ctx.getParent().inRoot()) {
                    builder = (Builder)p.readValueAs(Builder.class);
                } else {
                    JsonBuilder.ensureNextToken(p, JsonToken.FIELD_NAME, dctx);
                    String qerId = p.getCurrentName();
                    JsonBuilder.ensureNextToken(p, JsonToken.START_OBJECT, dctx);
                    builder = (Builder)p.readValueAs(Builder.class);
                    builder.setId(qerId);
                    JsonBuilder.ensureNextToken(p, JsonToken.END_OBJECT, dctx);
                }
                return builder;
            }
            return null;
        }
    }

    static class Serializer
    extends JsonSerializer<RegistryConfig> {
        Serializer() {
        }

        public void serialize(RegistryConfig value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            JsonStreamContext ctx = gen.getOutputContext();
            if (ctx.getParent() == null || ctx.getParent().inRoot()) {
                gen.writeStartObject();
                Serializer.writeContents(value, gen);
                gen.writeEndObject();
            } else if (RegistryConfigImpl.onlyId(value)) {
                gen.writeNumber(value.getId());
            } else {
                gen.writeStartObject();
                gen.writeObjectFieldStart(value.getId());
                Serializer.writeContents(value, gen);
                gen.writeEndObject();
                gen.writeEndObject();
            }
        }

        static void writeContents(RegistryConfig value, JsonGenerator gen) throws IOException {
            if (!value.isEnabled()) {
                gen.writeObjectField("enabled", (Object)value.isEnabled());
            }
            Serializer.writeUnlessNull(gen, "update-policy", value.getUpdatePolicy());
            Serializer.writeUnlessNullOrTest(gen, "descriptor", value.getDescriptor(), RegistryDescriptorConfigImpl::isGenerated);
            Serializer.writeUnlessNull(gen, "platforms", value.getPlatforms());
            Serializer.writeUnlessNull(gen, "non-platform-extensions", value.getNonPlatformExtensions());
            Serializer.writeUnlessNull(gen, "maven", value.getMaven());
            Serializer.writeUnlessNull(gen, "quarkus-versions", value.getQuarkusVersions());
            Map<String, Object> extra = value.getExtra();
            if (extra != null && !extra.isEmpty()) {
                for (Map.Entry<String, Object> entry : extra.entrySet()) {
                    gen.writeObjectField(entry.getKey().toString(), entry.getValue());
                }
            }
        }

        static <T> void writeUnlessNullOrTest(JsonGenerator gen, String fieldName, T obj, Function<T, Boolean> test) throws IOException {
            if (obj == null || test.apply(obj).booleanValue()) {
                return;
            }
            gen.writeObjectField(fieldName, obj);
        }

        static void writeUnlessNull(JsonGenerator gen, String fieldName, Object obj) throws IOException {
            if (obj != null) {
                gen.writeObjectField(fieldName, obj);
            }
        }
    }

    public static class Builder
    implements RegistryConfig.Mutable {
        protected String id;
        protected boolean enabled = true;
        protected String updatePolicy;
        protected RegistryDescriptorConfig descriptor;
        protected RegistryPlatformsConfig platforms;
        protected RegistryNonPlatformExtensionsConfig nonPlatformExtensions;
        protected RegistryMavenConfig mavenConfig;
        protected RegistryQuarkusVersionsConfig versionsConfig;
        protected Map<String, Object> extra;

        public Builder() {
        }

        Builder(String id) {
            this.id = id;
        }

        @JsonIgnore
        Builder(RegistryConfig config) {
            this.id = config.getId();
            this.updatePolicy = config.getUpdatePolicy();
            this.descriptor = config.getDescriptor();
            this.platforms = config.getPlatforms();
            this.nonPlatformExtensions = config.getNonPlatformExtensions();
            this.mavenConfig = config.getMaven();
            this.versionsConfig = config.getQuarkusVersions();
            this.extra = config.getExtra() == null ? null : new HashMap<String, Object>(config.getExtra());
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=JsonBooleanTrueFilter.class)
        public Builder setEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public String getUpdatePolicy() {
            return this.updatePolicy;
        }

        @Override
        public Builder setUpdatePolicy(String updatePolicy) {
            this.updatePolicy = updatePolicy;
            return this;
        }

        @Override
        public RegistryDescriptorConfig getDescriptor() {
            return this.descriptor;
        }

        @Override
        @JsonDeserialize(as=RegistryDescriptorConfigImpl.Builder.class)
        public Builder setDescriptor(RegistryDescriptorConfig descriptor) {
            this.descriptor = descriptor;
            return this;
        }

        @Override
        public RegistryPlatformsConfig getPlatforms() {
            return this.platforms;
        }

        @Override
        @JsonDeserialize(as=RegistryPlatformsConfigImpl.Builder.class)
        public Builder setPlatforms(RegistryPlatformsConfig platforms) {
            this.platforms = platforms;
            return this;
        }

        @Override
        public RegistryNonPlatformExtensionsConfig getNonPlatformExtensions() {
            return this.nonPlatformExtensions;
        }

        @Override
        @JsonDeserialize(as=RegistryNonPlatformExtensionsConfigImpl.Builder.class)
        public Builder setNonPlatformExtensions(RegistryNonPlatformExtensionsConfig nonPlatformExtensions) {
            this.nonPlatformExtensions = nonPlatformExtensions;
            return this;
        }

        @Override
        public RegistryMavenConfig getMaven() {
            return this.mavenConfig;
        }

        @Override
        @JsonDeserialize(as=RegistryMavenConfigImpl.Builder.class)
        public Builder setMaven(RegistryMavenConfig mavenConfig) {
            this.mavenConfig = mavenConfig;
            return this;
        }

        @Override
        public RegistryQuarkusVersionsConfig getQuarkusVersions() {
            return this.versionsConfig;
        }

        @Override
        @JsonDeserialize(as=RegistryQuarkusVersionsConfigImpl.Builder.class)
        public Builder setQuarkusVersions(RegistryQuarkusVersionsConfig versionsConfig) {
            this.versionsConfig = versionsConfig;
            return this;
        }

        @Override
        public Map<String, Object> getExtra() {
            return this.extra == null ? Collections.emptyMap() : this.extra;
        }

        @Override
        public RegistryConfig.Mutable setExtra(Map<String, Object> newValues) {
            if (newValues != Collections.EMPTY_MAP) {
                this.extra = newValues;
            }
            return this;
        }

        @Override
        @JsonAnySetter
        public Builder setExtra(String name, Object value) {
            if (this.extra == null) {
                this.extra = new HashMap<String, Object>();
            }
            this.extra.put(name, value);
            return this;
        }

        @Override
        public RegistryConfigImpl build() {
            if ("registry.quarkus.io".equals(this.id)) {
                this.fillInFromDefaultRegistry();
            }
            return new RegistryConfigImpl(this);
        }

        private void fillInFromDefaultRegistry() {
            if (this.descriptor == null) {
                this.descriptor = RegistryConfigImpl.getDefaultRegistry().getDescriptor();
            }
            if (this.platforms == null) {
                this.platforms = RegistryConfigImpl.getDefaultRegistry().getPlatforms();
            }
            if (this.nonPlatformExtensions == null) {
                this.nonPlatformExtensions = RegistryConfigImpl.getDefaultRegistry().getNonPlatformExtensions();
            }
            if (this.mavenConfig == null) {
                this.mavenConfig = RegistryConfigImpl.getDefaultRegistry().getMaven();
            }
        }
    }
}

