/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog.selection;

import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.selection.OriginPreference;
import io.quarkus.registry.catalog.selection.OriginWithPreference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class ExtensionOrigins {
    private final ArtifactKey extKey;
    private Collection<OriginWithPreference> origins = new ArrayList<OriginWithPreference>();

    public static Builder builder(ArtifactKey extKey) {
        return new ExtensionOrigins(extKey).new Builder();
    }

    private ExtensionOrigins(ArtifactKey extKey) {
        this.extKey = extKey;
    }

    public ArtifactKey getExtensionKey() {
        return this.extKey;
    }

    public Collection<OriginWithPreference> getOrigins() {
        return this.origins;
    }

    public class Builder {
        private Builder() {
        }

        public Builder addOrigin(ExtensionCatalog catalog, OriginPreference preference) {
            return this.addOrigin(new OriginWithPreference(catalog, preference));
        }

        public Builder addOrigin(OriginWithPreference origin) {
            ExtensionOrigins.this.origins.add(origin);
            return this;
        }

        public ExtensionOrigins build() {
            ExtensionOrigins.this.origins = Collections.unmodifiableCollection(ExtensionOrigins.this.origins);
            return ExtensionOrigins.this;
        }
    }
}

