/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.spi;

import io.grpc.ManagedChannelBuilder;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.quarkus.grpc.runtime.config.GrpcClientConfiguration;
import io.quarkus.grpc.runtime.config.GrpcServerConfiguration;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import io.vertx.core.Vertx;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface GrpcBuilderProvider<S extends ServerBuilder<S>> {
    public static final Logger log = LoggerFactory.getLogger(GrpcBuilderProvider.class);

    public static GrpcBuilderProvider findServerBuilderProvider(GrpcServerConfiguration configuration) {
        GrpcBuilderProvider provider = null;
        ServiceLoader<GrpcBuilderProvider> providers = ServiceLoader.load(GrpcBuilderProvider.class);
        for (GrpcBuilderProvider p : providers) {
            if (!p.providesServer(configuration)) continue;
            if (provider != null) {
                throw new IllegalArgumentException("Too many GrpcBuilderProviders enabled: " + providers);
            }
            log.info("Found server GrpcBuilderProvider: {}", (Object)p);
            provider = p;
        }
        return provider;
    }

    public static GrpcBuilderProvider findChannelBuilderProvider(GrpcClientConfiguration configuration) {
        GrpcBuilderProvider provider = null;
        ServiceLoader<GrpcBuilderProvider> providers = ServiceLoader.load(GrpcBuilderProvider.class);
        for (GrpcBuilderProvider p : providers) {
            if (!p.providesChannel(configuration)) continue;
            if (provider != null) {
                throw new IllegalArgumentException("Too many GrpcBuilderProviders enabled: " + providers);
            }
            log.info("Found channel GrpcBuilderProvider: {}", (Object)p);
            provider = p;
        }
        return provider;
    }

    public boolean providesServer(GrpcServerConfiguration var1);

    public ServerBuilder<S> createServerBuilder(Vertx var1, GrpcServerConfiguration var2, LaunchMode var3);

    public void startServer(Server var1) throws Exception;

    public void postStartup(Server var1, ShutdownContext var2);

    public void devModeReload(List<ServerServiceDefinition> var1, Map<String, ServerMethodDefinition<?, ?>> var2, List<ServerInterceptor> var3, ShutdownContext var4);

    public boolean serverAlreadyExists();

    public String serverInfo(String var1, int var2, GrpcServerConfiguration var3);

    public boolean providesChannel(GrpcClientConfiguration var1);

    public String resolver();

    default public String adjustHost(String host) {
        return host;
    }

    public ManagedChannelBuilder<?> createChannelBuilder(GrpcClientConfiguration var1, String var2);

    public String channelInfo(GrpcClientConfiguration var1);
}

