/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.stork;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.Context;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.quarkus.grpc.runtime.stork.AbstractStorkMeasuringCall;
import io.quarkus.grpc.runtime.stork.StorkMeasuringCallListener;
import io.quarkus.grpc.runtime.stork.StorkMeasuringCollector;
import io.smallrye.stork.api.ServiceInstance;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.Prioritized;
import java.util.concurrent.atomic.AtomicReference;

@ApplicationScoped
public class VertxStorkMeasuringGrpcInterceptor
implements ClientInterceptor,
Prioritized {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        boolean recordTime = method.getType() == MethodDescriptor.MethodType.UNARY;
        Context context = Context.current().withValues(StorkMeasuringCollector.STORK_SERVICE_INSTANCE, new AtomicReference(), StorkMeasuringCollector.STORK_MEASURE_TIME, (Object)recordTime);
        Context oldContext = context.attach();
        try {
            VertxStorkMeasuringCall vertxStorkMeasuringCall = new VertxStorkMeasuringCall(next.newCall(method, callOptions), recordTime);
            return vertxStorkMeasuringCall;
        }
        finally {
            context.detach(oldContext);
        }
    }

    public int getPriority() {
        return 2147483547;
    }

    private static class VertxStorkMeasuringCall<ReqT, RespT>
    extends AbstractStorkMeasuringCall<ReqT, RespT> {
        ServiceInstance serviceInstance;

        protected VertxStorkMeasuringCall(ClientCall<ReqT, RespT> delegate, boolean recordTime) {
            super(delegate, recordTime);
        }

        @Override
        protected ServiceInstance serviceInstance() {
            return this.serviceInstance;
        }

        public void start(ClientCall.Listener<RespT> responseListener, Metadata metadata) {
            AtomicReference ref = (AtomicReference)STORK_SERVICE_INSTANCE.get();
            if (ref != null) {
                this.serviceInstance = (ServiceInstance)ref.get();
            }
            super.start(new StorkMeasuringCallListener<RespT>(responseListener, this), metadata);
        }
    }
}

