/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.quarkus.grpc.ExceptionHandler;
import java.util.Optional;

public interface ExceptionHandlerProvider {
    public <ReqT, RespT> ExceptionHandler<ReqT, RespT> createHandler(ServerCall.Listener<ReqT> var1, ServerCall<ReqT, RespT> var2, Metadata var3);

    default public Throwable transform(Throwable t) {
        return ExceptionHandlerProvider.toStatusException(t, false);
    }

    public static Exception toStatusException(Throwable t, boolean runtime) {
        if (t instanceof StatusException || t instanceof StatusRuntimeException) {
            if (runtime) {
                if (t instanceof StatusRuntimeException) {
                    return (Exception)t;
                }
                StatusException se = (StatusException)t;
                return new StatusRuntimeException(se.getStatus(), se.getTrailers());
            }
            if (t instanceof StatusException) {
                return (Exception)t;
            }
            StatusRuntimeException sre = (StatusRuntimeException)t;
            return new StatusException(sre.getStatus(), sre.getTrailers());
        }
        Object desc = t.getClass().getName();
        if (t.getMessage() != null) {
            desc = (String)desc + " - " + t.getMessage();
        }
        Status status = t instanceof IllegalArgumentException ? Status.INVALID_ARGUMENT.withDescription((String)desc) : Status.fromThrowable((Throwable)t).withDescription((String)desc);
        return runtime ? status.asRuntimeException() : status.asException();
    }

    public static Status toStatus(Throwable t) {
        if (t instanceof StatusException) {
            return ((StatusException)t).getStatus();
        }
        if (t instanceof StatusRuntimeException) {
            return ((StatusRuntimeException)t).getStatus();
        }
        Object desc = t.getClass().getName();
        if (t.getMessage() != null) {
            desc = (String)desc + " - " + t.getMessage();
        }
        if (t instanceof IllegalArgumentException) {
            return Status.INVALID_ARGUMENT.withDescription((String)desc);
        }
        return Status.fromThrowable((Throwable)t).withDescription((String)desc);
    }

    public static Optional<Metadata> toTrailers(Throwable t) {
        Metadata trailers = null;
        if (t instanceof StatusException) {
            trailers = ((StatusException)t).getTrailers();
        } else if (t instanceof StatusRuntimeException) {
            trailers = ((StatusRuntimeException)t).getTrailers();
        }
        return Optional.ofNullable(trailers);
    }
}

