/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.devconsole;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.hibernate.LockOptions;
import org.hibernate.boot.Metadata;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.schema.TargetType;
import org.hibernate.tool.schema.internal.exec.ScriptTargetOutputToWriter;
import org.hibernate.tool.schema.spi.ScriptTargetOutput;
import org.hibernate.tool.schema.spi.TargetDescriptor;

public class HibernateOrmDevConsoleInfoSupplier
implements Supplier<PersistenceUnitsInfo> {
    private static final String DEFAULT = "<default>";
    public static final PersistenceUnitsInfo INSTANCE = new PersistenceUnitsInfo();

    public static void pushPersistenceUnit(String persistenceUnitName, Metadata metadata, ServiceRegistry serviceRegistry, String importFile) {
        ArrayList<EntityInfo> managedEntities = new ArrayList<EntityInfo>();
        for (Object entityBinding : metadata.getEntityBindings()) {
            managedEntities.add(new EntityInfo(entityBinding.getClassName(), entityBinding.getTable().getName()));
        }
        ArrayList<QueryInfo> namedQueries = new ArrayList<QueryInfo>();
        for (Object queryDefinition : metadata.getNamedQueryDefinitions()) {
            namedQueries.add(new QueryInfo((NamedQueryDefinition)queryDefinition));
        }
        ArrayList<QueryInfo> namedNativeQueries = new ArrayList<QueryInfo>();
        for (NamedSQLQueryDefinition staticQueryDefinition : metadata.getNamedNativeQueryDefinitions()) {
            namedNativeQueries.add(new QueryInfo((NamedQueryDefinition)staticQueryDefinition));
        }
        String createDDL = HibernateOrmDevConsoleInfoSupplier.generateDDL(SchemaExport.Action.CREATE, metadata, serviceRegistry, importFile);
        String dropDDL = HibernateOrmDevConsoleInfoSupplier.generateDDL(SchemaExport.Action.DROP, metadata, serviceRegistry, importFile);
        HibernateOrmDevConsoleInfoSupplier.INSTANCE.persistenceUnits.put(persistenceUnitName, new PersistenceUnitInfo(persistenceUnitName, managedEntities, namedQueries, namedNativeQueries, createDDL, dropDDL));
    }

    public static void clearData() {
        HibernateOrmDevConsoleInfoSupplier.INSTANCE.persistenceUnits.clear();
    }

    private static String generateDDL(SchemaExport.Action action, Metadata metadata, ServiceRegistry serviceRegistry, String importFiles) {
        SchemaExport schemaExport = new SchemaExport();
        schemaExport.setFormat(true);
        schemaExport.setDelimiter(";");
        schemaExport.setImportFiles(importFiles);
        final StringWriter writer = new StringWriter();
        try {
            schemaExport.doExecution(action, false, metadata, serviceRegistry, new TargetDescriptor(){

                public EnumSet<TargetType> getTargetTypes() {
                    return EnumSet.of(TargetType.SCRIPT);
                }

                public ScriptTargetOutput getScriptTargetOutput() {
                    return new ScriptTargetOutputToWriter(writer){

                        public void accept(String command) {
                            super.accept(command);
                        }
                    };
                }
            });
        }
        catch (RuntimeException e) {
            StringWriter stackTraceWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stackTraceWriter));
            return "Could not generate DDL: \n" + stackTraceWriter.toString();
        }
        return writer.toString();
    }

    @Override
    public PersistenceUnitsInfo get() {
        return INSTANCE;
    }

    static class PersistenceUnitNameComparator
    implements Comparator<String> {
        PersistenceUnitNameComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (HibernateOrmDevConsoleInfoSupplier.DEFAULT.equals(o1)) {
                return -1;
            }
            if (HibernateOrmDevConsoleInfoSupplier.DEFAULT.equals(o2)) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    }

    public static class QueryInfo {
        private final String name;
        private final String query;
        private final boolean cacheable;
        private final String lockMode;
        private final String type;

        public QueryInfo(NamedQueryDefinition queryDefinition) {
            this.name = queryDefinition.getName();
            this.query = queryDefinition.getQuery();
            this.cacheable = queryDefinition.isCacheable();
            LockOptions lockOptions = queryDefinition.getLockOptions();
            this.lockMode = lockOptions != null && lockOptions.getLockMode() != null ? lockOptions.getLockMode().name() : "";
            this.type = queryDefinition instanceof NamedSQLQueryDefinition ? "native" : "JPQL";
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query;
        }

        public boolean isCacheable() {
            return this.cacheable;
        }

        public String getLockMode() {
            return this.lockMode;
        }

        public String getType() {
            return this.type;
        }
    }

    public static class EntityInfo {
        private final String className;
        private final String tableName;

        public EntityInfo(String className, String tableName) {
            this.className = className;
            this.tableName = tableName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getTableName() {
            return this.tableName;
        }
    }

    public static class PersistenceUnitInfo {
        private final String name;
        private final List<EntityInfo> managedEntities;
        private final List<QueryInfo> namedQueries;
        private final List<QueryInfo> namedNativeQueries;
        private final String createDDL;
        private final String dropDDL;

        public PersistenceUnitInfo(String name, List<EntityInfo> managedEntities, List<QueryInfo> namedQueries, List<QueryInfo> namedNativeQueries, String createDDL, String dropDDL) {
            this.name = name;
            this.managedEntities = managedEntities;
            this.namedQueries = namedQueries;
            this.namedNativeQueries = namedNativeQueries;
            this.createDDL = createDDL;
            this.dropDDL = dropDDL;
        }

        public String getName() {
            return this.name;
        }

        public List<EntityInfo> getManagedEntities() {
            return this.managedEntities;
        }

        public List<QueryInfo> getNamedQueries() {
            return this.namedQueries;
        }

        public List<QueryInfo> getNamedNativeQueries() {
            return this.namedNativeQueries;
        }

        public List<QueryInfo> getAllNamedQueries() {
            ArrayList<QueryInfo> allQueries = new ArrayList<QueryInfo>();
            allQueries.addAll(this.namedQueries);
            allQueries.addAll(this.namedNativeQueries);
            return allQueries;
        }

        public String getCreateDDL() {
            return this.createDDL;
        }

        public String getDropDDL() {
            return this.dropDDL;
        }
    }

    public static class PersistenceUnitsInfo {
        private final Map<String, PersistenceUnitInfo> persistenceUnits = Collections.synchronizedMap(new TreeMap(new PersistenceUnitNameComparator()));

        public Collection<PersistenceUnitInfo> getPersistenceUnits() {
            return this.persistenceUnits.values();
        }

        public int getNumberOfNamedQueries() {
            return this.persistenceUnits.values().stream().map(PersistenceUnitInfo::getAllNamedQueries).mapToInt(List::size).reduce(Integer::sum).orElse(0);
        }

        public int getNumberOfEntities() {
            return this.persistenceUnits.values().stream().map(PersistenceUnitInfo::getManagedEntities).mapToInt(List::size).reduce(Integer::sum).orElse(0);
        }
    }
}

