/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.configuration.ConfigurationError;
import io.quarkus.hibernate.orm.deployment.ClassNames;
import io.quarkus.hibernate.orm.deployment.HibernateOrmAnnotations;
import io.quarkus.hibernate.orm.deployment.JpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.JpaModelPersistenceUnitContributionBuildItem;
import io.quarkus.hibernate.orm.deployment.xml.QuarkusMappingFileParser;
import io.quarkus.hibernate.orm.runtime.boot.xml.RecordableXmlMapping;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmCompositeAttributeType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmDiscriminatorSubclassEntityType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmEntityBaseDefinition;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmRootEntityType;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddable;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntity;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappings;
import org.hibernate.boot.jaxb.mapping.spi.JaxbMappedSuperclass;
import org.hibernate.boot.jaxb.mapping.spi.ManagedType;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public final class JpaJandexScavenger {
    public static final List<DotName> EMBEDDED_ANNOTATIONS = Arrays.asList(ClassNames.EMBEDDED, ClassNames.ELEMENT_COLLECTION);
    private static final String XML_MAPPING_DEFAULT_ORM_XML = "META-INF/orm.xml";
    private static final String XML_MAPPING_NO_FILE = "no-file";
    private final BuildProducer<ReflectiveClassBuildItem> reflectiveClass;
    private final BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles;
    private final List<JpaModelPersistenceUnitContributionBuildItem> persistenceUnitContributions;
    private final IndexView index;
    private final Set<String> ignorableNonIndexedClasses;

    JpaJandexScavenger(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles, List<JpaModelPersistenceUnitContributionBuildItem> persistenceUnitContributions, IndexView index, Set<String> ignorableNonIndexedClasses) {
        this.reflectiveClass = reflectiveClass;
        this.hotDeploymentWatchedFiles = hotDeploymentWatchedFiles;
        this.persistenceUnitContributions = persistenceUnitContributions;
        this.index = index;
        this.ignorableNonIndexedClasses = ignorableNonIndexedClasses;
    }

    public JpaModelBuildItem discoverModelAndRegisterForReflection() {
        Collector collector = new Collector();
        for (DotName dotName : HibernateOrmAnnotations.PACKAGE_ANNOTATIONS) {
            this.enlistJPAModelAnnotatedPackages(collector, dotName);
        }
        this.enlistJPAModelClasses(collector, ClassNames.JPA_ENTITY);
        this.enlistJPAModelClasses(collector, ClassNames.EMBEDDABLE);
        this.enlistJPAModelClasses(collector, ClassNames.MAPPED_SUPERCLASS);
        this.enlistEmbeddedsAndElementCollections(collector);
        for (JpaModelPersistenceUnitContributionBuildItem jpaModelPersistenceUnitContributionBuildItem : this.persistenceUnitContributions) {
            this.enlistExplicitMappings(collector, jpaModelPersistenceUnitContributionBuildItem);
        }
        HashSet<String> allModelClassNames = new HashSet<String>(collector.entityTypes);
        allModelClassNames.addAll(collector.managedTypes);
        for (String className : allModelClassNames) {
            this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{className}));
        }
        if (!collector.enumTypes.isEmpty()) {
            this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"java.lang.Enum"}));
            for (String className : collector.enumTypes) {
                this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{className}));
            }
        }
        for (String javaType : collector.javaTypes) {
            this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{javaType}));
        }
        if (!collector.unindexedClasses.isEmpty()) {
            Set set = collector.unindexedClasses.stream().map(DotName::toString).collect(Collectors.toSet());
            set.removeAll(this.ignorableNonIndexedClasses);
            if (!set.isEmpty()) {
                String unindexedClassesErrorMessage = set.stream().map(d -> "\t- " + d + "\n").collect(Collectors.joining());
                throw new ConfigurationError("Unable to properly register the hierarchy of the following JPA classes as they are not in the Jandex index:\n" + unindexedClassesErrorMessage + "Consider adding them to the index either by creating a Jandex index for your dependency via the Maven plugin, an empty META-INF/beans.xml or quarkus.index-dependency properties.");
            }
        }
        return new JpaModelBuildItem(collector.packages, collector.entityTypes, allModelClassNames, collector.xmlMappingsByPU);
    }

    private void enlistExplicitMappings(Collector collector, JpaModelPersistenceUnitContributionBuildItem persistenceUnitContribution) {
        for (String className : persistenceUnitContribution.explicitlyListedClassNames) {
            this.enlistExplicitClass(collector, className);
        }
        LinkedHashSet<String> mappingFileNames = new LinkedHashSet<String>(persistenceUnitContribution.explicitlyListedMappingFiles);
        if (!mappingFileNames.remove(XML_MAPPING_NO_FILE)) {
            mappingFileNames.add(XML_MAPPING_DEFAULT_ORM_XML);
        }
        try (QuarkusMappingFileParser parser = QuarkusMappingFileParser.create();){
            for (String mappingFileName : mappingFileNames) {
                this.hotDeploymentWatchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(mappingFileName));
                Optional<RecordableXmlMapping> mappingOptional = parser.parse(persistenceUnitContribution.persistenceUnitName, persistenceUnitContribution.persistenceUnitRootURL, mappingFileName);
                if (!mappingOptional.isPresent()) {
                    if (!persistenceUnitContribution.explicitlyListedMappingFiles.contains(mappingFileName)) continue;
                    throw new IllegalStateException("Cannot find ORM mapping file '" + mappingFileName + "' in the classpath");
                }
                RecordableXmlMapping mapping = mappingOptional.get();
                if (mapping.getOrmXmlRoot() != null) {
                    this.enlistOrmXmlMapping(collector, mapping.getOrmXmlRoot());
                }
                if (mapping.getHbmXmlRoot() != null) {
                    this.enlistHbmXmlMapping(collector, mapping.getHbmXmlRoot());
                }
                collector.xmlMappingsByPU.computeIfAbsent(persistenceUnitContribution.persistenceUnitName, ignored -> new ArrayList()).add(mapping);
            }
        }
    }

    private void enlistOrmXmlMapping(Collector collector, JaxbEntityMappings mapping) {
        String name;
        String packageName = mapping.getPackage();
        Object packagePrefix = packageName == null ? "" : packageName + ".";
        for (JaxbEntity entity : mapping.getEntity()) {
            name = JpaJandexScavenger.safeGetClassName((String)packagePrefix, (ManagedType)entity, "entity");
            this.enlistExplicitClass(collector, name);
            collector.entityTypes.add(name);
        }
        for (JaxbMappedSuperclass mappedSuperclass : mapping.getMappedSuperclass()) {
            name = JpaJandexScavenger.safeGetClassName((String)packagePrefix, (ManagedType)mappedSuperclass, "mapped-superclass");
            this.enlistExplicitClass(collector, name);
        }
        for (JaxbEmbeddable embeddable : mapping.getEmbeddable()) {
            name = JpaJandexScavenger.safeGetClassName((String)packagePrefix, (ManagedType)embeddable, "embeddable");
            this.enlistExplicitClass(collector, name);
        }
    }

    private static String safeGetClassName(String packagePrefix, ManagedType managedType, String nodeName) {
        String name = managedType.getClazz();
        if (name == null) {
            throw new IllegalArgumentException("Missing attribute '" + nodeName + ".class'");
        }
        return packagePrefix + name;
    }

    private void enlistHbmXmlMapping(Collector collector, JaxbHbmHibernateMapping mapping) {
        String packageValue = mapping.getPackage();
        Object packagePrefix = packageValue == null ? "" : packageValue + ".";
        for (JaxbHbmRootEntityType entity : mapping.getClazz()) {
            this.enlistHbmXmlEntity(collector, (String)packagePrefix, (JaxbHbmEntityBaseDefinition)entity, entity.getAttributes());
            for (JaxbHbmDiscriminatorSubclassEntityType subclass : entity.getSubclass()) {
                this.enlistHbmXmlEntity(collector, (String)packagePrefix, (JaxbHbmEntityBaseDefinition)subclass, subclass.getAttributes());
            }
            for (JaxbHbmDiscriminatorSubclassEntityType subclass : entity.getUnionSubclass()) {
                this.enlistHbmXmlEntity(collector, (String)packagePrefix, (JaxbHbmEntityBaseDefinition)subclass, subclass.getAttributes());
            }
            for (JaxbHbmDiscriminatorSubclassEntityType subclass : entity.getJoinedSubclass()) {
                this.enlistHbmXmlEntity(collector, (String)packagePrefix, (JaxbHbmEntityBaseDefinition)subclass, subclass.getAttributes());
            }
        }
        for (JaxbHbmDiscriminatorSubclassEntityType subclass : mapping.getSubclass()) {
            this.enlistHbmXmlEntity(collector, (String)packagePrefix, (JaxbHbmEntityBaseDefinition)subclass, subclass.getAttributes());
        }
        for (JaxbHbmDiscriminatorSubclassEntityType subclass : mapping.getUnionSubclass()) {
            this.enlistHbmXmlEntity(collector, (String)packagePrefix, (JaxbHbmEntityBaseDefinition)subclass, subclass.getAttributes());
        }
        for (JaxbHbmDiscriminatorSubclassEntityType subclass : mapping.getJoinedSubclass()) {
            this.enlistHbmXmlEntity(collector, (String)packagePrefix, (JaxbHbmEntityBaseDefinition)subclass, subclass.getAttributes());
        }
    }

    private void enlistHbmXmlEntity(Collector collector, String packagePrefix, JaxbHbmEntityBaseDefinition entityDefinition, List<?> attributes) {
        String name = packagePrefix + entityDefinition.getName();
        this.enlistExplicitClass(collector, name);
        collector.entityTypes.add(name);
        this.collectHbmXmlEmbeddedTypes(collector, packagePrefix, attributes);
    }

    private void collectHbmXmlEmbeddedTypes(Collector collector, String packagePrefix, List<?> attributes) {
        for (Object attribute : attributes) {
            if (!(attribute instanceof JaxbHbmCompositeAttributeType)) continue;
            JaxbHbmCompositeAttributeType compositeAttribute = (JaxbHbmCompositeAttributeType)attribute;
            String name = packagePrefix + compositeAttribute.getClazz();
            this.enlistExplicitClass(collector, name);
            collector.entityTypes.add(name);
            this.collectHbmXmlEmbeddedTypes(collector, packagePrefix, attributes);
        }
    }

    private void enlistExplicitClass(Collector collector, String className) {
        DotName dotName = DotName.createSimple((String)className);
        this.addClassHierarchyToReflectiveList(collector, dotName);
    }

    private void enlistEmbeddedsAndElementCollections(Collector collector) {
        HashSet<DotName> embeddedTypes = new HashSet<DotName>();
        for (DotName embeddedAnnotation : EMBEDDED_ANNOTATIONS) {
            Collection annotations = this.index.getAnnotations(embeddedAnnotation);
            block5: for (AnnotationInstance annotation : annotations) {
                AnnotationTarget target = annotation.target();
                switch (target.kind()) {
                    case FIELD: {
                        JpaJandexScavenger.collectEmbeddedTypes(embeddedTypes, target.asField().type());
                        continue block5;
                    }
                    case METHOD: {
                        JpaJandexScavenger.collectEmbeddedTypes(embeddedTypes, target.asMethod().returnType());
                        continue block5;
                    }
                }
                throw new IllegalStateException("[internal error] " + embeddedAnnotation + " placed on a unknown element: " + target);
            }
        }
        for (DotName embeddedType : embeddedTypes) {
            this.addClassHierarchyToReflectiveList(collector, embeddedType);
        }
    }

    private void enlistJPAModelAnnotatedPackages(Collector collector, DotName dotName) {
        Collection jpaAnnotations = this.index.getAnnotations(dotName);
        if (jpaAnnotations == null) {
            return;
        }
        for (AnnotationInstance annotation : jpaAnnotations) {
            ClassInfo klass;
            if (annotation.target().kind() != AnnotationTarget.Kind.CLASS || !(klass = annotation.target().asClass()).simpleName().equals("package-info")) continue;
            JpaJandexScavenger.collectPackage(collector, klass);
        }
    }

    private void enlistJPAModelClasses(Collector collector, DotName dotName) {
        Collection jpaAnnotations = this.index.getAnnotations(dotName);
        if (jpaAnnotations == null) {
            return;
        }
        for (AnnotationInstance annotation : jpaAnnotations) {
            ClassInfo klass = annotation.target().asClass();
            DotName targetDotName = klass.name();
            this.addClassHierarchyToReflectiveList(collector, targetDotName);
            JpaJandexScavenger.collectDomainObject(collector, klass);
        }
    }

    private void addClassHierarchyToReflectiveList(Collector collector, DotName className) {
        if (className == null || JpaJandexScavenger.isIgnored(className)) {
            return;
        }
        if (JpaJandexScavenger.isInJavaPackage(className)) {
            collector.javaTypes.add(className.toString());
            return;
        }
        ClassInfo classInfo = this.index.getClassByName(className);
        if (classInfo == null) {
            collector.unindexedClasses.add(className);
            return;
        }
        for (FieldInfo fieldInfo : classInfo.fields()) {
            DotName fieldClassName;
            ClassInfo fieldTypeClassInfo;
            Type fieldType = fieldInfo.type();
            if (Type.Kind.CLASS != fieldType.kind() || (fieldTypeClassInfo = this.index.getClassByName(fieldClassName = fieldInfo.type().name())) == null || !ClassNames.ENUM.equals((Object)fieldTypeClassInfo.superName())) continue;
            collector.enumTypes.add(fieldClassName.toString());
        }
        JpaJandexScavenger.collectDomainObject(collector, classInfo);
        this.addClassHierarchyToReflectiveList(collector, classInfo.superName());
        for (DotName interfaceDotName : classInfo.interfaceNames()) {
            this.addClassHierarchyToReflectiveList(collector, interfaceDotName);
        }
    }

    private static void collectPackage(Collector collector, ClassInfo classOrPackageInfo) {
        String classOrPackageInfoName = classOrPackageInfo.name().toString();
        String packageName = classOrPackageInfoName.substring(0, classOrPackageInfoName.lastIndexOf(46));
        collector.packages.add(packageName);
    }

    private static void collectDomainObject(Collector collector, ClassInfo modelClass) {
        String name = modelClass.name().toString();
        collector.managedTypes.add(name);
        if (modelClass.classAnnotation(ClassNames.JPA_ENTITY) != null) {
            collector.entityTypes.add(name);
        }
    }

    private static void collectEmbeddedTypes(Set<DotName> embeddedTypes, Type indexType) {
        switch (indexType.kind()) {
            case CLASS: {
                embeddedTypes.add(indexType.asClassType().name());
                break;
            }
            case PARAMETERIZED_TYPE: {
                embeddedTypes.add(indexType.name());
                for (Type typeArgument : indexType.asParameterizedType().arguments()) {
                    JpaJandexScavenger.collectEmbeddedTypes(embeddedTypes, typeArgument);
                }
                break;
            }
            case ARRAY: {
                JpaJandexScavenger.collectEmbeddedTypes(embeddedTypes, indexType.asArrayType().component());
                break;
            }
        }
    }

    private static boolean isIgnored(DotName classDotName) {
        String className = classDotName.toString();
        return className.startsWith("java.util.") || className.startsWith("java.lang.") || className.startsWith("org.hibernate.engine.spi.") || className.startsWith("javax.persistence.");
    }

    private static boolean isInJavaPackage(DotName classDotName) {
        String className = classDotName.toString();
        return className.startsWith("java.");
    }

    private static class Collector {
        final Set<String> packages = new HashSet<String>();
        final Set<String> entityTypes = new HashSet<String>();
        final Set<String> managedTypes = new HashSet<String>();
        final Set<String> enumTypes = new HashSet<String>();
        final Set<String> javaTypes = new HashSet<String>();
        final Set<DotName> unindexedClasses = new HashSet<DotName>();
        final Map<String, List<RecordableXmlMapping>> xmlMappingsByPU = new HashMap<String, List<RecordableXmlMapping>>();

        private Collector() {
        }
    }
}

