/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.datasource.common.runtime.DatabaseKind;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfig;
import io.quarkus.runtime.configuration.ConfigurationException;

public final class Dialects {
    private Dialects() {
    }

    public static String guessDialect(String persistenceUnitName, String resolvedDbKind) {
        if (DatabaseKind.isDB2((String)resolvedDbKind)) {
            return "org.hibernate.dialect.DB297Dialect";
        }
        if (DatabaseKind.isPostgreSQL((String)resolvedDbKind)) {
            return "io.quarkus.hibernate.orm.runtime.dialect.QuarkusPostgreSQL10Dialect";
        }
        if (DatabaseKind.isH2((String)resolvedDbKind)) {
            return "io.quarkus.hibernate.orm.runtime.dialect.QuarkusH2Dialect";
        }
        if (DatabaseKind.isMariaDB((String)resolvedDbKind)) {
            return "org.hibernate.dialect.MariaDB103Dialect";
        }
        if (DatabaseKind.isMySQL((String)resolvedDbKind)) {
            return "org.hibernate.dialect.MySQL8Dialect";
        }
        if (DatabaseKind.isOracle((String)resolvedDbKind)) {
            return "org.hibernate.dialect.Oracle12cDialect";
        }
        if (DatabaseKind.isDerby((String)resolvedDbKind)) {
            return "org.hibernate.dialect.DerbyTenSevenDialect";
        }
        if (DatabaseKind.isMsSQL((String)resolvedDbKind)) {
            return "org.hibernate.dialect.SQLServer2016Dialect";
        }
        String error = "Hibernate extension could not guess the dialect from the database kind '" + resolvedDbKind + "'. Add an explicit '" + HibernateOrmConfig.puPropertyKey(persistenceUnitName, "dialect") + "' property.";
        throw new ConfigurationException(error);
    }
}

