/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.runtime.customized;

import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import org.hibernate.reactive.context.Context;
import org.hibernate.reactive.context.impl.VertxContext;

public final class CheckingVertxContext
extends VertxContext {
    private static final String ERROR_MSG_ON_PROHIBITED_CONTEXT;
    private static final String ERROR_MSG_ON_UNKNOWN_CONTEXT;

    public <T> void put(Context.Key<T> key, T instance) {
        VertxContextSafetyToggle.validateContextIfExists((String)ERROR_MSG_ON_PROHIBITED_CONTEXT, (String)ERROR_MSG_ON_UNKNOWN_CONTEXT);
        super.put(key, instance);
    }

    public <T> T get(Context.Key<T> key) {
        VertxContextSafetyToggle.validateContextIfExists((String)ERROR_MSG_ON_PROHIBITED_CONTEXT, (String)ERROR_MSG_ON_UNKNOWN_CONTEXT);
        return (T)super.get(key);
    }

    public void remove(Context.Key<?> key) {
        VertxContextSafetyToggle.validateContextIfExists((String)ERROR_MSG_ON_PROHIBITED_CONTEXT, (String)ERROR_MSG_ON_UNKNOWN_CONTEXT);
        super.remove(key);
    }

    static {
        String sharedmsg = " You can still use Hibernate Reactive, you just need to avoid using the methods which implicitly require accessing the stateful context, such as MutinySessionFactory#withTransaction and #withSession.";
        ERROR_MSG_ON_UNKNOWN_CONTEXT = "The current operation requires a safe (isolated) Vert.x sub-context, but the current context hasn't been flagged as such. You can still use Hibernate Reactive, you just need to avoid using the methods which implicitly require accessing the stateful context, such as MutinySessionFactory#withTransaction and #withSession.";
        ERROR_MSG_ON_PROHIBITED_CONTEXT = "The current Hibernate Reactive operation requires a safe (isolated) Vert.x sub-context, while the current context has been explicitly flagged as not compatible for this purpose. You can still use Hibernate Reactive, you just need to avoid using the methods which implicitly require accessing the stateful context, such as MutinySessionFactory#withTransaction and #withSession.";
    }
}

