/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.runtime.jaxrs;

import io.quarkus.arc.DefaultBean;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.inject.Singleton;
import javax.ws.rs.core.HttpHeaders;
import org.hibernate.validator.spi.messageinterpolation.LocaleResolver;
import org.hibernate.validator.spi.messageinterpolation.LocaleResolverContext;
import org.jboss.resteasy.core.ResteasyContext;

@Singleton
@DefaultBean
public class ResteasyContextLocaleResolver
implements LocaleResolver {
    public Locale resolve(LocaleResolverContext context) {
        Optional<List<Locale.LanguageRange>> localePriorities = this.getAcceptableLanguages();
        if (!localePriorities.isPresent()) {
            return context.getDefaultLocale();
        }
        List<Locale> resolvedLocales = Locale.filter(localePriorities.get(), context.getSupportedLocales());
        if (resolvedLocales.size() > 0) {
            return resolvedLocales.get(0);
        }
        return context.getDefaultLocale();
    }

    private Optional<List<Locale.LanguageRange>> getAcceptableLanguages() {
        List acceptLanguageList;
        HttpHeaders httpHeaders = (HttpHeaders)ResteasyContext.getContextData(HttpHeaders.class);
        if (httpHeaders != null && (acceptLanguageList = httpHeaders.getRequestHeader("Accept-Language")) != null && !acceptLanguageList.isEmpty()) {
            return Optional.of(Locale.LanguageRange.parse((String)acceptLanguageList.get(0)));
        }
        return Optional.empty();
    }
}

