/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.hibernate.validator.runtime.CloseAsNoopValidatorFactoryWrapper;
import java.lang.annotation.Annotation;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.HibernateValidatorFactory;

public final class ValidationSupport {
    private ValidationSupport() {
    }

    public static ValidatorFactory buildDefaultValidatorFactory() {
        ArcContainer container = Arc.container();
        if (container == null) {
            return ValidationSupport.fallback();
        }
        InstanceHandle instance = container.instance(HibernateValidatorFactory.class, new Annotation[0]);
        if (!instance.isAvailable()) {
            return ValidationSupport.fallback();
        }
        return new CloseAsNoopValidatorFactoryWrapper((HibernateValidatorFactory)instance.get());
    }

    private static ValidatorFactory fallback() {
        return Validation.byDefaultProvider().configure().buildValidatorFactory();
    }
}

