/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.infinispan.client.runtime;

import io.quarkus.infinispan.client.runtime.InfinispanClientBuildTimeConfig;
import io.quarkus.infinispan.client.runtime.InfinispanClientUtil;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@ConfigRoot(name="infinispan-client", phase=ConfigPhase.BUILD_AND_RUN_TIME_FIXED)
public class InfinispanClientsBuildTimeConfig {
    @ConfigItem(name="<<parent>>")
    public InfinispanClientBuildTimeConfig defaultInfinispanClient;
    @ConfigItem(name="<<parent>>")
    public Map<String, InfinispanClientBuildTimeConfig> namedInfinispanClients;
    @ConfigItem(name="health.enabled", defaultValue="true")
    public boolean healthEnabled;

    public Set<String> getInfinispanNamedClientConfigNames() {
        return Collections.unmodifiableSet(new HashSet<String>(this.namedInfinispanClients.keySet()));
    }

    public InfinispanClientBuildTimeConfig getInfinispanClientBuildTimeConfig(String infinispanClientName) {
        if (InfinispanClientUtil.isDefault(infinispanClientName)) {
            return this.defaultInfinispanClient;
        }
        return this.namedInfinispanClients.get(infinispanClientName);
    }
}

