/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.infinispan.client.runtime;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

@ConfigGroup
public class InfinispanDevServicesConfig {
    @ConfigItem(defaultValue="true")
    public boolean enabled;
    @ConfigItem
    public OptionalInt port;
    @ConfigItem(defaultValue="true")
    public boolean shared;
    @ConfigItem(defaultValue="infinispan")
    public String serviceName;
    @ConfigItem
    public Optional<String> imageName = Optional.empty();
    @ConfigItem
    public Optional<List<String>> artifacts;
    @ConfigItem
    public Optional<String> site;
    @ConfigItem
    public OptionalInt mcastPort;
    @ConfigItem(name="tracing.enabled", defaultValue="false")
    public Optional<Boolean> tracing;
    @ConfigItem(name="tracing.exporter.otlp.endpoint", defaultValue="http://localhost:4317")
    public Optional<String> exporterOtlpEndpoint;
    @ConfigItem
    public Map<String, String> containerEnv;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InfinispanDevServicesConfig that = (InfinispanDevServicesConfig)o;
        return this.enabled == that.enabled && Objects.equals(this.port, that.port) && Objects.equals(this.shared, that.shared) && Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.imageName, that.imageName) && Objects.equals(this.artifacts, this.artifacts) && Objects.equals(this.containerEnv, that.containerEnv);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.port, this.shared, this.serviceName, this.imageName, this.artifacts, this.containerEnv);
    }

    public String toString() {
        return "InfinispanDevServicesConfig{enabled=" + this.enabled + ", port=" + this.port + ", shared=" + this.shared + ", serviceName='" + this.serviceName + "', imageName=" + this.imageName + ", artifacts=" + this.artifacts + ", site=" + this.site + ", mcastPort=" + this.mcastPort + ", tracing=" + this.tracing + ", exporterOtlpEndpoint=" + this.exporterOtlpEndpoint + "}";
    }
}

