/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.mockito.internal;

import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildContext;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.test.junit.buildchain.TestBuildChainCustomizerProducer;
import io.quarkus.test.junit.mockito.InjectMock;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;

public class UnremoveableMockTestBuildChainCustomizerProducer
implements TestBuildChainCustomizerProducer {
    private static final DotName INJECT_MOCK = DotName.createSimple((String)InjectMock.class.getName());

    public Consumer<BuildChainBuilder> produce(final Index testClassesIndex) {
        return new Consumer<BuildChainBuilder>(){

            @Override
            public void accept(BuildChainBuilder buildChainBuilder) {
                buildChainBuilder.addBuildStep(new BuildStep(){

                    public void execute(BuildContext context) {
                        HashSet<String> mockTypes = new HashSet<String>();
                        List instances = testClassesIndex.getAnnotations(INJECT_MOCK);
                        for (AnnotationInstance instance : instances) {
                            mockTypes.add(instance.target().asField().type().name().toString());
                        }
                        context.produce((BuildItem)new UnremovableBeanBuildItem(new UnremovableBeanBuildItem.BeanClassNamesExclusion(mockTypes)));
                    }
                }).produces(UnremovableBeanBuildItem.class).build();
            }
        };
    }
}

