/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.runtime.graal;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import org.apache.kafka.common.record.CompressionType;

@TargetClass(value=CompressionType.class)
final class FixEnumAccess {
    FixEnumAccess() {
    }

    @Substitute
    public static CompressionType forName(String name) {
        if (CompressionType.NONE.name.equals(name)) {
            return CompressionType.NONE;
        }
        if (CompressionType.GZIP.name.equals(name)) {
            return CompressionType.GZIP;
        }
        throw new IllegalArgumentException("Unknown  or unsupported compression name: " + name);
    }

    @Substitute
    public static CompressionType forId(int id) {
        switch (id) {
            case 0: {
                return CompressionType.NONE;
            }
            case 1: {
                return CompressionType.GZIP;
            }
        }
        throw new IllegalArgumentException("Unknown or unsupported compression type id: " + id);
    }
}

