/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.runtime.graal;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.apache.kafka.common.utils.ByteBufferUnmapper;

@TargetClass(value=ByteBufferUnmapper.class, onlyWith={JDK8OrEarlier.class})
final class Target_org_apache_kafka_common_utils_ByteBufferUnmapper {
    Target_org_apache_kafka_common_utils_ByteBufferUnmapper() {
    }

    @Substitute
    public static void unmap(String resourceDescription, ByteBuffer buffer) throws IOException {
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("Unmapping only works with direct buffers");
        }
        try {
            Method cleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
            cleanerMethod.setAccessible(true);
            Object cleaner = cleanerMethod.invoke((Object)buffer, new Object[0]);
            Method cleanMethod = cleaner.getClass().getMethod("clean", new Class[0]);
            cleanMethod.setAccessible(true);
            cleanMethod.invoke(cleaner, new Object[0]);
        }
        catch (Throwable t) {
            throw new IOException("Unable to unmap the mapped buffer: " + resourceDescription, t);
        }
    }
}

