/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LogCategoryBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.RuntimeConfigSetupCompleteBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSecurityProviderBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.deployment.pkg.NativeConfig;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.devconsole.spi.DevConsoleRouteBuildItem;
import io.quarkus.devconsole.spi.DevConsoleWebjarBuildItem;
import io.quarkus.kafka.client.deployment.KafkaBuildTimeConfig;
import io.quarkus.kafka.client.runtime.KafkaAdminClient;
import io.quarkus.kafka.client.runtime.KafkaBindingConverter;
import io.quarkus.kafka.client.runtime.KafkaRecorder;
import io.quarkus.kafka.client.runtime.KafkaRuntimeConfigProducer;
import io.quarkus.kafka.client.runtime.ui.KafkaTopicClient;
import io.quarkus.kafka.client.runtime.ui.KafkaUiRecorder;
import io.quarkus.kafka.client.runtime.ui.KafkaUiUtils;
import io.quarkus.kafka.client.serialization.BufferDeserializer;
import io.quarkus.kafka.client.serialization.BufferSerializer;
import io.quarkus.kafka.client.serialization.JsonArrayDeserializer;
import io.quarkus.kafka.client.serialization.JsonArraySerializer;
import io.quarkus.kafka.client.serialization.JsonObjectDeserializer;
import io.quarkus.kafka.client.serialization.JsonObjectSerializer;
import io.quarkus.kafka.client.serialization.JsonbDeserializer;
import io.quarkus.kafka.client.serialization.JsonbSerializer;
import io.quarkus.kafka.client.serialization.ObjectMapperDeserializer;
import io.quarkus.kafka.client.serialization.ObjectMapperSerializer;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.security.auth.spi.LoginModule;
import org.apache.kafka.clients.consumer.ConsumerInterceptor;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.consumer.StickyAssignor;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.clients.producer.ProducerInterceptor;
import org.apache.kafka.clients.producer.internals.DefaultPartitioner;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.AbstractLogin;
import org.apache.kafka.common.security.authenticator.DefaultLogin;
import org.apache.kafka.common.security.authenticator.SaslClientCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerRefreshingLogin;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslClient;
import org.apache.kafka.common.security.scram.internals.ScramSaslClient;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.ByteBufferDeserializer;
import org.apache.kafka.common.serialization.ByteBufferSerializer;
import org.apache.kafka.common.serialization.BytesDeserializer;
import org.apache.kafka.common.serialization.BytesSerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.DoubleDeserializer;
import org.apache.kafka.common.serialization.DoubleSerializer;
import org.apache.kafka.common.serialization.FloatDeserializer;
import org.apache.kafka.common.serialization.FloatSerializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.ShortDeserializer;
import org.apache.kafka.common.serialization.ShortSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.xerial.snappy.OSInfo;

public class KafkaProcessor {
    static final Class<?>[] BUILT_INS = new Class[]{ShortSerializer.class, DoubleSerializer.class, LongSerializer.class, BytesSerializer.class, ByteArraySerializer.class, IntegerSerializer.class, ByteBufferSerializer.class, StringSerializer.class, FloatSerializer.class, JsonObjectSerializer.class, JsonArraySerializer.class, BufferSerializer.class, ShortDeserializer.class, DoubleDeserializer.class, LongDeserializer.class, BytesDeserializer.class, ByteArrayDeserializer.class, IntegerDeserializer.class, ByteBufferDeserializer.class, StringDeserializer.class, FloatDeserializer.class, JsonObjectDeserializer.class, JsonArrayDeserializer.class, BufferDeserializer.class};
    static final DotName OBJECT_MAPPER = DotName.createSimple((String)"com.fasterxml.jackson.databind.ObjectMapper");
    private static final Set<String> SASL_PROVIDERS = Arrays.stream(new String[]{"com.sun.security.sasl.Provider", "org.apache.kafka.common.security.scram.internals.ScramSaslClientProvider", "org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslClientProvider"}).collect(Collectors.toSet());
    private static final DotName LOGIN_MODULE = DotName.createSimple((String)LoginModule.class.getName());
    private static final DotName AUTHENTICATE_CALLBACK_HANDLER = DotName.createSimple((String)AuthenticateCallbackHandler.class.getName());
    static final DotName PARTITION_ASSIGNER = DotName.createSimple((String)"org.apache.kafka.clients.consumer.internals.PartitionAssignor");
    private static final GACT DEVCONSOLE_WEBJAR_ARTIFACT_KEY = new GACT("io.quarkus", "quarkus-kafka-client-deployment", null, "jar");
    private static final String DEVCONSOLE_WEBJAR_STATIC_RESOURCES_PATH = "dev-static/";
    public static final String KAFKA_ADMIN_PATH = "kafka-admin";
    public static final String KAFKA_RESOURCES_ROOT_PATH = "kafka-ui";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.KAFKA_CLIENT);
    }

    @BuildStep
    void logging(BuildProducer<LogCategoryBuildItem> log) {
        log.produce((BuildItem)new LogCategoryBuildItem("org.apache.kafka.clients", Level.WARNING));
        log.produce((BuildItem)new LogCategoryBuildItem("org.apache.kafka.common.utils", Level.WARNING));
        log.produce((BuildItem)new LogCategoryBuildItem("org.apache.kafka.common.metrics", Level.WARNING));
    }

    @BuildStep
    void silenceUnwantedConfigLogs(BuildProducer<LogCleanupFilterBuildItem> logCleanupFilters) {
        String[] ignoredConfigProperties = new String[]{"wildfly.sasl.relax-compliance", "ssl.endpoint.identification.algorithm"};
        ArrayList<CallSite> ignoredMessages = new ArrayList<CallSite>();
        for (String ignoredConfigProperty : ignoredConfigProperties) {
            ignoredMessages.add((CallSite)((Object)("The configuration '" + ignoredConfigProperty + "' was supplied but isn't a known config.")));
        }
        logCleanupFilters.produce((BuildItem)new LogCleanupFilterBuildItem("org.apache.kafka.clients.consumer.ConsumerConfig", ignoredMessages));
        logCleanupFilters.produce((BuildItem)new LogCleanupFilterBuildItem("org.apache.kafka.clients.producer.ProducerConfig", ignoredMessages));
    }

    @BuildStep
    void addSaslProvidersToNativeImage(BuildProducer<NativeImageSecurityProviderBuildItem> additionalProviders) {
        for (String provider : SASL_PROVIDERS) {
            additionalProviders.produce((BuildItem)new NativeImageSecurityProviderBuildItem(provider));
        }
    }

    @BuildStep
    void contributeClassesToIndex(BuildProducer<AdditionalIndexedClassesBuildItem> additionalIndexedClasses, BuildProducer<IndexDependencyBuildItem> indexDependency) {
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("org.apache.kafka", "kafka-clients"));
    }

    @BuildStep
    void relaxSaslElytron(BuildProducer<RunTimeConfigurationDefaultBuildItem> config) {
        if (!QuarkusClassLoader.isClassPresentAtRuntime((String)"org.wildfly.security.sasl.gssapi.AbstractGssapiMechanism")) {
            return;
        }
        config.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("kafka.wildfly.sasl.relax-compliance", "true"));
    }

    @BuildStep
    public void build(KafkaBuildTimeConfig config, CombinedIndexBuildItem indexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ServiceProviderBuildItem> serviceProviders, BuildProducer<NativeImageProxyDefinitionBuildItem> proxies, Capabilities capabilities, BuildProducer<UnremovableBeanBuildItem> beans, BuildProducer<NativeImageResourceBuildItem> nativeLibs, NativeConfig nativeConfig, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport) {
        HashSet<DotName> toRegister = new HashSet<DotName>();
        KafkaProcessor.collectImplementors(toRegister, indexBuildItem, Serializer.class);
        KafkaProcessor.collectImplementors(toRegister, indexBuildItem, Deserializer.class);
        KafkaProcessor.collectImplementors(toRegister, indexBuildItem, Partitioner.class);
        KafkaProcessor.collectImplementors(toRegister, indexBuildItem, PARTITION_ASSIGNER);
        KafkaProcessor.collectImplementors(toRegister, indexBuildItem, ConsumerPartitionAssignor.class);
        KafkaProcessor.collectImplementors(toRegister, indexBuildItem, ConsumerInterceptor.class);
        KafkaProcessor.collectImplementors(toRegister, indexBuildItem, ProducerInterceptor.class);
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{OAuthBearerSaslClient.class, OAuthBearerSaslClient.OAuthBearerSaslClientFactory.class, OAuthBearerToken.class, OAuthBearerRefreshingLogin.class}));
        for (Class<?> i : BUILT_INS) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{i.getName()}));
            KafkaProcessor.collectSubclasses(toRegister, indexBuildItem, i);
        }
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{ObjectMapperSerializer.class, ObjectMapperDeserializer.class}));
        KafkaProcessor.collectSubclasses(toRegister, indexBuildItem, ObjectMapperSerializer.class);
        KafkaProcessor.collectSubclasses(toRegister, indexBuildItem, ObjectMapperDeserializer.class);
        beans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{OBJECT_MAPPER}));
        if (capabilities.isPresent("io.quarkus.jsonb")) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{JsonbSerializer.class, JsonbDeserializer.class}));
            KafkaProcessor.collectSubclasses(toRegister, indexBuildItem, JsonbSerializer.class);
            KafkaProcessor.collectSubclasses(toRegister, indexBuildItem, JsonbDeserializer.class);
        }
        for (DotName s : toRegister) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{s.toString()}));
        }
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{DefaultPartitioner.class.getName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{RangeAssignor.class.getName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{RoundRobinAssignor.class.getName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{StickyAssignor.class.getName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"java.nio.DirectByteBuffer"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"sun.misc.Cleaner"}));
        this.handleAvro(reflectiveClass, proxies, serviceProviders, sslNativeSupport, capabilities);
        this.handleOpenTracing(reflectiveClass, capabilities);
        this.handleStrimziOAuth(reflectiveClass);
        if (config.snappyEnabled) {
            this.handleSnappy(reflectiveClass, nativeLibs, nativeConfig);
        }
    }

    private void handleSnappy(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<NativeImageResourceBuildItem> nativeLibs, NativeConfig nativeConfig) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{"org.xerial.snappy.SnappyInputStream", "org.xerial.snappy.SnappyOutputStream"}));
        String root = "org/xerial/snappy/native/";
        if (nativeConfig.isContainerBuild()) {
            String dir = "Linux/x86_64";
            String snappyNativeLibraryName = "libsnappyjava.so";
            String path = root + dir + "/" + snappyNativeLibraryName;
            nativeLibs.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{path}));
        } else {
            String dir = OSInfo.getNativeLibFolderPathForCurrentOS();
            String snappyNativeLibraryName = System.mapLibraryName("snappyjava");
            String path = root + dir + "/" + snappyNativeLibraryName;
            nativeLibs.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{path}));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void loadSnappyIfEnabled(KafkaRecorder recorder, KafkaBuildTimeConfig config) {
        if (config.snappyEnabled) {
            recorder.loadSnappy();
        }
    }

    @Consume(value=RuntimeConfigSetupCompleteBuildItem.class)
    @BuildStep(onlyIf={IsNormal.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void checkBoostrapServers(KafkaRecorder recorder, Capabilities capabilities) {
        if (capabilities.isPresent("io.quarkus.kubernetes.service.binding")) {
            recorder.checkBoostrapServers();
        }
    }

    private void handleOpenTracing(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, Capabilities capabilities) {
        if (!capabilities.isPresent("io.quarkus.opentracing") || !QuarkusClassLoader.isClassPresentAtRuntime((String)"io.opentracing.contrib.kafka.TracingProducerInterceptor")) {
            return;
        }
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, false, new String[]{"io.opentracing.contrib.kafka.TracingProducerInterceptor", "io.opentracing.contrib.kafka.TracingConsumerInterceptor"}));
    }

    private void handleStrimziOAuth(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        if (!QuarkusClassLoader.isClassPresentAtRuntime((String)"io.strimzi.kafka.oauth.client.JaasClientOauthLoginCallbackHandler")) {
            return;
        }
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{"io.strimzi.kafka.oauth.client.JaasClientOauthLoginCallbackHandler"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{"org.keycloak.jose.jws.JWSHeader", "org.keycloak.representations.AccessToken", "org.keycloak.representations.AccessToken$Access", "org.keycloak.representations.AccessTokenResponse", "org.keycloak.representations.IDToken", "org.keycloak.representations.JsonWebToken", "org.keycloak.jose.jwk.JSONWebKeySet", "org.keycloak.jose.jwk.JWK", "org.keycloak.json.StringOrArrayDeserializer", "org.keycloak.json.StringListMapDeserializer"}));
    }

    private void handleAvro(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<NativeImageProxyDefinitionBuildItem> proxies, BuildProducer<ServiceProviderBuildItem> serviceProviders, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport, Capabilities capabilities) {
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)"io.confluent.kafka.serializers.KafkaAvroDeserializer") && !capabilities.isPresent("io.quarkus.confluent.registry.avro")) {
            throw new RuntimeException("Confluent Avro classes detected, please use the quarkus-confluent-registry-avro extension");
        }
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)"io.apicurio.registry.utils.serde.AvroKafkaDeserializer")) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, false, new String[]{"io.apicurio.registry.utils.serde.AvroKafkaDeserializer", "io.apicurio.registry.utils.serde.AvroKafkaSerializer"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, false, new String[]{"io.apicurio.registry.utils.serde.avro.DefaultAvroDatumProvider", "io.apicurio.registry.utils.serde.avro.ReflectAvroDatumProvider", "io.apicurio.registry.utils.serde.strategy.AutoRegisterIdStrategy", "io.apicurio.registry.utils.serde.strategy.CachedSchemaIdStrategy", "io.apicurio.registry.utils.serde.strategy.FindBySchemaIdStrategy", "io.apicurio.registry.utils.serde.strategy.FindLatestIdStrategy", "io.apicurio.registry.utils.serde.strategy.GetOrCreateIdStrategy", "io.apicurio.registry.utils.serde.strategy.RecordIdStrategy", "io.apicurio.registry.utils.serde.strategy.SimpleTopicIdStrategy", "io.apicurio.registry.utils.serde.strategy.TopicIdStrategy", "io.apicurio.registry.utils.serde.strategy.TopicRecordIdStrategy"}));
            proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"io.apicurio.registry.client.RegistryService", "java.lang.AutoCloseable"}));
        }
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)"io.apicurio.registry.serde.avro.AvroKafkaDeserializer") && !capabilities.isPresent("io.quarkus.apicurio.registry.avro")) {
            throw new RuntimeException("Apicurio Registry 2.x Avro classes detected, please use the quarkus-apicurio-registry-avro extension");
        }
    }

    @BuildStep
    public AdditionalBeanBuildItem runtimeConfig() {
        return AdditionalBeanBuildItem.builder().addBeanClass(KafkaRuntimeConfigProducer.class).setUnremovable().build();
    }

    @BuildStep
    public void withSasl(CombinedIndexBuildItem index, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{AbstractLogin.DefaultLoginCallbackHandler.class}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{SaslClientCallbackHandler.class}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{DefaultLogin.class}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new Class[]{ScramSaslClient.ScramSaslClientFactory.class}));
        String securityProtocol = ConfigProvider.getConfig().getConfigValue("kafka.security.protocol").getValue();
        if (securityProtocol != null && SecurityProtocol.forName((String)securityProtocol) != SecurityProtocol.PLAINTEXT) {
            sslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(Feature.KAFKA_CLIENT));
        }
        for (ClassInfo loginModule : index.getIndex().getAllKnownImplementors(LOGIN_MODULE)) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{loginModule.name().toString()}));
        }
        for (ClassInfo authenticateCallbackHandler : index.getIndex().getAllKnownImplementors(AUTHENTICATE_CALLBACK_HANDLER)) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{authenticateCallbackHandler.name().toString()}));
        }
    }

    private static void collectImplementors(Set<DotName> set, CombinedIndexBuildItem indexBuildItem, Class<?> cls) {
        KafkaProcessor.collectClassNames(set, indexBuildItem.getIndex().getAllKnownImplementors(DotName.createSimple((String)cls.getName())));
    }

    private static void collectImplementors(Set<DotName> set, CombinedIndexBuildItem indexBuildItem, DotName className) {
        KafkaProcessor.collectClassNames(set, indexBuildItem.getIndex().getAllKnownImplementors(className));
    }

    private static void collectSubclasses(Set<DotName> set, CombinedIndexBuildItem indexBuildItem, Class<?> cls) {
        KafkaProcessor.collectClassNames(set, indexBuildItem.getIndex().getAllKnownSubclasses(DotName.createSimple((String)cls.getName())));
    }

    private static void collectClassNames(final Set<DotName> set, Collection<ClassInfo> classInfos) {
        classInfos.forEach(new Consumer<ClassInfo>(){

            @Override
            public void accept(ClassInfo c) {
                set.add(c.name());
            }
        });
    }

    @BuildStep
    HealthBuildItem addHealthCheck(KafkaBuildTimeConfig buildTimeConfig) {
        return new HealthBuildItem("io.quarkus.kafka.client.health.KafkaHealthCheck", buildTimeConfig.healthEnabled);
    }

    @BuildStep
    UnremovableBeanBuildItem ensureJsonParserAvailable() {
        return UnremovableBeanBuildItem.beanClassNames((String[])new String[]{"io.quarkus.jackson.ObjectMapperProducer", "com.fasterxml.jackson.databind.ObjectMapper", "io.quarkus.jsonb.JsonbProducer", "javax.json.bind.Jsonb"});
    }

    @BuildStep
    public void registerRuntimeInitializedClasses(BuildProducer<RuntimeInitializedClassBuildItem> producer) {
        producer.produce((BuildItem)new RuntimeInitializedClassBuildItem("org.apache.kafka.common.security.authenticator.SaslClientAuthenticator"));
        producer.produce((BuildItem)new RuntimeInitializedClassBuildItem("org.apache.kafka.common.security.oauthbearer.internals.expiring.ExpiringCredentialRefreshingLogin"));
    }

    @BuildStep
    void registerServiceBinding(Capabilities capabilities, BuildProducer<ServiceProviderBuildItem> serviceProvider) {
        if (capabilities.isPresent("io.quarkus.kubernetes.service.binding")) {
            serviceProvider.produce((BuildItem)new ServiceProviderBuildItem("io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConverter", new String[]{KafkaBindingConverter.class.getName()}));
        }
    }

    @BuildStep
    public AdditionalBeanBuildItem kafkaClientBeans() {
        return AdditionalBeanBuildItem.builder().addBeanClass(KafkaAdminClient.class).addBeanClass(KafkaTopicClient.class).addBeanClass(KafkaUiUtils.class).setUnremovable().build();
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void registerKafkaUiExecHandler(BuildProducer<DevConsoleRouteBuildItem> routeProducer, KafkaUiRecorder recorder) {
        routeProducer.produce((BuildItem)DevConsoleRouteBuildItem.builder().method("POST").handler(recorder.kafkaControlHandler()).path(KAFKA_ADMIN_PATH).bodyHandlerRequired().build());
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public DevConsoleWebjarBuildItem setupWebJar(LaunchModeBuildItem launchModeBuildItem) {
        if (launchModeBuildItem.getDevModeType().orElse(null) != DevModeType.LOCAL) {
            return null;
        }
        return DevConsoleWebjarBuildItem.builder().artifactKey(DEVCONSOLE_WEBJAR_ARTIFACT_KEY).root(DEVCONSOLE_WEBJAR_STATIC_RESOURCES_PATH).routeRoot(KAFKA_RESOURCES_ROOT_PATH).build();
    }
}

