/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.deployment;

import io.quarkus.kafka.client.deployment.RedPandaBuildTimeConfig;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;

@ConfigGroup
public class KafkaDevServicesBuildTimeConfig {
    @ConfigItem
    public Optional<Boolean> enabled = Optional.empty();
    @ConfigItem
    public Optional<Integer> port;
    @ConfigItem(defaultValue="redpanda")
    public Provider provider = Provider.REDPANDA;
    @ConfigItem
    public Optional<String> imageName;
    @ConfigItem(defaultValue="true")
    public boolean shared;
    @ConfigItem(defaultValue="kafka")
    public String serviceName;
    @ConfigItem
    public Map<String, Integer> topicPartitions;
    @ConfigItem(defaultValue="2S")
    public Duration topicPartitionsTimeout;
    @ConfigItem
    public RedPandaBuildTimeConfig redpanda;

    public static enum Provider {
        REDPANDA("docker.io/vectorized/redpanda:v22.3.4"),
        STRIMZI("quay.io/strimzi-test-container/test-container:latest-kafka-3.2.1"),
        KAFKA_NATIVE("quay.io/ogunalp/kafka-native:latest");

        private final String defaultImageName;

        private Provider(String imageName) {
            this.defaultImageName = imageName;
        }

        public String getDefaultImageName() {
            return this.defaultImageName;
        }
    }
}

