/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime.providers;

import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.TokenCustomizer;
import io.quarkus.oidc.runtime.OidcUtils;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Named;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

@Named(value="azure-access-token-customizer")
@ApplicationScoped
public class AzureAccessTokenCustomizer
implements TokenCustomizer {
    private static final String NONCE = "nonce";

    @Override
    public JsonObject customizeHeaders(JsonObject headers) {
        try {
            String nonce = headers.getString(NONCE);
            if (nonce != null) {
                byte[] nonceSha256 = OidcUtils.getSha256Digest(nonce.getBytes(StandardCharsets.UTF_8));
                byte[] newNonceBytes = Base64.getUrlEncoder().withoutPadding().encode(nonceSha256);
                return Json.createObjectBuilder((JsonObject)headers).add(NONCE, new String(newNonceBytes, StandardCharsets.UTF_8)).build();
            }
            return null;
        }
        catch (Exception ex) {
            throw new OIDCException(ex);
        }
    }
}

