/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client;

import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@ConfigGroup
public class OidcClientConfig
extends OidcCommonConfig {
    @ConfigItem
    public Optional<String> id = Optional.empty();
    @ConfigItem(defaultValue="true")
    public boolean clientEnabled = true;
    @ConfigItem
    public Optional<List<String>> scopes = Optional.empty();
    @ConfigItem
    public Optional<Duration> refreshTokenTimeSkew = Optional.empty();
    @ConfigItem(defaultValue="false")
    public boolean absoluteExpiresIn;
    public Grant grant = new Grant();
    @ConfigItem
    public Map<String, Map<String, String>> grantOptions;
    @ConfigItem(defaultValue="true")
    public boolean earlyTokensAcquisition = true;
    @ConfigItem
    public Map<String, String> headers;

    public Optional<String> getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = Optional.of(id);
    }

    public Map<String, Map<String, String>> getGrantOptions() {
        return this.grantOptions;
    }

    public void setGrantOptions(Map<String, Map<String, String>> grantOptions) {
        this.grantOptions = grantOptions;
    }

    public boolean isClientEnabled() {
        return this.clientEnabled;
    }

    public void setClientEnabled(boolean clientEnabled) {
        this.clientEnabled = clientEnabled;
    }

    public Optional<List<String>> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = Optional.of(scopes);
    }

    public Optional<Duration> getRefreshTokenTimeSkew() {
        return this.refreshTokenTimeSkew;
    }

    public void setRefreshTokenTimeSkew(Duration refreshTokenTimeSkew) {
        this.refreshTokenTimeSkew = Optional.of(refreshTokenTimeSkew);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public boolean isAbsoluteExpiresIn() {
        return this.absoluteExpiresIn;
    }

    public void setAbsoluteExpiresIn(boolean absoluteExpiresIn) {
        this.absoluteExpiresIn = absoluteExpiresIn;
    }

    public void setGrant(Grant grant) {
        this.grant = grant;
    }

    public Grant getGrant() {
        return this.grant;
    }

    @ConfigGroup
    public static class Grant {
        @ConfigItem(defaultValue="client")
        public Type type = Type.CLIENT;
        @ConfigItem(defaultValue="access_token")
        public String accessTokenProperty = "access_token";
        @ConfigItem(defaultValue="refresh_token")
        public String refreshTokenProperty = "refresh_token";
        @ConfigItem(defaultValue="expires_in")
        public String expiresInProperty = "expires_in";
        @ConfigItem(defaultValue="refresh_expires_in")
        public String refreshExpiresInProperty = "refresh_expires_in";

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public String getAccessTokenProperty() {
            return this.accessTokenProperty;
        }

        public void setAccessTokenProperty(String accessTokenProperty) {
            this.accessTokenProperty = accessTokenProperty;
        }

        public String getRefreshTokenProperty() {
            return this.refreshTokenProperty;
        }

        public void setRefreshTokenProperty(String refreshTokenProperty) {
            this.refreshTokenProperty = refreshTokenProperty;
        }

        public String getExpiresInProperty() {
            return this.expiresInProperty;
        }

        public void setExpiresInProperty(String expiresInProperty) {
            this.expiresInProperty = expiresInProperty;
        }

        public String getRefreshExpiresInProperty() {
            return this.refreshExpiresInProperty;
        }

        public void setRefreshExpiresInProperty(String refreshExpiresInProperty) {
            this.refreshExpiresInProperty = refreshExpiresInProperty;
        }

        public static enum Type {
            CLIENT("client_credentials"),
            PASSWORD("password"),
            CODE("authorization_code"),
            EXCHANGE("urn:ietf:params:oauth:grant-type:token-exchange"),
            REFRESH("refresh_token");

            private String grantType;

            private Type(String grantType) {
                this.grantType = grantType;
            }

            public String getGrantType() {
                return this.grantType;
            }
        }
    }
}

