/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.reactive.filter;

import io.quarkus.oidc.client.Tokens;
import io.quarkus.oidc.client.runtime.AbstractTokensProducer;
import io.quarkus.oidc.client.runtime.DisabledOidcClientException;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestFilter;

@Priority(value=1000)
public class OidcClientRequestReactiveFilter
extends AbstractTokensProducer
implements ResteasyReactiveClientRequestFilter {
    private static final Logger LOG = Logger.getLogger(OidcClientRequestReactiveFilter.class);
    private static final String BEARER_SCHEME_WITH_SPACE = "Bearer ";
    @Inject
    @ConfigProperty(name="quarkus.oidc-client-reactive-filter.client-name")
    Optional<String> clientName;

    protected void initTokens() {
        if (this.earlyTokenAcquisition) {
            LOG.debug((Object)"Token acquisition will be delayed until this filter is executed to avoid blocking an IO thread");
        }
    }

    public void filter(final ResteasyReactiveClientRequestContext requestContext) {
        requestContext.suspend();
        super.getTokens().subscribe().with((Consumer)new Consumer<Tokens>(){

            @Override
            public void accept(Tokens tokens) {
                requestContext.getHeaders().putSingle((Object)"Authorization", (Object)(OidcClientRequestReactiveFilter.BEARER_SCHEME_WITH_SPACE + tokens.getAccessToken()));
                requestContext.resume();
            }
        }, (Consumer)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable t) {
                if (t instanceof DisabledOidcClientException) {
                    LOG.debug((Object)"Client is disabled");
                    requestContext.abortWith(Response.status((int)500).build());
                } else {
                    LOG.debugf("Access token is not available, aborting the request with HTTP 401 error: %s", (Object)t.getMessage());
                    requestContext.abortWith(Response.status((int)401).build());
                }
                requestContext.resume();
            }
        });
    }

    protected Optional<String> clientId() {
        return this.clientName;
    }
}

