/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment.devservices.keycloak;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.builditem.RuntimeConfigSetupCompleteBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.devconsole.spi.DevConsoleRouteBuildItem;
import io.quarkus.devconsole.spi.DevConsoleRuntimeTemplateInfoBuildItem;
import io.quarkus.devconsole.spi.DevConsoleTemplateInfoBuildItem;
import io.quarkus.oidc.deployment.OidcBuildTimeConfig;
import io.quarkus.oidc.deployment.devservices.AbstractDevConsoleProcessor;
import io.quarkus.oidc.deployment.devservices.OidcAuthorizationCodePostHandler;
import io.quarkus.oidc.deployment.devservices.OidcPasswordClientCredHandler;
import io.quarkus.oidc.deployment.devservices.OidcTestServiceHandler;
import io.quarkus.oidc.deployment.devservices.keycloak.KeycloakBuildTimeConfig;
import io.quarkus.oidc.deployment.devservices.keycloak.KeycloakDevServicesConfigBuildItem;
import io.quarkus.oidc.deployment.devservices.keycloak.KeycloakDevServicesProcessor;
import java.util.Map;
import java.util.Optional;

public class KeycloakDevConsoleProcessor
extends AbstractDevConsoleProcessor {
    KeycloakBuildTimeConfig keycloakConfig;
    OidcBuildTimeConfig oidcConfig;

    @BuildStep(onlyIf={IsDevelopment.class})
    @Consume(value=RuntimeConfigSetupCompleteBuildItem.class)
    public void setConfigProperties(BuildProducer<DevConsoleTemplateInfoBuildItem> devConsoleInfo, BuildProducer<DevConsoleRuntimeTemplateInfoBuildItem> devConsoleRuntimeInfo, Optional<KeycloakDevServicesConfigBuildItem> configProps, Capabilities capabilities, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (configProps.isPresent() && configProps.get().getConfig().containsKey("keycloak.url")) {
            devConsoleInfo.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("keycloakAdminUrl", (Object)configProps.get().getConfig().get("keycloak.url")));
            devConsoleInfo.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("keycloakUsers", configProps.get().getProperties().get("oidc.users")));
            devConsoleInfo.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("keycloakRealms", configProps.get().getProperties().get("keycloak.realms")));
            String realmUrl = configProps.get().getConfig().get("quarkus.oidc.auth-server-url");
            this.produceDevConsoleTemplateItems(capabilities, devConsoleInfo, devConsoleRuntimeInfo, curateOutcomeBuildItem, "Keycloak", configProps.get().getConfig().get("quarkus.oidc.application-type"), this.oidcConfig.devui.grant.type.isPresent() ? this.oidcConfig.devui.grant.type.get().getGrantType() : this.keycloakConfig.devservices.grant.type.getGrantType(), realmUrl + "/protocol/openid-connect/auth", realmUrl + "/protocol/openid-connect/token", realmUrl + "/protocol/openid-connect/logout", true);
        }
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void invokeEndpoint(BuildProducer<DevConsoleRouteBuildItem> devConsoleRoute, Optional<KeycloakDevServicesConfigBuildItem> configProps) {
        if (configProps.isPresent() && configProps.get().getConfig().containsKey("keycloak.url")) {
            Map users = (Map)configProps.get().getProperties().get("oidc.users");
            this.produceDevConsoleRouteItems(devConsoleRoute, new OidcTestServiceHandler(KeycloakDevServicesProcessor.vertxInstance, this.oidcConfig.devui.webClientTimeout), new OidcAuthorizationCodePostHandler(KeycloakDevServicesProcessor.vertxInstance, this.oidcConfig.devui.webClientTimeout, this.oidcConfig.devui.grantOptions), new OidcPasswordClientCredHandler(KeycloakDevServicesProcessor.vertxInstance, this.oidcConfig.devui.webClientTimeout, users, this.oidcConfig.devui.grantOptions));
        }
    }
}

