/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import io.quarkus.bom.PomResolver;
import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.DecomposedBom;
import io.quarkus.bom.decomposer.DecomposedBomBuilder;
import io.quarkus.bom.decomposer.ProjectDependency;
import io.quarkus.bom.decomposer.ProjectRelease;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bootstrap.model.AppArtifactKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;

public class DefaultDecomposedBomBuilder
implements DecomposedBomBuilder {
    private PomResolver bomSource;
    private Artifact bomArtifact;
    private Map<ReleaseId, Map<AppArtifactKey, ProjectDependency>> releases = new HashMap<ReleaseId, Map<AppArtifactKey, ProjectDependency>>();

    @Override
    public void bomSource(PomResolver bomSource) {
        this.bomSource = bomSource;
    }

    @Override
    public void bomArtifact(Artifact bomArtifact) {
        this.bomArtifact = bomArtifact;
    }

    @Override
    public void bomDependency(ReleaseId releaseId, Dependency artifact) throws BomDecomposerException {
        ProjectDependency d = ProjectDependency.create(releaseId, artifact);
        this.releases.computeIfAbsent(releaseId, t -> new LinkedHashMap()).putIfAbsent(d.key(), d);
    }

    @Override
    public DecomposedBom build() throws BomDecomposerException {
        DecomposedBom.Builder bomBuilder = DecomposedBom.builder();
        bomBuilder.bomArtifact(this.bomArtifact);
        bomBuilder.bomSource(this.bomSource);
        for (Map.Entry<ReleaseId, Map<AppArtifactKey, ProjectDependency>> entry : this.releases.entrySet()) {
            bomBuilder.addRelease(ProjectRelease.create(entry.getKey(), new ArrayList<ProjectDependency>(entry.getValue().values())));
        }
        return bomBuilder.build();
    }
}

