/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import io.quarkus.bom.decomposer.ProjectDependency;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bootstrap.model.AppArtifactKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;

public class ProjectRelease {
    protected final ReleaseId id;
    protected List<ProjectDependency> deps;
    protected final Set<String> artifactVersions = new HashSet<String>();

    public static Builder builder(ReleaseId id) {
        return new ProjectRelease(id).new Builder();
    }

    public static ProjectRelease create(ReleaseId id, List<ProjectDependency> deps) {
        return new ProjectRelease(id, deps == null ? Collections.emptyList() : Collections.unmodifiableList(deps));
    }

    private ProjectRelease(ReleaseId id) {
        this(id, null);
    }

    private ProjectRelease(ReleaseId id, List<ProjectDependency> deps) {
        this.id = id;
        if (deps == null) {
            this.deps = new ArrayList<ProjectDependency>();
        } else {
            this.deps = deps;
            for (ProjectDependency dep : deps) {
                this.artifactVersions.add(dep.artifact().getVersion());
            }
        }
    }

    public ReleaseId id() {
        return this.id;
    }

    public List<ProjectDependency> dependencies() {
        return this.deps;
    }

    public Collection<String> artifactVersions() {
        return this.artifactVersions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.deps == null ? 0 : this.deps.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectRelease other = (ProjectRelease)obj;
        if (this.deps == null ? other.deps != null : !this.deps.equals(other.deps)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public class Builder {
        private LinkedHashMap<AppArtifactKey, ProjectDependency> deps = new LinkedHashMap();

        private Builder() {
        }

        public ReleaseId id() {
            return ProjectRelease.this.id;
        }

        public Builder add(ProjectDependency dep) {
            ProjectDependency existing = this.deps.put(dep.key(), dep);
            if (existing == null) {
                ProjectRelease.this.artifactVersions.add(dep.artifact().getVersion());
            } else if (!dep.artifact().getVersion().equals(existing.artifact().getVersion())) {
                throw new IllegalArgumentException("Failed to add " + dep + " since the release already includes " + existing);
            }
            return this;
        }

        public Builder add(Artifact a) {
            return this.add(ProjectDependency.create(ProjectRelease.this.id, a));
        }

        public Builder add(Dependency d) {
            return this.add(ProjectDependency.create(ProjectRelease.this.id, d));
        }

        public boolean includes(AppArtifactKey key) {
            return this.deps.containsKey(key);
        }

        public ProjectRelease build() {
            ProjectRelease.this.deps = Collections.unmodifiableList(new ArrayList<ProjectDependency>(this.deps.values()));
            return ProjectRelease.this;
        }
    }
}

