/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.diff;

import io.quarkus.bom.diff.BomDiff;
import io.quarkus.bom.diff.BomDiffReportGenerator;
import io.quarkus.devtools.messagewriter.MessageWriter;
import java.math.RoundingMode;
import java.text.NumberFormat;
import org.eclipse.aether.graph.Dependency;

public class BomDiffLogger
implements BomDiffReportGenerator {
    private MessageWriter log;
    private NumberFormat numberFormat;

    public static Config config() {
        return new BomDiffLogger().new Config();
    }

    @Override
    public void report(BomDiff bomDiff) {
        int total;
        this.log().info("Managed Dependencies Comparison Report");
        this.log().info("Main BOM: " + bomDiff.mainBom() + " (" + bomDiff.mainBomSize() + " managed dependencies)");
        this.log().info("Compared to BOM: " + bomDiff.toBom() + " (" + bomDiff.toBomSize() + " managed dependencies)");
        int matchingTotal = bomDiff.matching().size();
        this.log.info("Matching dependencies: " + matchingTotal + " (" + this.format(matchingTotal * 100 / bomDiff.mainBomSize()) + "%)");
        if (bomDiff.hasDowngraded()) {
            total = bomDiff.downgraded().size();
            this.log().info("Downgraded dependencies: " + total + " (" + this.percentage(total, bomDiff.mainBomSize()) + "%)");
            for (BomDiff.VersionChange versionChange : bomDiff.downgraded()) {
                this.log().info("  " + versionChange.from().getArtifact() + " -> " + versionChange.to().getArtifact().getVersion());
            }
        }
        if (bomDiff.hasUpgraded()) {
            total = bomDiff.upgraded().size();
            this.log().info("Upgraded dependencies: " + total + " (" + this.percentage(total, bomDiff.mainBomSize()) + "%)");
            for (BomDiff.VersionChange versionChange : bomDiff.upgraded()) {
                this.log().info("  " + versionChange.from().getArtifact() + " -> " + versionChange.to().getArtifact().getVersion());
            }
        }
        if (bomDiff.hasExtra()) {
            total = bomDiff.extra().size();
            this.log().info("Extra dependencies: " + total + " (" + this.percentage(total, bomDiff.mainBomSize()) + "%)");
            for (Dependency dependency : bomDiff.extra()) {
                this.log().info("  " + dependency.getArtifact());
            }
        }
        if (bomDiff.hasMissing()) {
            total = bomDiff.missing().size();
            this.log().info("Missing dependencies: " + total + " (" + this.percentage(total, bomDiff.toBomSize()) + "%)");
            for (Dependency dependency : bomDiff.missing()) {
                this.log().info("  " + dependency.getArtifact());
            }
        }
    }

    private String percentage(long part, long whole) {
        return this.format((double)part * 100.0 / (double)whole);
    }

    private String format(double d) {
        return this.numberFormat().format(d);
    }

    private NumberFormat numberFormat() {
        if (this.numberFormat == null) {
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(1);
            numberFormat.setRoundingMode(RoundingMode.HALF_DOWN);
            this.numberFormat = numberFormat;
        }
        return this.numberFormat;
    }

    private MessageWriter log() {
        return this.log == null ? (this.log = MessageWriter.debug()) : this.log;
    }

    public class Config {
        private Config() {
        }

        public Config logger(MessageWriter logger) {
            BomDiffLogger.this.log = logger;
            return this;
        }

        public void report(BomDiff bomDiff) {
            BomDiffLogger.this.report(bomDiff);
        }
    }
}

