/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.platform;

import io.quarkus.bom.platform.ExtensionCoordsFilter;
import io.quarkus.bom.platform.PlatformBomConfig;
import io.quarkus.bom.platform.PlatformBomMemberConfig;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.ArtifactKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;

public class ExtensionCoordsFilterFactory {
    private final Map<ArtifactKey, PlatformBomMemberConfig> members;
    private final boolean enableNonMemberQuarkiverseExtensions;

    public static ExtensionCoordsFilterFactory newInstance(PlatformBomConfig config, MessageWriter log) {
        HashMap<ArtifactKey, PlatformBomMemberConfig> members = new HashMap<ArtifactKey, PlatformBomMemberConfig>();
        ExtensionCoordsFilterFactory.add(members, config.quarkusBom(), log);
        for (PlatformBomMemberConfig member : config.directDeps()) {
            ExtensionCoordsFilterFactory.add(members, member, log);
        }
        return new ExtensionCoordsFilterFactory(members, config.isEnableNonMemberQuarkiverseExtensions());
    }

    private static void add(Map<ArtifactKey, PlatformBomMemberConfig> members, PlatformBomMemberConfig member, MessageWriter log) {
        ArtifactKey memberKey = ExtensionCoordsFilterFactory.memberKey(member);
        if (memberKey != null) {
            PlatformBomMemberConfig previous = members.put(memberKey, member);
            if (previous != null) {
                throw new IllegalArgumentException("Found members with the same GAV: " + previous.originalBomArtifact() + " and " + member.originalBomArtifact());
            }
        } else {
            log.warn("Failed to determine the primary Maven artifact gropuId for member " + member.key());
        }
    }

    private static ArtifactKey memberKey(PlatformBomMemberConfig member) {
        if (member.isBom()) {
            return new ArtifactKey(member.originalBomArtifact().getGroupId(), member.originalBomArtifact().getArtifactId());
        }
        HashSet<String> memberGroupIds = new HashSet<String>(1);
        for (Dependency d : member.asDependencyConstraints()) {
            if (!d.getArtifact().getArtifactId().endsWith("-deployment")) continue;
            memberGroupIds.add(d.getArtifact().getGroupId());
        }
        if (memberGroupIds.size() == 1) {
            return new ArtifactKey((String)memberGroupIds.iterator().next(), member.generatedBomArtifact().getArtifactId());
        }
        return null;
    }

    private ExtensionCoordsFilterFactory(Map<ArtifactKey, PlatformBomMemberConfig> members, boolean enableNonMemberQuarkiverseExtensions) {
        this.members = members;
        this.enableNonMemberQuarkiverseExtensions = enableNonMemberQuarkiverseExtensions;
    }

    public ExtensionCoordsFilter forMember(final PlatformBomMemberConfig member) {
        return new ExtensionCoordsFilter(){

            @Override
            public boolean isExcludeFromBom(Artifact a) {
                if (member.originalBomArtifact().getGroupId().equals(a.getGroupId())) {
                    return false;
                }
                if (!ExtensionCoordsFilterFactory.this.enableNonMemberQuarkiverseExtensions && a.getGroupId().startsWith("io.quarkiverse")) {
                    return true;
                }
                for (ArtifactKey other : ExtensionCoordsFilterFactory.this.members.keySet()) {
                    if (!other.getGroupId().equals(a.getGroupId())) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

