/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.platform;

import io.quarkus.bom.PomSource;
import io.quarkus.bom.decomposer.BomDecomposer;
import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.DecomposedBom;
import io.quarkus.bom.decomposer.DecomposedBomHtmlReportGenerator;
import io.quarkus.bom.decomposer.DecomposedBomTransformer;
import io.quarkus.bom.decomposer.DecomposedBomVisitor;
import io.quarkus.bom.decomposer.PomUtils;
import io.quarkus.bom.decomposer.ProjectDependency;
import io.quarkus.bom.decomposer.ProjectRelease;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bom.decomposer.ReleaseIdFactory;
import io.quarkus.bom.decomposer.ReleaseOrigin;
import io.quarkus.bom.decomposer.ReleaseVersion;
import io.quarkus.bom.decomposer.UpdateAvailabilityTransformer;
import io.quarkus.bom.diff.BomDiff;
import io.quarkus.bom.diff.HtmlBomDiffReportGenerator;
import io.quarkus.bom.platform.ExtensionCoordsFilter;
import io.quarkus.bom.platform.ExtensionCoordsFilterFactory;
import io.quarkus.bom.platform.ExtensionFilter;
import io.quarkus.bom.platform.PlatformBomConfig;
import io.quarkus.bom.platform.PlatformBomMemberConfig;
import io.quarkus.bom.platform.ReportIndexPageGenerator;
import io.quarkus.bom.resolver.ArtifactResolver;
import io.quarkus.bom.resolver.ArtifactResolverProvider;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.devtools.messagewriter.MessageWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;

public class PlatformBomComposer
implements DecomposedBomTransformer,
DecomposedBomVisitor {
    private final DecomposedBom originalQuarkusBom;
    private final DecomposedBom filteredQuarkusBom;
    private final DecomposedBom generatedQuarkusBom;
    private final MessageWriter logger;
    private final ExtensionCoordsFilterFactory extCoordsFilterFactory;
    private ArtifactResolver resolver;
    private Collection<ReleaseVersion> quarkusVersions;
    private LinkedHashMap<String, ReleaseId> preferredVersions;
    private boolean transformingBom;
    private Map<AppArtifactKey, ProjectDependency> quarkusBomDeps = new HashMap<AppArtifactKey, ProjectDependency>();
    private Map<ReleaseOrigin, Map<ReleaseVersion, ProjectRelease.Builder>> externalReleaseDeps = new HashMap<ReleaseOrigin, Map<ReleaseVersion, ProjectRelease.Builder>>();
    final Map<AppArtifactKey, ProjectDependency> externalExtensionDeps = new HashMap<AppArtifactKey, ProjectDependency>();
    private List<DecomposedBom> importedBoms = new ArrayList<DecomposedBom>();
    private Map<Artifact, DecomposedBom> originalImportedBoms = new HashMap<Artifact, DecomposedBom>();
    private Set<Artifact> bomsNotImportingQuarkusBom = new HashSet<Artifact>();
    private final DecomposedBom platformBom;
    private Map<String, PlatformBomMemberConfig> memberConfigs = new HashMap<String, PlatformBomMemberConfig>();
    private PlatformBomConfig config;
    private Artifact extBom;

    public static DecomposedBom compose(PlatformBomConfig config) throws BomDecomposerException {
        return new PlatformBomComposer(config).platformBom();
    }

    public PlatformBomComposer(PlatformBomConfig config) throws BomDecomposerException {
        this(config, MessageWriter.info());
    }

    public PlatformBomComposer(PlatformBomConfig config, MessageWriter logger) throws BomDecomposerException {
        this.config = config;
        this.logger = logger;
        this.resolver = config.artifactResolver();
        this.extCoordsFilterFactory = ExtensionCoordsFilterFactory.newInstance(config, logger);
        this.originalQuarkusBom = BomDecomposer.config().logger(logger).mavenArtifactResolver(this.resolver()).bomArtifact(config.quarkusBom().originalBomArtifact()).decompose();
        ExtensionFilter coreFilter = ExtensionFilter.getInstance(this.resolver(), logger, config.quarkusBom());
        this.filteredQuarkusBom = coreFilter.transform(this.originalQuarkusBom);
        DecomposedBom.Builder quarkusBomBuilder = DecomposedBom.builder().bomArtifact(config.quarkusBom().generatedBomArtifact()).bomSource(PomSource.of((Artifact)config.quarkusBom().generatedBomArtifact()));
        this.addPlatformArtifacts(config.quarkusBom(), quarkusBomBuilder);
        this.filteredQuarkusBom.releases().forEach(r -> {
            AtomicReference rbRef = new AtomicReference();
            r.dependencies().forEach(d -> {
                this.quarkusBomDeps.put(d.key(), (ProjectDependency)d);
                ProjectDependency effectiveDep = this.effectiveDep((ProjectDependency)d);
                if (effectiveDep != null) {
                    ProjectRelease.Builder rb = (ProjectRelease.Builder)rbRef.get();
                    if (rb == null) {
                        rb = ProjectRelease.builder((ReleaseId)r.id());
                        rbRef.set(rb);
                    }
                    rb.add(effectiveDep);
                }
            });
            ProjectRelease.Builder rb = (ProjectRelease.Builder)rbRef.get();
            if (rb != null) {
                quarkusBomBuilder.addRelease(rb.build());
            }
        });
        this.generatedQuarkusBom = quarkusBomBuilder.build();
        UpdateAvailabilityTransformer updateCheckingTransformer = new UpdateAvailabilityTransformer(this.resolver, logger);
        for (PlatformBomMemberConfig memberConfig : config.directDeps()) {
            logger.info("Processing " + (memberConfig.originalBomArtifact() == null ? memberConfig.generatedBomArtifact() : memberConfig.originalBomArtifact()));
            this.memberConfigs.put(memberConfig.key(), memberConfig);
            this.transformingBom = memberConfig.isBom() || memberConfig.asDependencyConstraints().size() > 1;
            Collection<Dependency> bomDeps = memberConfig.isBom() ? this.managedDepsExcludingQuarkusBom(memberConfig) : memberConfig.asDependencyConstraints();
            DecomposedBom originalBom = BomDecomposer.config().mavenArtifactResolver(this.resolver()).dependencies(bomDeps).logger(logger).bomArtifact(memberConfig.originalBomArtifact() == null ? memberConfig.generatedBomArtifact() : memberConfig.originalBomArtifact()).decompose();
            originalBom = ExtensionFilter.getInstance(this.resolver(), logger, memberConfig).transform(originalBom);
            originalBom = updateCheckingTransformer.transform(originalBom);
            if (memberConfig.isBom()) {
                this.originalImportedBoms.put(originalBom.bomArtifact(), originalBom);
            } else if (memberConfig.asDependencyConstraints().size() > 1) {
                this.originalImportedBoms.put(memberConfig.generatedBomArtifact(), originalBom);
            }
            this.transform(originalBom);
        }
        logger.info("Generating " + config.bomArtifact());
        this.platformBom = this.generatePlatformBom();
        this.generatedUpdatedImportedBoms();
    }

    public DecomposedBom originalQuarkusCoreBom() {
        return this.originalQuarkusBom;
    }

    public DecomposedBom generatedQuarkusCoreBom() {
        return this.generatedQuarkusBom;
    }

    public DecomposedBom platformBom() {
        return this.platformBom;
    }

    public List<DecomposedBom> alignedMemberBoms() {
        return this.importedBoms;
    }

    public DecomposedBom originalMemberBom(Artifact artifact) {
        return this.originalImportedBoms.get(artifact);
    }

    private void generatedUpdatedImportedBoms() {
        HashSet<AppArtifactKey> bomDeps = new HashSet<AppArtifactKey>();
        HashMap<ReleaseId, ProjectRelease.Builder> releaseBuilders = new HashMap<ReleaseId, ProjectRelease.Builder>();
        int i = 0;
        while (i < this.importedBoms.size()) {
            bomDeps.clear();
            releaseBuilders.clear();
            DecomposedBom importedBomMinusQuarkusBom = this.importedBoms.get(i);
            for (ProjectRelease release : importedBomMinusQuarkusBom.releases()) {
                for (ProjectDependency dep : release.dependencies()) {
                    if (!bomDeps.add(dep.key()) || this.config.excluded(dep.key())) continue;
                    ProjectDependency platformDep = this.quarkusBomDeps.get(dep.key());
                    if (platformDep == null) {
                        platformDep = this.externalExtensionDeps.get(dep.key());
                    }
                    if (platformDep == null) {
                        throw new IllegalStateException("Failed to locate " + dep.key() + " in the generated platform BOM");
                    }
                    releaseBuilders.computeIfAbsent(platformDep.releaseId(), id -> ProjectRelease.builder((ReleaseId)id)).add(platformDep);
                }
            }
            PlatformBomMemberConfig memberConfig = this.memberConfigs.get(importedBomMinusQuarkusBom.bomArtifact().getGroupId() + ":" + importedBomMinusQuarkusBom.bomArtifact().getArtifactId());
            Artifact generatedBomArtifact = memberConfig.generatedBomArtifact();
            DecomposedBom.Builder updatedBom = DecomposedBom.builder().bomArtifact(generatedBomArtifact).bomSource(PomSource.of((Artifact)generatedBomArtifact));
            for (ProjectRelease.Builder releaseBuilder : releaseBuilders.values()) {
                updatedBom.addRelease(releaseBuilder.build());
            }
            this.addPlatformArtifacts(memberConfig, updatedBom);
            this.importedBoms.set(i++, updatedBom.build());
        }
    }

    private void addPlatformArtifacts(PlatformBomMemberConfig memberConfig, DecomposedBom.Builder updatedBom) {
        Artifact generatedBomArtifact = memberConfig.generatedBomArtifact();
        if (!generatedBomArtifact.equals(memberConfig.originalBomArtifact())) {
            ReleaseId memberReleaseId = ReleaseIdFactory.create((ReleaseOrigin)ReleaseOrigin.Factory.ga((String)generatedBomArtifact.getGroupId(), (String)generatedBomArtifact.getArtifactId()), (ReleaseVersion)ReleaseVersion.Factory.version((String)generatedBomArtifact.getVersion()));
            ProjectRelease memberRelease = ProjectRelease.builder((ReleaseId)memberReleaseId).add(ProjectDependency.create((ReleaseId)memberReleaseId, (Artifact)new DefaultArtifact(generatedBomArtifact.getGroupId(), generatedBomArtifact.getArtifactId() + "-quarkus-platform-descriptor", generatedBomArtifact.getVersion(), "json", generatedBomArtifact.getVersion()))).add(ProjectDependency.create((ReleaseId)memberReleaseId, (Artifact)new DefaultArtifact(generatedBomArtifact.getGroupId(), generatedBomArtifact.getArtifactId() + "-quarkus-platform-properties", null, "properties", generatedBomArtifact.getVersion()))).build();
            updatedBom.addRelease(memberRelease);
        }
    }

    private DecomposedBom generatePlatformBom() throws BomDecomposerException {
        HashMap<ReleaseId, ProjectRelease.Builder> platformReleaseBuilders = new HashMap<ReleaseId, ProjectRelease.Builder>();
        ReleaseId bomReleaseId = ReleaseIdFactory.create((ReleaseOrigin)ReleaseOrigin.Factory.ga((String)this.config.bomArtifact().getGroupId(), (String)this.config.bomArtifact().getArtifactId()), (ReleaseVersion)ReleaseVersion.Factory.version((String)this.config.bomArtifact().getVersion()));
        ProjectRelease.Builder bomReleaseBuilder = ProjectRelease.builder((ReleaseId)bomReleaseId).add(ProjectDependency.create((ReleaseId)bomReleaseId, (Artifact)new DefaultArtifact(this.config.bomArtifact().getGroupId(), this.config.bomArtifact().getArtifactId() + "-quarkus-platform-descriptor", this.config.bomArtifact().getVersion(), "json", this.config.bomArtifact().getVersion())));
        if (this.config.includePlatformProperties()) {
            bomReleaseBuilder.add(ProjectDependency.create((ReleaseId)bomReleaseId, (Artifact)new DefaultArtifact(this.config.bomArtifact().getGroupId(), this.config.bomArtifact().getArtifactId() + "-quarkus-platform-properties", null, "properties", this.config.bomArtifact().getVersion())));
        }
        platformReleaseBuilders.put(bomReleaseId, bomReleaseBuilder);
        for (ProjectDependency projectDependency : this.quarkusBomDeps.values()) {
            ProjectDependency projectDependency2 = this.effectiveDep(projectDependency);
            if (projectDependency2 == null) continue;
            platformReleaseBuilders.computeIfAbsent(projectDependency2.releaseId(), id -> ProjectRelease.builder((ReleaseId)id)).add(projectDependency2);
        }
        for (Map map : this.externalReleaseDeps.values()) {
            ArrayList<ProjectRelease> releases = new ArrayList<ProjectRelease>(map.size());
            map.values().forEach(b -> releases.add(b.build()));
            if (map.size() == 1) {
                this.mergeExtensionDeps((ProjectRelease)releases.get(0), this.externalExtensionDeps);
                continue;
            }
            LinkedHashMap<String, ReleaseId> preferredVersions = this.preferredVersions(releases);
            block2: for (ProjectRelease release : releases) {
                for (Map.Entry<String, ReleaseId> preferred : preferredVersions.entrySet()) {
                    if (release.id().equals(preferred.getValue())) {
                        this.mergeExtensionDeps(release, this.externalExtensionDeps);
                        continue block2;
                    }
                    for (ProjectDependency dep : release.dependencies()) {
                        if (this.quarkusBomDeps.containsKey(dep.key())) continue;
                        String depVersion = dep.artifact().getVersion();
                        if (!preferred.getKey().equals(depVersion)) {
                            for (Map.Entry<String, ReleaseId> preferredVersion : preferredVersions.entrySet()) {
                                Artifact artifact = dep.artifact().setVersion(preferredVersion.getKey());
                                if (this.resolver().resolveOrNull(artifact) == null) continue;
                                dep = ProjectDependency.create((ReleaseId)preferredVersion.getValue(), (Dependency)dep.dependency().setArtifact(artifact));
                                break;
                            }
                        }
                        this.addNonQuarkusDep(dep, this.externalExtensionDeps);
                    }
                }
            }
        }
        for (ProjectDependency projectDependency : this.externalExtensionDeps.values()) {
            platformReleaseBuilders.computeIfAbsent(projectDependency.releaseId(), id -> ProjectRelease.builder((ReleaseId)id)).add(projectDependency);
        }
        DecomposedBom.Builder platformBuilder = DecomposedBom.builder().bomArtifact(this.config.bomArtifact()).bomSource(this.config.bomResolver());
        for (ProjectRelease.Builder builder : platformReleaseBuilders.values()) {
            platformBuilder.addRelease(builder.build());
        }
        return platformBuilder.build();
    }

    private ProjectDependency effectiveDep(ProjectDependency dep) {
        if (this.config.excluded(dep.key())) {
            return null;
        }
        Artifact enforced = this.config.enforced(dep.key());
        if (enforced == null) {
            return dep;
        }
        return ProjectDependency.create((ReleaseId)dep.releaseId(), (Dependency)dep.dependency().setArtifact(enforced));
    }

    private void mergeExtensionDeps(ProjectRelease release, Map<AppArtifactKey, ProjectDependency> extensionDeps) {
        for (ProjectDependency dep : release.dependencies()) {
            if (this.quarkusBomDeps.containsKey(dep.key())) {
                return;
            }
            this.addNonQuarkusDep(dep, extensionDeps);
        }
    }

    private void addNonQuarkusDep(ProjectDependency dep, Map<AppArtifactKey, ProjectDependency> extensionDeps) {
        if (this.config.excluded(dep.key())) {
            return;
        }
        Artifact enforced = this.config.enforced(dep.key());
        if (enforced != null) {
            if (!extensionDeps.containsKey(dep.key())) {
                extensionDeps.put(dep.key(), ProjectDependency.create((ReleaseId)dep.releaseId(), (Artifact)enforced));
            }
            return;
        }
        ProjectDependency currentDep = extensionDeps.get(dep.key());
        if (currentDep != null) {
            DefaultArtifactVersion newVersion;
            DefaultArtifactVersion currentVersion = new DefaultArtifactVersion(currentDep.artifact().getVersion());
            if (currentVersion.compareTo((Object)(newVersion = new DefaultArtifactVersion(dep.artifact().getVersion()))) < 0) {
                extensionDeps.put(dep.key(), dep);
            }
        } else {
            extensionDeps.put(dep.key(), dep);
        }
    }

    public DecomposedBom transform(DecomposedBom decomposedBom) throws BomDecomposerException {
        if (this.transformingBom) {
            this.importedBoms.add(decomposedBom);
        }
        decomposedBom.visit((DecomposedBomVisitor)this);
        return decomposedBom;
    }

    public void enterBom(Artifact bomArtifact) {
        this.extBom = bomArtifact;
    }

    public boolean enterReleaseOrigin(ReleaseOrigin releaseOrigin, int versions) {
        this.preferredVersions = null;
        this.quarkusVersions = this.filteredQuarkusBom.releaseVersions(releaseOrigin);
        return true;
    }

    public void leaveReleaseOrigin(ReleaseOrigin releaseOrigin) throws BomDecomposerException {
    }

    public void visitProjectRelease(ProjectRelease release) throws BomDecomposerException {
        if (this.quarkusVersions.isEmpty()) {
            ProjectRelease.Builder releaseBuilder = this.externalReleaseDeps.computeIfAbsent(release.id().origin(), id -> new HashMap()).computeIfAbsent(release.id().version(), id -> ProjectRelease.builder((ReleaseId)release.id()));
            for (ProjectDependency dep : release.dependencies()) {
                releaseBuilder.add(dep);
            }
            return;
        }
        if (this.quarkusVersions.contains(release.id().version())) {
            for (ProjectDependency dep : release.dependencies()) {
                this.quarkusBomDeps.putIfAbsent(dep.key(), dep);
            }
            return;
        }
        LinkedHashMap<String, ReleaseId> preferredVersions = this.preferredVersions == null ? (this.preferredVersions = this.preferredVersions(this.filteredQuarkusBom.releases(release.id().origin()))) : this.preferredVersions;
        for (ProjectDependency dep : release.dependencies()) {
            String depVersion = dep.artifact().getVersion();
            if (!preferredVersions.containsKey(depVersion)) {
                for (Map.Entry<String, ReleaseId> preferredVersion : preferredVersions.entrySet()) {
                    Artifact artifact = dep.artifact().setVersion(preferredVersion.getKey());
                    if (this.resolver().resolveOrNull(artifact) == null) continue;
                    dep = ProjectDependency.create((ReleaseId)preferredVersion.getValue(), (Dependency)dep.dependency().setArtifact(artifact));
                    break;
                }
            }
            this.quarkusBomDeps.putIfAbsent(dep.key(), dep);
        }
    }

    public void leaveBom() throws BomDecomposerException {
    }

    private LinkedHashMap<String, ReleaseId> preferredVersions(Collection<ProjectRelease> releases) {
        TreeMap treeMap = new TreeMap(Collections.reverseOrder());
        for (ProjectRelease release : releases) {
            for (String versionStr : release.artifactVersions()) {
                DefaultArtifactVersion version = new DefaultArtifactVersion(versionStr);
                ReleaseId prevReleaseId = treeMap.put(version, release.id());
                if (prevReleaseId == null || new DefaultArtifactVersion(prevReleaseId.version().asString()).compareTo((ArtifactVersion)new DefaultArtifactVersion(release.id().version().asString())) <= 0) continue;
                treeMap.put(version, prevReleaseId);
            }
        }
        LinkedHashMap<String, ReleaseId> result = new LinkedHashMap<String, ReleaseId>(treeMap.size());
        for (Map.Entry entry : treeMap.entrySet()) {
            result.put(((ArtifactVersion)entry.getKey()).toString(), (ReleaseId)entry.getValue());
        }
        return result;
    }

    private Collection<Dependency> managedDepsExcludingQuarkusBom(PlatformBomMemberConfig member) throws BomDecomposerException {
        Artifact bom = member.originalBomArtifact();
        ArtifactDescriptorResult bomDescr = this.describe(bom);
        Artifact quarkusCore = null;
        List allDeps = bomDescr.getManagedDependencies();
        HashMap<AppArtifactKey, Dependency> result = new HashMap<AppArtifactKey, Dependency>(allDeps.size());
        ExtensionCoordsFilter extCoordsFilter = this.extCoordsFilterFactory.forMember(member);
        for (Dependency dep : allDeps) {
            Artifact artifact = dep.getArtifact();
            if (quarkusCore == null && artifact.getArtifactId().equals("quarkus-core") && artifact.getGroupId().equals("io.quarkus")) {
                quarkusCore = artifact;
            }
            if (extCoordsFilter.isExcludeFromBom(artifact)) continue;
            result.put(PlatformBomComposer.key(artifact), dep);
        }
        if (quarkusCore != null) {
            this.subtractQuarkusBom(result, (Artifact)new DefaultArtifact("io.quarkus", "quarkus-bom", null, "pom", quarkusCore.getVersion()));
        } else {
            this.bomsNotImportingQuarkusBom.add(bom);
        }
        return result.values();
    }

    private static AppArtifactKey key(Artifact artifact) {
        return new AppArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension());
    }

    private void subtractQuarkusBom(Map<AppArtifactKey, Dependency> result, Artifact quarkusCoreBom) throws BomDecomposerException {
        try {
            ArtifactDescriptorResult quarkusBomDescr = this.describe(quarkusCoreBom);
            for (Dependency quarkusBomDep : quarkusBomDescr.getManagedDependencies()) {
                result.remove(PlatformBomComposer.key(quarkusBomDep.getArtifact()));
            }
        }
        catch (BomDecomposerException e) {
            this.logger.debug("Failed to subtract %s: %s", new Object[]{quarkusCoreBom, e.getLocalizedMessage()});
            throw e;
        }
    }

    private ArtifactDescriptorResult describe(Artifact artifact) throws BomDecomposerException {
        return this.resolver().describe(artifact);
    }

    private ArtifactResolver resolver() {
        return this.resolver == null ? (this.resolver = ArtifactResolverProvider.get()) : this.resolver;
    }

    public static void main(String[] args) throws Exception {
        Path srcPomDir = Paths.get(System.getProperty("user.home"), new String[0]).resolve("git").resolve("quarkus-platform").resolve("bom");
        Path outputDir = Paths.get("target", new String[0]).resolve("boms");
        PlatformBomConfig config = PlatformBomConfig.builder().pomResolver(PomSource.of((Path)srcPomDir.resolve("pom.xml"))).build();
        try (ReportIndexPageGenerator index = new ReportIndexPageGenerator(outputDir.resolve("index.html"));){
            PlatformBomComposer bomComposer = new PlatformBomComposer(config);
            DecomposedBom generatedBom = bomComposer.platformBom();
            Path generatedReleasesFile = PlatformBomComposer.generateReleasesHtml(generatedBom, outputDir);
            index.universalBom(generatedBom.bomResolver().pomPath().toUri().toURL(), generatedBom, generatedReleasesFile);
            for (DecomposedBom importedBom : bomComposer.alignedMemberBoms()) {
                PlatformBomComposer.report(bomComposer.originalMemberBom(importedBom.bomArtifact()), importedBom, outputDir, index);
            }
        }
    }

    private static void report(DecomposedBom originalBom, DecomposedBom generatedBom, Path outputDir, ReportIndexPageGenerator index) throws IOException, BomDecomposerException {
        outputDir = outputDir.resolve(PlatformBomComposer.bomDirName(generatedBom.bomArtifact()));
        Path platformBomXml = outputDir.resolve("pom.xml");
        PomUtils.toPom((DecomposedBom)generatedBom, (Path)platformBomXml);
        BomDiff.Config config = BomDiff.config();
        if (generatedBom.bomResolver().isResolved()) {
            config.compare(generatedBom.bomResolver().pomPath());
        } else {
            config.compare(generatedBom.bomArtifact());
        }
        BomDiff bomDiff = config.to(platformBomXml);
        Path diffFile = outputDir.resolve("diff.html");
        HtmlBomDiffReportGenerator.config((Path)diffFile).report(bomDiff);
        Path generatedReleasesFile = PlatformBomComposer.generateReleasesHtml(generatedBom, outputDir);
        Path originalReleasesFile = outputDir.resolve("original-releases.html");
        originalBom.visit((DecomposedBomVisitor)DecomposedBomHtmlReportGenerator.builder((Path)originalReleasesFile).skipOriginsWithSingleRelease().build());
        index.bomReport(bomDiff.mainUrl(), bomDiff.toUrl(), generatedBom, originalReleasesFile, generatedReleasesFile, diffFile);
    }

    private static Path generateReleasesHtml(DecomposedBom generatedBom, Path outputDir) throws BomDecomposerException {
        Path generatedReleasesFile = outputDir.resolve("generated-releases.html");
        generatedBom.visit((DecomposedBomVisitor)DecomposedBomHtmlReportGenerator.builder((Path)generatedReleasesFile).skipOriginsWithSingleRelease().build());
        return generatedReleasesFile;
    }

    private static String bomDirName(Artifact a) {
        return a.getGroupId() + "." + a.getArtifactId() + "-" + a.getVersion();
    }
}

