/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.platform;

import io.quarkus.bom.platform.ExtensionDeps;
import io.quarkus.bom.platform.PlatformBomMemberConfig;
import io.quarkus.bootstrap.model.AppArtifactKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class PlatformMemberExtensions {
    private final PlatformBomMemberConfig config;
    private final Map<AppArtifactKey, ExtensionDeps> extDeps = new HashMap<AppArtifactKey, ExtensionDeps>();

    PlatformMemberExtensions(PlatformBomMemberConfig config) {
        this.config = config;
    }

    void addExtension(ExtensionDeps ext) {
        for (ExtensionDeps e : this.extDeps.values()) {
            if (e.isRuntimeDep(ext.key())) {
                e.addExtensionDep(ext);
                continue;
            }
            if (!ext.isRuntimeDep(e.key())) continue;
            ext.addExtensionDep(e);
        }
        this.extDeps.put(ext.key(), ext);
    }

    ExtensionDeps getExtension(AppArtifactKey extKey) {
        ExtensionDeps ext = this.extDeps.get(extKey);
        if (ext == null) {
            throw new IllegalArgumentException(this.config.key() + " does not include extension " + extKey);
        }
        return ext;
    }

    Collection<ExtensionDeps> getFilteredOutExtensions() {
        Collection<AppArtifactKey> extCatalog = this.config.getExtensionCatalog();
        if (extCatalog.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ExtensionDeps> list = new ArrayList<ExtensionDeps>(this.extDeps.size() - extCatalog.size());
        TreeMap<AppArtifactKey, List> nonProdDeps = null;
        for (ExtensionDeps extensionDeps : this.extDeps.values()) {
            if (!extCatalog.contains(extensionDeps.key())) {
                list.add(extensionDeps);
                continue;
            }
            for (AppArtifactKey d : extensionDeps.getExtensionDeps()) {
                if (extCatalog.contains(d)) continue;
                if (nonProdDeps == null) {
                    nonProdDeps = new TreeMap<AppArtifactKey, List>(AppArtifactKeyComparator.getInstance());
                }
                nonProdDeps.computeIfAbsent(d, k -> new ArrayList()).add(extensionDeps.key());
            }
        }
        if (nonProdDeps != null) {
            for (Map.Entry entry : nonProdDeps.entrySet()) {
                System.out.println("Not supported extension " + entry.getKey() + " is a dependency of supported extensions:");
                Collections.sort((List)entry.getValue(), AppArtifactKeyComparator.getInstance());
                for (AppArtifactKey k2 : (List)entry.getValue()) {
                    System.out.println(" - " + k2);
                }
            }
        }
        return list;
    }

    private static class AppArtifactKeyComparator
    implements Comparator<AppArtifactKey> {
        private static AppArtifactKeyComparator instance;

        private AppArtifactKeyComparator() {
        }

        static AppArtifactKeyComparator getInstance() {
            return instance == null ? (instance = new AppArtifactKeyComparator()) : instance;
        }

        @Override
        public int compare(AppArtifactKey o1, AppArtifactKey o2) {
            int i = o1.getGroupId().compareTo(o2.getGroupId());
            if (i != 0) {
                return i;
            }
            i = o1.getArtifactId().compareTo(o2.getArtifactId());
            if (i != 0) {
                return i;
            }
            i = o1.getClassifier().compareTo(o2.getClassifier());
            if (i != 0) {
                return i;
            }
            i = o1.getType().compareTo(o2.getType());
            if (i != 0) {
                return i;
            }
            return 0;
        }
    }
}

