/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.quarkus.bom.decomposer.maven.platformgen.PlatformReleaseWithMembersConfig;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.bootstrap.util.ZipUtils;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.maven.ArtifactKey;
import io.quarkus.registry.catalog.Category;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.json.JsonCatalogMapperHelper;
import io.quarkus.registry.catalog.json.JsonCatalogMerger;
import io.quarkus.registry.catalog.json.JsonCategory;
import io.quarkus.registry.catalog.json.JsonExtension;
import io.quarkus.registry.catalog.json.JsonExtensionCatalog;
import io.quarkus.registry.catalog.json.JsonExtensionOrigin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;

@Mojo(name="generate-platform-descriptor", threadSafe=true)
public class GeneratePlatformDescriptorJsonMojo
extends AbstractMojo {
    @Parameter(property="quarkusCoreGroupId", defaultValue="io.quarkus")
    private String quarkusCoreGroupId;
    @Parameter(property="quarkusCoreArtifactId", defaultValue="quarkus-core")
    private String quarkusCoreArtifactId;
    @Parameter(property="bomGroupId", defaultValue="${project.groupId}")
    private String bomGroupId;
    @Parameter(property="bomArtifactId", defaultValue="${project.artifactId}")
    private String bomArtifactId;
    @Parameter(property="bomVersion", defaultValue="${project.version}")
    private String bomVersion;
    @Parameter
    private List<String> metadataOverrideArtifacts = Collections.emptyList();
    @Parameter(property="overridesFile", defaultValue="${project.basedir}/src/main/resources/extensions-overrides.json")
    private String overridesFile;
    @Parameter(property="outputFile", defaultValue="${project.build.directory}/${project.artifactId}-${project.version}-${project.version}.json")
    private File outputFile;
    @Component
    private RepositorySystem repoSystem;
    @Component
    RemoteRepositoryManager remoteRepoManager;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repos;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(required=false)
    PlatformReleaseWithMembersConfig platformRelease;
    @Parameter
    private Set<String> ignoredGroupIds = new HashSet<String>(0);
    @Parameter
    private Set<String> processGroupIds = new HashSet<String>(1);
    @Parameter
    private boolean skipArtifactIdCheck;
    @Parameter(property="skipBomCheck")
    private boolean skipBomCheck;
    @Parameter(property="skipCategoryCheck")
    boolean skipCategoryCheck;
    @Parameter(property="resolveDependencyManagement")
    boolean resolveDependencyManagement;
    @Parameter(required=false)
    String quarkusCoreVersion;
    @Parameter(required=false)
    String upstreamQuarkusCoreVersion;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Set catalogCategories;
        List<Dependency> deps;
        DefaultArtifact jsonArtifact = new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "json", this.project.getVersion());
        if (!this.skipArtifactIdCheck) {
            String expectedArtifactId = this.bomArtifactId + "-quarkus-platform-descriptor";
            if (!jsonArtifact.getArtifactId().equals(expectedArtifactId)) {
                throw new MojoExecutionException("The project's artifactId " + this.project.getArtifactId() + " is expected to be " + expectedArtifactId);
            }
            if (!jsonArtifact.getGroupId().equals(this.bomGroupId)) {
                throw new MojoExecutionException("The project's groupId " + this.project.getGroupId() + " is expected to match the groupId of the BOM which is " + this.bomGroupId);
            }
            if (!jsonArtifact.getVersion().equals(this.bomVersion)) {
                throw new MojoExecutionException("The project's version " + this.project.getVersion() + " is expected to match the version of the BOM which is " + this.bomVersion);
            }
        }
        DefaultArtifact bomArtifact = new DefaultArtifact(this.bomGroupId, this.bomArtifactId, "", "pom", this.bomVersion);
        this.info("Generating catalog of extensions for %s", bomArtifact);
        if (this.resolveDependencyManagement) {
            this.getLog().debug((CharSequence)"Resolving dependencyManagement from the artifact descriptor");
            deps = this.dependencyManagementFromDescriptor((Artifact)bomArtifact);
        } else {
            deps = this.dependencyManagementFromProject();
            if (deps == null) {
                deps = this.dependencyManagementFromResolvedPom((Artifact)bomArtifact);
            }
        }
        if (deps.isEmpty()) {
            this.getLog().warn((CharSequence)("BOM " + bomArtifact + " does not include any dependency"));
            return;
        }
        ArrayList<OverrideInfo> allOverrides = new ArrayList<OverrideInfo>();
        if (!this.metadataOverrideArtifacts.isEmpty()) {
            for (String s : this.metadataOverrideArtifacts) {
                File f;
                ArtifactCoords coords = ArtifactCoords.fromString((String)s);
                try {
                    f = this.repoSystem.resolveArtifact(this.repoSession, new ArtifactRequest().setArtifact((Artifact)new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType(), coords.getVersion())).setRepositories(this.repos)).getArtifact().getFile();
                }
                catch (ArtifactResolutionException e) {
                    throw new MojoExecutionException("Failed to resolve metadata override artifact " + coords, (Exception)((Object)e));
                }
                allOverrides.add(this.getOverrideInfo(f));
            }
        }
        for (String path : this.overridesFile.split(",")) {
            File f = new File(path.trim());
            if (!f.exists()) continue;
            allOverrides.add(this.getOverrideInfo(f));
        }
        JsonExtensionCatalog platformJson = new JsonExtensionCatalog();
        String platformId = jsonArtifact.getGroupId() + ":" + jsonArtifact.getArtifactId() + ":" + jsonArtifact.getClassifier() + ":" + jsonArtifact.getExtension() + ":" + jsonArtifact.getVersion();
        platformJson.setId(platformId);
        platformJson.setBom(ArtifactCoords.pom((String)this.bomGroupId, (String)this.bomArtifactId, (String)this.bomVersion));
        platformJson.setPlatform(true);
        List importedDescriptors = deps.stream().filter(arg_0 -> GeneratePlatformDescriptorJsonMojo.lambda$execute$0((Artifact)jsonArtifact, arg_0)).map(d -> new DefaultArtifact(d.getArtifact().getGroupId(), d.getArtifact().getArtifactId(), d.getArtifact().getClassifier(), d.getArtifact().getExtension(), d.getArtifact().getVersion())).collect(Collectors.toList());
        Map<ArtifactKey, JsonExtension> inheritedExtensions = Collections.emptyMap();
        if (!importedDescriptors.isEmpty()) {
            MavenArtifactResolver mvnResolver;
            try {
                mvnResolver = ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setRepositorySystem(this.repoSystem)).setRemoteRepositoryManager(this.remoteRepoManager)).setRepositorySystemSession(this.repoSession)).setRemoteRepositories(this.repos)).setWorkspaceDiscovery(false)).build();
            }
            catch (BootstrapMavenException e) {
                throw new MojoExecutionException("Failed to initialize Maven artifact resolver", (Exception)((Object)e));
            }
            ArrayList<ExtensionCatalog> importedCatalogs = new ArrayList<ExtensionCatalog>(importedDescriptors.size());
            try {
                for (Artifact a : importedDescriptors) {
                    importedCatalogs.add((ExtensionCatalog)JsonCatalogMapperHelper.deserialize((Path)mvnResolver.resolve(a).getArtifact().getFile().toPath(), JsonExtensionCatalog.class));
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to resolver inherited platform descriptor", e);
            }
            ExtensionCatalog baseCatalog = JsonCatalogMerger.merge(importedCatalogs);
            ArrayList<JsonExtensionOrigin> derivedFrom = baseCatalog.getDerivedFrom();
            if (baseCatalog.getId() != null) {
                derivedFrom = new ArrayList<JsonExtensionOrigin>(derivedFrom);
                JsonExtensionOrigin origin = new JsonExtensionOrigin();
                origin.setId(baseCatalog.getId());
                origin.setPlatform(baseCatalog.isPlatform());
                origin.setBom(baseCatalog.getBom());
                derivedFrom.add(origin);
            }
            platformJson.setDerivedFrom((List)derivedFrom);
            platformJson.setCategories(baseCatalog.getCategories());
            Collection extensions = baseCatalog.getExtensions();
            if (!extensions.isEmpty()) {
                inheritedExtensions = new HashMap(extensions.size());
                for (Extension e : extensions) {
                    inheritedExtensions.put(e.getArtifact().getKey(), (JsonExtension)e);
                }
            }
            platformJson.setMetadata(baseCatalog.getMetadata());
        }
        HashSet referencedCategories = new HashSet();
        ArrayList<JsonExtension> extListJson = new ArrayList<JsonExtension>();
        platformJson.setExtensions(extListJson);
        boolean jsonFoundInBom = false;
        for (Dependency dep : deps) {
            List<Object> origins;
            JsonExtension extension;
            Artifact artifact = dep.getArtifact();
            if (!this.skipBomCheck && !jsonFoundInBom) {
                boolean bl = jsonFoundInBom = artifact.getArtifactId().equals(jsonArtifact.getArtifactId()) && artifact.getGroupId().equals(jsonArtifact.getGroupId()) && artifact.getExtension().equals(jsonArtifact.getExtension()) && artifact.getClassifier().equals(jsonArtifact.getClassifier()) && artifact.getVersion().equals(jsonArtifact.getVersion());
            }
            if (!artifact.getExtension().equals("jar") || "javadoc".equals(artifact.getClassifier()) || "tests".equals(artifact.getClassifier()) || "sources".equals(artifact.getClassifier()) || artifact.getArtifactId().endsWith("-deployment") || (!this.processGroupIds.isEmpty() ? !this.processGroupIds.contains(artifact.getGroupId()) : this.ignoredGroupIds.contains(artifact.getGroupId()))) continue;
            if (this.quarkusCoreVersion == null && artifact.getArtifactId().equals(this.quarkusCoreArtifactId) && artifact.getGroupId().equals(this.quarkusCoreGroupId)) {
                this.quarkusCoreVersion = artifact.getVersion();
            }
            JsonExtension jsonExtension = extension = inheritedExtensions.isEmpty() ? null : (JsonExtension)inheritedExtensions.get(new ArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension()));
            if (extension == null) {
                try {
                    extension = this.processDependency(this.repoSystem.resolveArtifact(this.repoSession, new ArtifactRequest().setRepositories(this.repos).setArtifact(artifact)).getArtifact());
                }
                catch (ArtifactResolutionException e) {
                    this.debug("Failed to resolve dependency %s defined in %s", artifact, bomArtifact);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to process dependency " + artifact, (Exception)e);
                }
                if (extension == null) continue;
                origins = Arrays.asList(platformJson);
            } else {
                origins = new ArrayList<JsonExtensionCatalog>(extension.getOrigins().size() + 1);
                origins.addAll(extension.getOrigins());
                origins.add(platformJson);
            }
            extension.setOrigins(origins);
            String key = this.extensionId((Extension)extension);
            for (OverrideInfo info : allOverrides) {
                Extension extOverride = info.getExtOverrides().get(key);
                if (extOverride == null) continue;
                extension = this.mergeObject(extension, extOverride);
            }
            extListJson.add(extension);
            if (this.skipCategoryCheck) continue;
            try {
                Collection extCategories = (Collection)extension.getMetadata().get("categories");
                if (extCategories == null) continue;
                referencedCategories.addAll(extCategories);
            }
            catch (ClassCastException e) {
                this.getLog().warn((CharSequence)"Failed to cast the extension categories list to java.util.Collection<String>", (Throwable)e);
            }
        }
        if (!this.skipBomCheck && !jsonFoundInBom) {
            throw new MojoExecutionException("Failed to locate " + (Artifact)jsonArtifact + " in the dependencyManagement section of " + bomArtifact);
        }
        if (this.quarkusCoreVersion == null) {
            throw new MojoExecutionException("Failed to determine the Quarkus Core version for " + bomArtifact);
        }
        platformJson.setQuarkusCoreVersion(this.quarkusCoreVersion);
        if (this.upstreamQuarkusCoreVersion != null && !this.upstreamQuarkusCoreVersion.isBlank()) {
            platformJson.setUpstreamQuarkusCoreVersion(this.upstreamQuarkusCoreVersion);
        }
        for (OverrideInfo info : allOverrides) {
            if (info.getTheRest() != null && !info.getTheRest().getCategories().isEmpty()) {
                if (platformJson.getCategories().isEmpty()) {
                    platformJson.setCategories(info.getTheRest().getCategories());
                } else {
                    info.getTheRest().getCategories().stream().forEach(c -> {
                        Category platformC;
                        boolean found = false;
                        Iterator iterator = platformJson.getCategories().iterator();
                        if (iterator.hasNext() && (platformC = (Category)iterator.next()).getId().equals(c.getId())) {
                            found = true;
                            JsonCategory jsonC = (JsonCategory)platformC;
                            if (c.getDescription() != null) {
                                jsonC.setDescription(c.getDescription());
                            }
                            if (!c.getMetadata().isEmpty()) {
                                if (jsonC.getMetadata().isEmpty()) {
                                    jsonC.setMetadata(c.getMetadata());
                                } else {
                                    jsonC.getMetadata().putAll(c.getMetadata());
                                }
                            }
                            if (c.getName() != null) {
                                jsonC.setName(c.getName());
                            }
                        }
                        if (!found) {
                            platformJson.getCategories().add(c);
                        }
                    });
                }
            }
            if (info.getTheRest().getMetadata().isEmpty()) continue;
            if (platformJson.getMetadata().isEmpty()) {
                platformJson.setMetadata(info.getTheRest().getMetadata());
                continue;
            }
            platformJson.getMetadata().putAll(info.getTheRest().getMetadata());
        }
        if (this.platformRelease != null) {
            if (platformJson.getMetadata().isEmpty()) {
                platformJson.setMetadata(new HashMap(1));
            }
            platformJson.getMetadata().put("platform-release", this.platformRelease);
        }
        if (!this.skipCategoryCheck && !(catalogCategories = platformJson.getCategories().stream().map(c -> c.getId()).collect(Collectors.toSet())).containsAll(referencedCategories)) {
            List missing = referencedCategories.stream().filter(c -> !catalogCategories.contains(c)).collect(Collectors.toList());
            StringBuilder buf = new StringBuilder();
            buf.append("The following categories referenced from extensions are missing from the generated catalog: ");
            buf.append((String)missing.get(0));
            for (int i = 1; i < missing.size(); ++i) {
                buf.append(", ").append((String)missing.get(i));
            }
            throw new MojoExecutionException(buf.toString());
        }
        File outputDir = this.outputFile.getParentFile();
        if (this.outputFile.exists()) {
            this.outputFile.delete();
        } else if (!outputDir.exists() && !outputDir.mkdirs()) {
            throw new MojoExecutionException("Failed to create output directory " + outputDir);
        }
        try {
            JsonCatalogMapperHelper.serialize((Object)platformJson, (Path)this.outputFile.toPath().getParent().resolve(this.outputFile.getName()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to persist the platform descriptor", (Exception)e);
        }
        this.info("Extensions file written to %s", this.outputFile);
        File published = new File(this.project.getBuild().getDirectory(), LocalWorkspace.getFileName((Artifact)jsonArtifact));
        if (!outputDir.equals(published)) {
            try {
                IoUtils.copy((Path)this.outputFile.toPath(), (Path)published.toPath());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy " + this.outputFile + " to " + published);
            }
        }
        this.projectHelper.attachArtifact(this.project, jsonArtifact.getExtension(), jsonArtifact.getClassifier(), published);
    }

    private List<Dependency> dependencyManagementFromDescriptor(Artifact bomArtifact) throws MojoExecutionException {
        try {
            return this.repoSystem.readArtifactDescriptor(this.repoSession, new ArtifactDescriptorRequest().setRepositories(this.repos).setArtifact(bomArtifact)).getManagedDependencies();
        }
        catch (ArtifactDescriptorException e) {
            throw new MojoExecutionException("Failed to read descriptor of " + bomArtifact, (Exception)((Object)e));
        }
    }

    private List<Dependency> dependencyManagementFromResolvedPom(Artifact bomArtifact) throws MojoExecutionException {
        Path pomXml;
        try {
            pomXml = this.repoSystem.resolveArtifact(this.repoSession, new ArtifactRequest().setArtifact(bomArtifact).setRepositories(this.repos)).getArtifact().getFile().toPath();
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Failed to resolve " + bomArtifact, (Exception)((Object)e));
        }
        return this.readDependencyManagement(pomXml);
    }

    private List<Dependency> dependencyManagementFromProject() throws MojoExecutionException {
        if (!(this.project.getArtifact().getArtifactId().equals(this.bomArtifactId) && this.project.getArtifact().getVersion().equals(this.bomVersion) && this.project.getArtifact().getGroupId().equals(this.bomGroupId) && this.project.getFile().exists())) {
            return null;
        }
        return this.readDependencyManagement(this.project.getFile().toPath());
    }

    private List<Dependency> readDependencyManagement(Path pomXml) throws MojoExecutionException {
        Model bomModel;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Reading dependencyManagement from " + pomXml));
        }
        try {
            bomModel = ModelUtils.readModel((Path)pomXml);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to parse " + this.project.getFile(), (Exception)e);
        }
        if (bomModel.getParent() != null) {
            throw new MojoExecutionException(pomXml + " has a parent, in which case it is recommended to set 'resolveDependencyManagement' parameter to true");
        }
        if (bomModel.getDependencyManagement() == null) {
            return Collections.emptyList();
        }
        List modelDeps = bomModel.getDependencyManagement().getDependencies();
        if (modelDeps.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Dependency> deps = new ArrayList<Dependency>(modelDeps.size());
        for (org.apache.maven.model.Dependency modelDep : modelDeps) {
            DefaultArtifact artifact = new DefaultArtifact(modelDep.getGroupId(), modelDep.getArtifactId(), modelDep.getClassifier(), modelDep.getType(), modelDep.getVersion());
            deps.add(new Dependency((Artifact)artifact, modelDep.getScope(), Boolean.valueOf(modelDep.isOptional()), Collections.emptyList()));
        }
        return deps;
    }

    private JsonExtension processDependency(Artifact artifact) throws IOException {
        Path path = artifact.getFile().toPath();
        if (Files.isDirectory(path, new LinkOption[0])) {
            return this.processMetaInfDir(artifact, path.resolve("META-INF"));
        }
        try (FileSystem artifactFs = ZipUtils.newFileSystem((Path)path);){
            JsonExtension jsonExtension = this.processMetaInfDir(artifact, artifactFs.getPath("META-INF", new String[0]));
            return jsonExtension;
        }
    }

    private JsonExtension processMetaInfDir(Artifact artifact, Path metaInfDir) throws IOException {
        ObjectMapper mapper = null;
        if (!Files.exists(metaInfDir, new LinkOption[0])) {
            return null;
        }
        Path yaml = metaInfDir.resolve("quarkus-extension.yaml");
        if (Files.exists(yaml, new LinkOption[0])) {
            mapper = this.getMapper(true);
            return this.processPlatformArtifact(artifact, yaml, mapper);
        }
        JsonExtension e = null;
        mapper = this.getMapper(false);
        Path json = metaInfDir.resolve("quarkus-extension.json");
        if (!Files.exists(json, new LinkOption[0])) {
            Path props = metaInfDir.resolve("quarkus-extension.properties");
            if (Files.exists(props, new LinkOption[0])) {
                e = new JsonExtension();
                e.setArtifact(new ArtifactCoords(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), artifact.getVersion()));
                e.setName(artifact.getArtifactId());
            }
        } else {
            e = this.processPlatformArtifact(artifact, json, mapper);
        }
        return e;
    }

    private JsonExtension processPlatformArtifact(Artifact artifact, Path descriptor, ObjectMapper mapper) throws IOException {
        JsonExtension jsonExtension;
        block8: {
            InputStream is = Files.newInputStream(descriptor, new OpenOption[0]);
            try {
                JsonExtension legacy = (JsonExtension)mapper.readValue(is, JsonExtension.class);
                JsonExtension object = this.transformLegacyToNew(legacy);
                this.debug("Adding Quarkus extension %s", object.getArtifact());
                jsonExtension = object;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException io) {
                    throw new IOException("Failed to parse " + descriptor, io);
                }
            }
            is.close();
        }
        return jsonExtension;
    }

    private ObjectMapper getMapper(boolean yaml) {
        if (yaml) {
            YAMLFactory yf = new YAMLFactory();
            return JsonCatalogMapperHelper.initMapper((ObjectMapper)new ObjectMapper((JsonFactory)yf));
        }
        return JsonCatalogMapperHelper.mapper();
    }

    private String extensionId(Extension extObject) {
        return extObject.getArtifact().getGroupId() + ":" + extObject.getArtifact().getArtifactId();
    }

    private JsonExtension mergeObject(JsonExtension extObject, Extension extOverride) {
        ArtifactCoords overrideCoords = extOverride.getArtifact();
        if (overrideCoords != null) {
            if (overrideCoords.getGroupId() != null && overrideCoords.getArtifactId() != null && overrideCoords.getVersion() != null) {
                extObject.setArtifact(overrideCoords);
            } else {
                ArtifactCoords originalCoords = extObject.getArtifact();
                extObject.setArtifact(new ArtifactCoords(overrideCoords.getGroupId() == null ? originalCoords.getGroupId() : overrideCoords.getGroupId(), overrideCoords.getArtifactId() == null ? originalCoords.getArtifactId() : overrideCoords.getArtifactId(), overrideCoords.getClassifier(), overrideCoords.getType() == null ? originalCoords.getType() : overrideCoords.getType(), overrideCoords.getVersion() == null ? originalCoords.getVersion() : overrideCoords.getVersion()));
            }
        }
        if (!extOverride.getMetadata().isEmpty()) {
            if (extObject.getMetadata().isEmpty()) {
                extObject.setMetadata(extOverride.getMetadata());
            } else {
                extObject.getMetadata().putAll(extOverride.getMetadata());
            }
        }
        if (extOverride.getName() != null) {
            extObject.setName(extOverride.getName());
        }
        if (!extOverride.getOrigins().isEmpty()) {
            extObject.setOrigins(extOverride.getOrigins());
        }
        return extObject;
    }

    private void info(String msg, Object ... args) {
        if (!this.getLog().isInfoEnabled()) {
            return;
        }
        if (args.length == 0) {
            this.getLog().info((CharSequence)msg);
            return;
        }
        this.getLog().info((CharSequence)String.format(msg, args));
    }

    private void debug(String msg, Object ... args) {
        if (!this.getLog().isDebugEnabled()) {
            return;
        }
        if (args.length == 0) {
            this.getLog().debug((CharSequence)msg);
            return;
        }
        this.getLog().debug((CharSequence)String.format(msg, args));
    }

    private JsonExtension transformLegacyToNew(JsonExtension extObject) {
        Map metadata = extObject.getMetadata();
        Object labels = metadata.get("labels");
        if (labels != null) {
            metadata.put("keywords", labels);
            metadata.remove("labels");
        }
        return extObject;
    }

    public OverrideInfo getOverrideInfo(File overridesFile) throws MojoExecutionException {
        JsonExtensionCatalog overridesObject;
        if (!overridesFile.isFile()) {
            throw new MojoExecutionException(overridesFile + " is not a file");
        }
        HashMap<String, Extension> extOverrides = new HashMap<String, Extension>();
        this.info("Loading overrides file %s", overridesFile);
        try {
            overridesObject = (JsonExtensionCatalog)JsonCatalogMapperHelper.deserialize((Path)overridesFile.toPath(), JsonExtensionCatalog.class);
            List extensionsOverrides = overridesObject.getExtensions();
            if (!extensionsOverrides.isEmpty()) {
                for (Extension extOverride : extensionsOverrides) {
                    extOverrides.put(this.extensionId(extOverride), extOverride);
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read " + overridesFile, (Exception)e);
        }
        return new OverrideInfo(extOverrides, overridesObject);
    }

    private static /* synthetic */ boolean lambda$execute$0(Artifact jsonArtifact, Dependency d) {
        return d.getArtifact().getArtifactId().endsWith("-quarkus-platform-descriptor") && d.getArtifact().getExtension().equals("json") && (!d.getArtifact().getArtifactId().equals(jsonArtifact.getArtifactId()) || !d.getArtifact().getGroupId().equals(jsonArtifact.getGroupId()));
    }

    private static class OverrideInfo {
        private Map<String, Extension> extOverrides;
        private JsonExtensionCatalog theRest;

        public OverrideInfo(Map<String, Extension> extOverrides, JsonExtensionCatalog theRest) {
            this.extOverrides = extOverrides;
            this.theRest = theRest;
        }

        public Map<String, Extension> getExtOverrides() {
            return this.extOverrides;
        }

        public JsonExtensionCatalog getTheRest() {
            return this.theRest;
        }
    }
}

