/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven;

import io.quarkus.bom.decomposer.BomDecomposer;
import io.quarkus.bom.decomposer.DecomposedBom;
import io.quarkus.bom.decomposer.DecomposedBomHtmlReportGenerator;
import io.quarkus.bom.decomposer.DecomposedBomReleasesLogger;
import io.quarkus.bom.decomposer.DecomposedBomVisitor;
import io.quarkus.bom.decomposer.maven.MojoMessageWriter;
import io.quarkus.devtools.messagewriter.MessageWriter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="report-release-versions", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ReleaseVersionsReportMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter(property="bomHtmlReport", defaultValue="true")
    protected boolean htmlReport = true;
    @Parameter(defaultValue="${bomReportAll}")
    protected boolean reportAll;
    @Parameter(property="bomReportLogging", defaultValue="DEBUG")
    protected DecomposedBomReleasesLogger.Level reportLogging;
    @Parameter(property="bomConflict", defaultValue="WARN")
    protected DecomposedBomReleasesLogger.Level bomConflict;
    @Parameter(property="bomResolvableConflict", defaultValue="ERROR")
    protected DecomposedBomReleasesLogger.Level bomResolvableConflict;
    @Parameter(property="bomSkipUpdates", defaultValue="false")
    protected boolean skipUpdates;
    @Parameter(defaultValue="${skipBomReport}")
    protected boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        try {
            this.decompose();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to analyze managed dependencies of " + this.project.getArtifact(), e);
        }
    }

    private void decompose() throws Exception {
        MojoMessageWriter msgWriter = new MojoMessageWriter(this.getLog());
        BomDecomposer.BomDecomposerConfig config = BomDecomposer.config().logger((MessageWriter)msgWriter).debug().bomArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion());
        if (!this.skipUpdates) {
            config.checkForUpdates();
        }
        DecomposedBom decomposedBom = config.decompose();
        if (this.htmlReport) {
            DecomposedBomHtmlReportGenerator.HtmlWriterBuilder htmlWriter = DecomposedBomHtmlReportGenerator.builder((String)"target/bom-report.html");
            if (!this.reportAll) {
                htmlWriter.skipOriginsWithSingleRelease();
            }
            decomposedBom.visit((DecomposedBomVisitor)htmlWriter.build());
        }
        if (this.reportLogging != null || this.bomConflict != null || this.bomResolvableConflict != null) {
            DecomposedBomReleasesLogger.Config loggerConfig = DecomposedBomReleasesLogger.config((!this.reportAll ? 1 : 0) != 0);
            if (this.reportLogging != null) {
                loggerConfig.defaultLogLevel(this.reportLogging);
            }
            if (this.bomConflict != null) {
                loggerConfig.conflictLogLevel(this.bomConflict);
            }
            if (this.bomResolvableConflict != null) {
                loggerConfig.resolvableConflictLogLevel(this.bomResolvableConflict);
            }
            decomposedBom.visit((DecomposedBomVisitor)loggerConfig.logger((MessageWriter)msgWriter).build());
        }
    }
}

