/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.RedisDataSource;
import io.quarkus.redis.datasource.ScanArgs;
import io.quarkus.redis.datasource.SortArgs;
import io.quarkus.redis.datasource.list.KeyValue;
import io.quarkus.redis.datasource.sortedset.Range;
import io.quarkus.redis.datasource.sortedset.ReactiveSortedSetCommands;
import io.quarkus.redis.datasource.sortedset.ScoreRange;
import io.quarkus.redis.datasource.sortedset.ScoredValue;
import io.quarkus.redis.datasource.sortedset.SortedSetCommands;
import io.quarkus.redis.datasource.sortedset.ZAddArgs;
import io.quarkus.redis.datasource.sortedset.ZAggregateArgs;
import io.quarkus.redis.datasource.sortedset.ZRangeArgs;
import io.quarkus.redis.datasource.sortedset.ZScanCursor;
import io.quarkus.redis.runtime.datasource.AbstractRedisCommandGroup;
import io.quarkus.redis.runtime.datasource.ZScanBlockingCursorImpl;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.stream.Collectors;

public class BlockingSortedSetCommandsImpl<K, V>
extends AbstractRedisCommandGroup
implements SortedSetCommands<K, V> {
    private final ReactiveSortedSetCommands<K, V> reactive;

    public BlockingSortedSetCommandsImpl(RedisDataSource ds, ReactiveSortedSetCommands<K, V> reactive, Duration timeout) {
        super(ds, timeout);
        this.reactive = reactive;
    }

    @Override
    public boolean zadd(K key, double score, V member) {
        return (Boolean)this.reactive.zadd(key, score, member).await().atMost(this.timeout);
    }

    @Override
    public int zadd(K key, Map<V, Double> items) {
        return (Integer)this.reactive.zadd(key, items).await().atMost(this.timeout);
    }

    @Override
    @SafeVarargs
    public final int zadd(K key, ScoredValue<V> ... items) {
        return (Integer)this.reactive.zadd(key, items).await().atMost(this.timeout);
    }

    @Override
    public boolean zadd(K key, ZAddArgs zAddArgs, double score, V member) {
        return (Boolean)this.reactive.zadd(key, zAddArgs, score, member).await().atMost(this.timeout);
    }

    @Override
    public int zadd(K key, ZAddArgs zAddArgs, Map<V, Double> items) {
        return (Integer)this.reactive.zadd(key, zAddArgs, items).await().atMost(this.timeout);
    }

    @Override
    @SafeVarargs
    public final int zadd(K key, ZAddArgs zAddArgs, ScoredValue<V> ... items) {
        return (Integer)this.reactive.zadd(key, zAddArgs, items).await().atMost(this.timeout);
    }

    @Override
    public double zaddincr(K key, double score, V member) {
        return (Double)this.reactive.zaddincr(key, score, member).await().atMost(this.timeout);
    }

    @Override
    public OptionalDouble zaddincr(K key, ZAddArgs zAddArgs, double score, V member) {
        return (OptionalDouble)this.reactive.zaddincr(key, zAddArgs, score, member).map(d -> {
            if (d == null) {
                return OptionalDouble.empty();
            }
            return OptionalDouble.of(d);
        }).await().atMost(this.timeout);
    }

    @Override
    public long zcard(K key) {
        return (Long)this.reactive.zcard(key).await().atMost(this.timeout);
    }

    @Override
    public long zcount(K key, ScoreRange<Double> range) {
        return (Long)this.reactive.zcount(key, range).await().atMost(this.timeout);
    }

    @Override
    public List<V> zdiff(K ... keys) {
        return (List)this.reactive.zdiff(keys).await().atMost(this.timeout);
    }

    @Override
    public List<ScoredValue<V>> zdiffWithScores(K ... keys) {
        return (List)this.reactive.zdiffWithScores(keys).await().atMost(this.timeout);
    }

    @Override
    public long zdiffstore(K destination, K ... keys) {
        return (Long)this.reactive.zdiffstore(destination, keys).await().atMost(this.timeout);
    }

    @Override
    public double zincrby(K key, double increment, V member) {
        return (Double)this.reactive.zincrby(key, increment, member).await().atMost(this.timeout);
    }

    @Override
    public List<V> zinter(ZAggregateArgs arguments, K ... keys) {
        return (List)this.reactive.zinter(arguments, keys).await().atMost(this.timeout);
    }

    @Override
    public List<V> zinter(K ... keys) {
        return (List)this.reactive.zinter(keys).await().atMost(this.timeout);
    }

    @Override
    public List<ScoredValue<V>> zinterWithScores(ZAggregateArgs arguments, K ... keys) {
        return (List)this.reactive.zinterWithScores(arguments, keys).await().atMost(this.timeout);
    }

    @Override
    public List<ScoredValue<V>> zinterWithScores(K ... keys) {
        return (List)this.reactive.zinterWithScores(keys).await().atMost(this.timeout);
    }

    @Override
    public long zintercard(K ... keys) {
        return (Long)this.reactive.zintercard(keys).await().atMost(this.timeout);
    }

    @Override
    public long zintercard(long limit, K ... keys) {
        return (Long)this.reactive.zintercard(limit, keys).await().atMost(this.timeout);
    }

    @Override
    public long zinterstore(K destination, ZAggregateArgs arguments, K ... keys) {
        return (Long)this.reactive.zinterstore(destination, arguments, keys).await().atMost(this.timeout);
    }

    @Override
    public long zinterstore(K destination, K ... keys) {
        return (Long)this.reactive.zinterstore(destination, keys).await().atMost(this.timeout);
    }

    @Override
    public long zlexcount(K key, Range<String> range) {
        return (Long)this.reactive.zlexcount(key, range).await().atMost(this.timeout);
    }

    @Override
    public ScoredValue<V> zmpopMin(K ... keys) {
        return (ScoredValue)this.reactive.zmpopMin(keys).await().atMost(this.timeout);
    }

    @Override
    public List<ScoredValue<V>> zmpopMin(int count, K ... keys) {
        return (List)this.reactive.zmpopMin(count, keys).await().atMost(this.timeout);
    }

    @Override
    public ScoredValue<V> zmpopMax(K ... keys) {
        return (ScoredValue)this.reactive.zmpopMax(keys).await().atMost(this.timeout);
    }

    @Override
    public List<ScoredValue<V>> zmpopMax(int count, K ... keys) {
        return (List)this.reactive.zmpopMax(count, keys).await().atMost(this.timeout);
    }

    @Override
    public ScoredValue<V> bzmpopMin(Duration timeout, K ... keys) {
        return (ScoredValue)this.reactive.bzmpopMin(timeout, keys).await().atMost(this.timeout);
    }

    @Override
    public List<ScoredValue<V>> bzmpopMin(Duration timeout, int count, K ... keys) {
        return (List)this.reactive.bzmpopMin(timeout, count, keys).await().atMost(this.timeout);
    }

    @Override
    public ScoredValue<V> bzmpopMax(Duration timeout, K ... keys) {
        return (ScoredValue)this.reactive.bzmpopMax(timeout, keys).await().atMost(this.timeout);
    }

    @Override
    public List<ScoredValue<V>> bzmpopMax(Duration timeout, int count, K ... keys) {
        return (List)this.reactive.bzmpopMax(timeout, count, keys).await().atMost(this.timeout);
    }

    @Override
    public List<OptionalDouble> zmscore(K key, V ... members) {
        return (List)this.reactive.zmscore(key, members).map(list -> list.stream().map(d -> {
            if (d == null) {
                return OptionalDouble.empty();
            }
            return OptionalDouble.of(d);
        }).collect(Collectors.toList())).await().atMost(this.timeout);
    }

    @Override
    public ScoredValue<V> zpopmax(K key) {
        return (ScoredValue)this.reactive.zpopmax(key).await().atMost(this.timeout);
    }

    @Override
    public List<ScoredValue<V>> zpopmax(K key, int count) {
        return (List)this.reactive.zpopmax(key, count).await().atMost(this.timeout);
    }

    @Override
    public ScoredValue<V> zpopmin(K key) {
        return (ScoredValue)this.reactive.zpopmin(key).await().atMost(this.timeout);
    }

    @Override
    public List<ScoredValue<V>> zpopmin(K key, int count) {
        return (List)this.reactive.zpopmin(key, count).await().atMost(this.timeout);
    }

    @Override
    public V zrandmember(K key) {
        return (V)this.reactive.zrandmember(key).await().atMost(this.timeout);
    }

    @Override
    public List<V> zrandmember(K key, int count) {
        return (List)this.reactive.zrandmember(key, count).await().atMost(this.timeout);
    }

    @Override
    public ScoredValue<V> zrandmemberWithScores(K key) {
        return (ScoredValue)this.reactive.zrandmemberWithScores(key).await().atMost(this.timeout);
    }

    @Override
    public List<ScoredValue<V>> zrandmemberWithScores(K key, int count) {
        return (List)this.reactive.zrandmemberWithScores(key, count).await().atMost(this.timeout);
    }

    @Override
    public KeyValue<K, ScoredValue<V>> bzpopmin(Duration timeout, K ... keys) {
        return (KeyValue)this.reactive.bzpopmin(timeout, keys).await().atMost(this.timeout);
    }

    @Override
    public KeyValue<K, ScoredValue<V>> bzpopmax(Duration timeout, K ... keys) {
        return (KeyValue)this.reactive.bzpopmax(timeout, keys).await().atMost(this.timeout);
    }

    @Override
    public List<V> zrange(K key, long start, long stop, ZRangeArgs args) {
        return (List)this.reactive.zrange(key, start, stop, args).await().atMost(this.timeout);
    }

    @Override
    public List<ScoredValue<V>> zrangeWithScores(K key, long start, long stop, ZRangeArgs args) {
        return (List)this.reactive.zrangeWithScores(key, start, stop, args).await().atMost(this.timeout);
    }

    @Override
    public List<V> zrange(K key, long start, long stop) {
        return (List)this.reactive.zrange(key, start, stop).await().atMost(this.timeout);
    }

    @Override
    public List<ScoredValue<V>> zrangeWithScores(K key, long start, long stop) {
        return (List)this.reactive.zrangeWithScores(key, start, stop).await().atMost(this.timeout);
    }

    @Override
    public List<V> zrangebylex(K key, Range<String> range, ZRangeArgs args) {
        return (List)this.reactive.zrangebylex(key, range, args).await().atMost(this.timeout);
    }

    @Override
    public List<V> zrangebylex(K key, Range<String> range) {
        return (List)this.reactive.zrangebylex(key, range).await().atMost(this.timeout);
    }

    @Override
    public List<V> zrangebyscore(K key, ScoreRange<Double> range, ZRangeArgs args) {
        return (List)this.reactive.zrangebyscore(key, range, args).await().atMost(this.timeout);
    }

    @Override
    public List<ScoredValue<V>> zrangebyscoreWithScores(K key, ScoreRange<Double> range, ZRangeArgs args) {
        return (List)this.reactive.zrangebyscoreWithScores(key, range, args).await().atMost(this.timeout);
    }

    @Override
    public List<V> zrangebyscore(K key, ScoreRange<Double> range) {
        return (List)this.reactive.zrangebyscore(key, range).await().atMost(this.timeout);
    }

    @Override
    public List<ScoredValue<V>> zrangebyscoreWithScores(K key, ScoreRange<Double> range) {
        return (List)this.reactive.zrangebyscoreWithScores(key, range).await().atMost(this.timeout);
    }

    @Override
    public long zrangestore(K dst, K src, long min, long max, ZRangeArgs args) {
        return (Long)this.reactive.zrangestore(dst, src, min, max, args).await().atMost(this.timeout);
    }

    @Override
    public long zrangestore(K dst, K src, long min, long max) {
        return (Long)this.reactive.zrangestore(dst, src, min, max).await().atMost(this.timeout);
    }

    @Override
    public long zrangestorebylex(K dst, K src, Range<String> range, ZRangeArgs args) {
        return (Long)this.reactive.zrangestorebylex(dst, src, range, args).await().atMost(this.timeout);
    }

    @Override
    public long zrangestorebylex(K dst, K src, Range<String> range) {
        return (Long)this.reactive.zrangestorebylex(dst, src, range).await().atMost(this.timeout);
    }

    @Override
    public long zrangestorebyscore(K dst, K src, ScoreRange<Double> range, ZRangeArgs args) {
        return (Long)this.reactive.zrangestorebyscore(dst, src, range, args).await().atMost(this.timeout);
    }

    @Override
    public long zrangestorebyscore(K dst, K src, ScoreRange<Double> range) {
        return (Long)this.reactive.zrangestorebyscore(dst, src, range).await().atMost(this.timeout);
    }

    @Override
    public OptionalLong zrank(K key, V member) {
        return (OptionalLong)this.reactive.zrank(key, member).map(l -> {
            if (l == null) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(l);
        }).await().atMost(this.timeout);
    }

    @Override
    public int zrem(K key, V ... members) {
        return (Integer)this.reactive.zrem(key, members).await().atMost(this.timeout);
    }

    @Override
    public long zremrangebylex(K key, Range<String> range) {
        return (Long)this.reactive.zremrangebylex(key, range).await().atMost(this.timeout);
    }

    @Override
    public long zremrangebyrank(K key, long start, long stop) {
        return (Long)this.reactive.zremrangebyrank(key, start, stop).await().atMost(this.timeout);
    }

    @Override
    public long zremrangebyscore(K key, ScoreRange<Double> range) {
        return (Long)this.reactive.zremrangebyscore(key, range).await().atMost(this.timeout);
    }

    @Override
    public OptionalLong zrevrank(K key, V member) {
        return (OptionalLong)this.reactive.zrevrank(key, member).map(l -> {
            if (l == null) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(l);
        }).await().atMost(this.timeout);
    }

    @Override
    public ZScanCursor<V> zscan(K key) {
        return new ZScanBlockingCursorImpl<V>(this.reactive.zscan(key), this.timeout);
    }

    @Override
    public ZScanCursor<V> zscan(K key, ScanArgs args) {
        return new ZScanBlockingCursorImpl<V>(this.reactive.zscan(key, args), this.timeout);
    }

    @Override
    public OptionalDouble zscore(K key, V member) {
        return (OptionalDouble)this.reactive.zscore(key, member).map(score -> {
            if (score == null) {
                return OptionalDouble.empty();
            }
            return OptionalDouble.of(score);
        }).await().atMost(this.timeout);
    }

    @Override
    public List<V> zunion(ZAggregateArgs args, K ... keys) {
        return (List)this.reactive.zunion(args, keys).await().atMost(this.timeout);
    }

    @Override
    public List<V> zunion(K ... keys) {
        return (List)this.reactive.zunion(keys).await().atMost(this.timeout);
    }

    @Override
    public List<ScoredValue<V>> zunionWithScores(ZAggregateArgs args, K ... keys) {
        return (List)this.reactive.zunionWithScores(args, keys).await().atMost(this.timeout);
    }

    @Override
    public List<ScoredValue<V>> zunionWithScores(K ... keys) {
        return (List)this.reactive.zunionWithScores(keys).await().atMost(this.timeout);
    }

    @Override
    public long zunionstore(K destination, ZAggregateArgs args, K ... keys) {
        return (Long)this.reactive.zunionstore(destination, args, keys).await().atMost(this.timeout);
    }

    @Override
    public long zunionstore(K destination, K ... keys) {
        return (Long)this.reactive.zunionstore(destination, keys).await().atMost(this.timeout);
    }

    @Override
    public List<V> sort(K key) {
        return (List)this.reactive.sort(key).await().atMost(this.timeout);
    }

    @Override
    public List<V> sort(K key, SortArgs sortArguments) {
        return (List)this.reactive.sort(key, sortArguments).await().atMost(this.timeout);
    }

    @Override
    public long sortAndStore(K key, K destination, SortArgs sortArguments) {
        return (Long)this.reactive.sortAndStore(key, destination, sortArguments).await().atMost(this.timeout);
    }

    @Override
    public long sortAndStore(K key, K destination) {
        return (Long)this.reactive.sortAndStore(key, destination).await().atMost(this.timeout);
    }
}

