/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.RedisDataSource;
import io.quarkus.redis.datasource.topk.ReactiveTopKCommands;
import io.quarkus.redis.datasource.topk.TopKCommands;
import io.quarkus.redis.runtime.datasource.AbstractRedisCommandGroup;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class BlockingTopKCommandsImpl<K, V>
extends AbstractRedisCommandGroup
implements TopKCommands<K, V> {
    private final ReactiveTopKCommands<K, V> reactive;

    public BlockingTopKCommandsImpl(RedisDataSource ds, ReactiveTopKCommands<K, V> reactive, Duration timeout) {
        super(ds, timeout);
        this.reactive = reactive;
    }

    @Override
    public Optional<V> topkAdd(K key, V item) {
        return Optional.ofNullable(this.reactive.topkAdd(key, item).await().atMost(this.timeout));
    }

    @Override
    public List<V> topkAdd(K key, V ... items) {
        return (List)this.reactive.topkAdd(key, items).await().atMost(this.timeout);
    }

    @Override
    public Optional<V> topkIncrBy(K key, V item, int increment) {
        return Optional.ofNullable(this.reactive.topkIncrBy(key, item, increment).await().atMost(this.timeout));
    }

    @Override
    public Map<V, V> topkIncrBy(K key, Map<V, Integer> couples) {
        return (Map)this.reactive.topkIncrBy(key, couples).await().atMost(this.timeout);
    }

    @Override
    public List<V> topkList(K key) {
        return (List)this.reactive.topkList(key).await().atMost(this.timeout);
    }

    @Override
    public Map<V, Integer> topkListWithCount(K key) {
        return (Map)this.reactive.topkListWithCount(key).await().atMost(this.timeout);
    }

    @Override
    public boolean topkQuery(K key, V item) {
        return (Boolean)this.reactive.topkQuery(key, item).await().atMost(this.timeout);
    }

    @Override
    public List<Boolean> topkQuery(K key, V ... items) {
        return (List)this.reactive.topkQuery(key, items).await().atMost(this.timeout);
    }

    @Override
    public void topkReserve(K key, int topk) {
        this.reactive.topkReserve(key, topk).await().atMost(this.timeout);
    }

    @Override
    public void topkReserve(K key, int topk, int width, int depth, double decay) {
        this.reactive.topkReserve(key, topk, width, depth, decay).await().atMost(this.timeout);
    }
}

