/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.runtime;

import java.util.NoSuchElementException;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class ConfigUtils {
    private static final Logger log = Logger.getLogger(ConfigUtils.class);

    public static String getConfigValue(String configProperty, boolean required) {
        String propertyName = ConfigUtils.stripPrefixAndSuffix(configProperty);
        try {
            return (String)ConfigProvider.getConfig().getValue(propertyName, String.class);
        }
        catch (NoSuchElementException e) {
            String message = "Failed to find value for config property " + configProperty + " in application configuration. Please provide the value for the property, e.g. by adding " + propertyName + "=<desired-value> to your application.properties";
            if (required) {
                throw new IllegalArgumentException(message, e);
            }
            log.warn((Object)message);
            return null;
        }
        catch (IllegalArgumentException e) {
            String message = "Failed to convert value for property " + configProperty + " to String";
            if (required) {
                throw new IllegalArgumentException(message, e);
            }
            log.warn((Object)message);
            return null;
        }
    }

    private static String stripPrefixAndSuffix(String configProperty) {
        return configProperty.substring(2, configProperty.length() - 1);
    }
}

