/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.deployment;

import io.quarkus.security.Authenticated;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public class SecurityTransformerUtils {
    public static final DotName DENY_ALL = DotName.createSimple((String)DenyAll.class.getName());
    private static final Set<DotName> SECURITY_ANNOTATIONS = new HashSet<DotName>();

    public static boolean hasSecurityAnnotation(MethodInfo methodInfo) {
        for (AnnotationInstance annotation : methodInfo.annotations()) {
            if (!SECURITY_ANNOTATIONS.contains(annotation.name())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSecurityAnnotation(ClassInfo classInfo) {
        for (AnnotationInstance classAnnotation : classInfo.classAnnotations()) {
            if (!SECURITY_ANNOTATIONS.contains(classAnnotation.name())) continue;
            return true;
        }
        return false;
    }

    static {
        SECURITY_ANNOTATIONS.addAll(Arrays.asList(DotName.createSimple((String)RolesAllowed.class.getName()), DotName.createSimple((String)Authenticated.class.getName()), DotName.createSimple((String)DenyAll.class.getName()), DotName.createSimple((String)PermitAll.class.getName())));
    }
}

