/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.context.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ManagedExecutorInitializedBuildItem;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.smallrye.context.runtime.SmallRyeContextPropagationProvider;
import io.quarkus.smallrye.context.runtime.SmallRyeContextPropagationRecorder;
import io.smallrye.context.SmallRyeManagedExecutor;
import java.io.IOException;
import java.util.ArrayList;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.context.spi.ContextManagerExtension;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;

class SmallRyeContextPropagationProcessor {
    SmallRyeContextPropagationProcessor() {
    }

    @BuildStep
    void registerBean(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(SmallRyeContextPropagationProvider.class));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void buildStatic(SmallRyeContextPropagationRecorder recorder) throws ClassNotFoundException, IOException {
        ArrayList<ThreadContextProvider> discoveredProviders = new ArrayList<ThreadContextProvider>();
        ArrayList<ContextManagerExtension> discoveredExtensions = new ArrayList<ContextManagerExtension>();
        for (Class provider : ServiceUtil.classesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)("META-INF/services/" + ThreadContextProvider.class.getName()))) {
            try {
                discoveredProviders.add((ThreadContextProvider)provider.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Failed to instantiate declared ThreadContextProvider class: " + provider.getName(), e);
            }
        }
        for (Class extension : ServiceUtil.classesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)("META-INF/services/" + ContextManagerExtension.class.getName()))) {
            try {
                discoveredExtensions.add((ContextManagerExtension)extension.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Failed to instantiate declared ThreadContextProvider class: " + extension.getName(), e);
            }
        }
        recorder.configureStaticInit(discoveredProviders, discoveredExtensions);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void build(SmallRyeContextPropagationRecorder recorder, ExecutorBuildItem executorBuildItem, BuildProducer<FeatureBuildItem> feature, BuildProducer<ManagedExecutorInitializedBuildItem> managedExecutorInitialized, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.SMALLRYE_CONTEXT_PROPAGATION));
        recorder.configureRuntime(executorBuildItem.getExecutorProxy());
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(SmallRyeManagedExecutor.class).scope(ApplicationScoped.class)).addType(ManagedExecutor.class)).defaultBean()).unremovable()).supplier(recorder.initializeManagedExecutor(executorBuildItem.getExecutorProxy())).setRuntimeInit().done());
        managedExecutorInitialized.produce((BuildItem)new ManagedExecutorInitializedBuildItem());
    }
}

