/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.resteasy.common.spi.ResteasyDotNames;
import io.quarkus.resteasy.server.common.spi.AllowedJaxRsAnnotationPrefixBuildItem;
import io.quarkus.resteasy.server.common.spi.ResteasyJaxrsConfigBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.smallrye.openapi.common.deployment.SmallRyeOpenApiConfig;
import io.quarkus.smallrye.openapi.deployment.CustomPathExtension;
import io.quarkus.smallrye.openapi.deployment.OpenApiFilteredIndexViewBuildItem;
import io.quarkus.smallrye.openapi.deployment.RESTEasyExtension;
import io.quarkus.smallrye.openapi.deployment.spi.AddToOpenAPIDefinitionBuildItem;
import io.quarkus.smallrye.openapi.runtime.OpenApiDocumentService;
import io.quarkus.smallrye.openapi.runtime.OpenApiRecorder;
import io.quarkus.smallrye.openapi.runtime.OpenApiRuntimeConfig;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiConfigImpl;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import io.smallrye.openapi.runtime.scanner.OpenApiAnnotationScanner;
import io.smallrye.openapi.vertx.VertxConstants;
import io.vertx.core.Handler;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class SmallRyeOpenApiProcessor {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.smallrye.openapi");
    private static final String META_INF_OPENAPI_YAML = "META-INF/openapi.yaml";
    private static final String WEB_INF_CLASSES_META_INF_OPENAPI_YAML = "WEB-INF/classes/META-INF/openapi.yaml";
    private static final String META_INF_OPENAPI_YML = "META-INF/openapi.yml";
    private static final String WEB_INF_CLASSES_META_INF_OPENAPI_YML = "WEB-INF/classes/META-INF/openapi.yml";
    private static final String META_INF_OPENAPI_JSON = "META-INF/openapi.json";
    private static final String WEB_INF_CLASSES_META_INF_OPENAPI_JSON = "WEB-INF/classes/META-INF/openapi.json";
    private static final DotName OPENAPI_SCHEMA = DotName.createSimple((String)Schema.class.getName());
    private static final DotName OPENAPI_RESPONSE = DotName.createSimple((String)APIResponse.class.getName());
    private static final DotName OPENAPI_RESPONSES = DotName.createSimple((String)APIResponses.class.getName());
    private static final String OPENAPI_RESPONSE_CONTENT = "content";
    private static final String OPENAPI_RESPONSE_SCHEMA = "schema";
    private static final String OPENAPI_SCHEMA_NOT = "not";
    private static final String OPENAPI_SCHEMA_ONE_OF = "oneOf";
    private static final String OPENAPI_SCHEMA_ANY_OF = "anyOf";
    private static final String OPENAPI_SCHEMA_ALL_OF = "allOf";
    private static final String OPENAPI_SCHEMA_IMPLEMENTATION = "implementation";
    private static final String JAX_RS = "JAX-RS";
    private static final String SPRING = "Spring";
    private static final String VERT_X = "Vert.x";

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem(Capability.SMALLRYE_OPENAPI);
    }

    @BuildStep
    void contributeClassesToIndex(BuildProducer<AdditionalIndexedClassesBuildItem> additionalIndexedClasses) {
        additionalIndexedClasses.produce((BuildItem)new AdditionalIndexedClassesBuildItem(new String[]{Collection.class.getName(), Map.class.getName(), Object.class.getName()}));
    }

    @BuildStep
    List<HotDeploymentWatchedFileBuildItem> configFiles() {
        return Stream.of(META_INF_OPENAPI_YAML, WEB_INF_CLASSES_META_INF_OPENAPI_YAML, META_INF_OPENAPI_YML, WEB_INF_CLASSES_META_INF_OPENAPI_YML, META_INF_OPENAPI_JSON, WEB_INF_CLASSES_META_INF_OPENAPI_JSON).map(HotDeploymentWatchedFileBuildItem::new).collect(Collectors.toList());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    RouteBuildItem handler(LaunchModeBuildItem launch, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints, OpenApiRecorder recorder, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, OpenApiRuntimeConfig openApiRuntimeConfig, ShutdownContextBuildItem shutdownContext, SmallRyeOpenApiConfig openApiConfig) {
        if (launch.getLaunchMode() == LaunchMode.DEVELOPMENT) {
            recorder.setupClDevMode((ShutdownContext)shutdownContext);
        }
        Handler handler = recorder.handler(openApiRuntimeConfig);
        return nonApplicationRootPathBuildItem.routeBuilder().route(openApiConfig.path).routeConfigKey("quarkus.smallrye-openapi.path").handler(handler).displayOnNotFoundPage("Open API Schema document").requiresLegacyRedirect().blockingRoute().build();
    }

    @BuildStep
    void additionalBean(BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer) {
        additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(OpenApiDocumentService.class).setUnremovable().build());
    }

    @BuildStep
    OpenApiFilteredIndexViewBuildItem smallryeOpenApiIndex(CombinedIndexBuildItem combinedIndexBuildItem, BeanArchiveIndexBuildItem beanArchiveIndexBuildItem) {
        CompositeIndex compositeIndex = CompositeIndex.create((IndexView[])new IndexView[]{combinedIndexBuildItem.getIndex(), beanArchiveIndexBuildItem.getIndex()});
        return new OpenApiFilteredIndexViewBuildItem(new FilteredIndexView((IndexView)compositeIndex, (OpenApiConfig)new OpenApiConfigImpl(ConfigProvider.getConfig())));
    }

    @BuildStep
    public List<AllowedJaxRsAnnotationPrefixBuildItem> registerJaxRsSupportedAnnotation() {
        ArrayList<AllowedJaxRsAnnotationPrefixBuildItem> prefixes = new ArrayList<AllowedJaxRsAnnotationPrefixBuildItem>();
        prefixes.add(new AllowedJaxRsAnnotationPrefixBuildItem("org.eclipse.microprofile.openapi.annotations"));
        return prefixes;
    }

    @BuildStep
    public void registerOpenApiSchemaClassesForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, OpenApiFilteredIndexViewBuildItem openApiFilteredIndexViewBuildItem, Capabilities capabilities) {
        FilteredIndexView index = openApiFilteredIndexViewBuildItem.getIndex();
        if (this.shouldScanAnnotations(capabilities, (IndexView)index)) {
            Collection schemaAnnotationInstances = index.getAnnotations(OPENAPI_SCHEMA);
            for (AnnotationInstance schemaAnnotationInstance : schemaAnnotationInstances) {
                AnnotationTarget typeTarget = schemaAnnotationInstance.target();
                if (typeTarget.kind() != AnnotationTarget.Kind.CLASS) continue;
                this.produceReflectiveHierarchy(reflectiveHierarchy, Type.create((DotName)typeTarget.asClass().name(), (Type.Kind)Type.Kind.CLASS), this.getClass().getSimpleName() + " > " + typeTarget.asClass().name());
            }
            Collection apiResponseAnnotationInstances = index.getAnnotations(OPENAPI_RESPONSE);
            this.registerReflectionForApiResponseSchemaSerialization(reflectiveClass, reflectiveHierarchy, apiResponseAnnotationInstances);
            Collection apiResponsesAnnotationInstances = index.getAnnotations(OPENAPI_RESPONSES);
            for (AnnotationInstance apiResponsesAnnotationInstance : apiResponsesAnnotationInstances) {
                AnnotationValue apiResponsesAnnotationValue = apiResponsesAnnotationInstance.value();
                if (apiResponsesAnnotationValue == null) continue;
                this.registerReflectionForApiResponseSchemaSerialization(reflectiveClass, reflectiveHierarchy, Arrays.asList(apiResponsesAnnotationValue.asNestedArray()));
            }
        }
    }

    private void registerReflectionForApiResponseSchemaSerialization(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, Collection<AnnotationInstance> apiResponseAnnotationInstances) {
        for (AnnotationInstance apiResponseAnnotationInstance : apiResponseAnnotationInstances) {
            AnnotationInstance[] contents;
            AnnotationValue contentAnnotationValue = apiResponseAnnotationInstance.value(OPENAPI_RESPONSE_CONTENT);
            if (contentAnnotationValue == null) continue;
            for (AnnotationInstance content : contents = contentAnnotationValue.asNestedArray()) {
                AnnotationValue schemaNotClass;
                AnnotationValue annotationValue = content.value(OPENAPI_RESPONSE_SCHEMA);
                if (annotationValue == null) continue;
                AnnotationInstance schema = annotationValue.asNested();
                String source = this.getClass().getSimpleName() + " > " + schema.target();
                AnnotationValue schemaImplementationClass = schema.value(OPENAPI_SCHEMA_IMPLEMENTATION);
                if (schemaImplementationClass != null) {
                    this.produceReflectiveHierarchy(reflectiveHierarchy, schemaImplementationClass.asClass(), source);
                }
                if ((schemaNotClass = schema.value(OPENAPI_SCHEMA_NOT)) != null) {
                    reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{schemaNotClass.asString()}));
                }
                this.produceReflectiveHierarchy(reflectiveHierarchy, schema.value(OPENAPI_SCHEMA_ONE_OF), source);
                this.produceReflectiveHierarchy(reflectiveHierarchy, schema.value(OPENAPI_SCHEMA_ANY_OF), source);
                this.produceReflectiveHierarchy(reflectiveHierarchy, schema.value(OPENAPI_SCHEMA_ALL_OF), source);
            }
        }
    }

    @BuildStep
    public void build(ApplicationArchivesBuildItem archivesBuildItem, BuildProducer<FeatureBuildItem> feature, BuildProducer<GeneratedResourceBuildItem> resourceBuildItemBuildProducer, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, OpenApiFilteredIndexViewBuildItem openApiFilteredIndexViewBuildItem, Capabilities capabilities, List<AddToOpenAPIDefinitionBuildItem> openAPIBuildItems, HttpRootPathBuildItem httpRootPathBuildItem, OutputTargetBuildItem out, SmallRyeOpenApiConfig openApiConfig, Optional<ResteasyJaxrsConfigBuildItem> resteasyJaxrsConfig) throws Exception {
        FilteredIndexView index = openApiFilteredIndexViewBuildItem.getIndex();
        feature.produce((BuildItem)new FeatureBuildItem(Feature.SMALLRYE_OPENAPI));
        OpenAPI staticModel = this.generateStaticModel(archivesBuildItem);
        Object annotationModel = this.shouldScanAnnotations(capabilities, (IndexView)index) ? this.generateAnnotationModel((IndexView)index, capabilities, httpRootPathBuildItem, resteasyJaxrsConfig) : new OpenAPIImpl();
        OpenApiDocument finalDocument = this.loadDocument(staticModel, (OpenAPI)annotationModel, openAPIBuildItems);
        for (Format format : Format.values()) {
            String name = "META-INF/quarkus-generated-openapi-doc." + format;
            byte[] schemaDocument = OpenApiSerializer.serialize((OpenAPI)finalDocument.get(), (Format)format).getBytes(StandardCharsets.UTF_8);
            resourceBuildItemBuildProducer.produce((BuildItem)new GeneratedResourceBuildItem(name, schemaDocument));
            nativeImageResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{name}));
        }
        boolean shouldStore = openApiConfig.storeSchemaDirectory.isPresent();
        if (shouldStore) {
            this.storeDocument(out, openApiConfig, staticModel, (OpenAPI)annotationModel, openAPIBuildItems);
        }
    }

    @BuildStep
    LogCleanupFilterBuildItem logCleanup() {
        return new LogCleanupFilterBuildItem("io.smallrye.openapi.api.OpenApiDocument", new String[]{"OpenAPI document initialized:"});
    }

    private void produceReflectiveHierarchy(BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, AnnotationValue annotationValue, String source) {
        if (annotationValue != null) {
            for (Type type : annotationValue.asClassArray()) {
                this.produceReflectiveHierarchy(reflectiveHierarchy, type, source);
            }
        }
    }

    private void produceReflectiveHierarchy(BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, Type type, String source) {
        reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(type).ignoreTypePredicate((Predicate)ResteasyDotNames.IGNORE_TYPE_FOR_REFLECTION_PREDICATE).ignoreFieldPredicate((Predicate)ResteasyDotNames.IGNORE_FIELD_FOR_REFLECTION_PREDICATE).ignoreMethodPredicate((Predicate)ResteasyDotNames.IGNORE_METHOD_FOR_REFLECTION_PREDICATE).source(source).build());
    }

    private void storeGeneratedSchema(SmallRyeOpenApiConfig openApiConfig, OutputTargetBuildItem out, byte[] schemaDocument, Format format) throws IOException {
        Path file;
        Path directory = (Path)openApiConfig.storeSchemaDirectory.get();
        Path outputDirectory = out.getOutputDirectory();
        if (!directory.isAbsolute() && outputDirectory != null) {
            directory = Paths.get(outputDirectory.getParent().toString(), directory.toString());
        }
        if (!Files.exists(directory, new LinkOption[0])) {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        if (!Files.exists(file = Paths.get(directory.toString(), "openapi." + format.toString().toLowerCase()), new LinkOption[0])) {
            Files.createFile(file, new FileAttribute[0]);
        }
        Files.write(file, schemaDocument, StandardOpenOption.WRITE);
        log.info((Object)("OpenAPI " + format.toString() + " saved: " + file.toString()));
    }

    private boolean shouldScanAnnotations(Capabilities capabilities, IndexView index) {
        Config config = ConfigProvider.getConfig();
        boolean scanDisable = config.getOptionalValue("mp.openapi.scan.disable", Boolean.class).orElse(false);
        if (scanDisable) {
            return false;
        }
        boolean isRestEasy = capabilities.isPresent(Capability.RESTEASY);
        boolean isQuarkusRest = capabilities.isPresent(Capability.RESTEASY_REACTIVE);
        boolean isSpring = capabilities.isPresent(Capability.SPRING_WEB);
        boolean isVertx = this.isUsingVertxRoute(index);
        return isRestEasy || isQuarkusRest || isSpring || isVertx;
    }

    private boolean isUsingVertxRoute(IndexView index) {
        return !index.getAnnotations(VertxConstants.ROUTE).isEmpty() || !index.getAnnotations(VertxConstants.ROUTE_BASE).isEmpty();
    }

    /*
     * Exception decompiling
     */
    private OpenAPI generateStaticModel(ApplicationArchivesBuildItem archivesBuildItem) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private OpenAPI generateAnnotationModel(IndexView indexView, Capabilities capabilities, HttpRootPathBuildItem httpRootPathBuildItem, Optional<ResteasyJaxrsConfigBuildItem> resteasyJaxrsConfig) {
        String defaultPath;
        Config config = ConfigProvider.getConfig();
        OpenApiConfigImpl openApiConfig = new OpenApiConfigImpl(config);
        ArrayList<Object> extensions = new ArrayList<Object>();
        if (capabilities.isPresent(Capability.RESTEASY)) {
            extensions.add(new RESTEasyExtension(indexView));
        }
        if ((defaultPath = resteasyJaxrsConfig.isPresent() ? resteasyJaxrsConfig.get().getRootPath() : httpRootPathBuildItem.getRootPath()) != null && !"/".equals(defaultPath)) {
            extensions.add(new CustomPathExtension(defaultPath));
        }
        OpenApiAnnotationScanner openApiAnnotationScanner = new OpenApiAnnotationScanner((OpenApiConfig)openApiConfig, indexView, extensions);
        return openApiAnnotationScanner.scan(this.getScanners(capabilities, indexView));
    }

    private String[] getScanners(Capabilities capabilities, IndexView index) {
        ArrayList<String> scanners = new ArrayList<String>();
        if (capabilities.isPresent(Capability.RESTEASY) || capabilities.isPresent(Capability.RESTEASY_REACTIVE)) {
            scanners.add(JAX_RS);
        }
        if (capabilities.isPresent(Capability.SPRING_WEB)) {
            scanners.add(SPRING);
        }
        if (this.isUsingVertxRoute(index)) {
            scanners.add(VERT_X);
        }
        return scanners.toArray(new String[0]);
    }

    private Result findStaticModel(ApplicationArchivesBuildItem archivesBuildItem) {
        Format format = Format.YAML;
        Path resourcePath = archivesBuildItem.getRootArchive().getChildPath(META_INF_OPENAPI_YAML);
        if (resourcePath == null) {
            resourcePath = archivesBuildItem.getRootArchive().getChildPath(WEB_INF_CLASSES_META_INF_OPENAPI_YAML);
        }
        if (resourcePath == null) {
            resourcePath = archivesBuildItem.getRootArchive().getChildPath(META_INF_OPENAPI_YML);
        }
        if (resourcePath == null) {
            resourcePath = archivesBuildItem.getRootArchive().getChildPath(WEB_INF_CLASSES_META_INF_OPENAPI_YML);
        }
        if (resourcePath == null) {
            resourcePath = archivesBuildItem.getRootArchive().getChildPath(META_INF_OPENAPI_JSON);
            format = Format.JSON;
        }
        if (resourcePath == null) {
            resourcePath = archivesBuildItem.getRootArchive().getChildPath(WEB_INF_CLASSES_META_INF_OPENAPI_JSON);
            format = Format.JSON;
        }
        if (resourcePath == null) {
            return null;
        }
        return new Result(format, resourcePath);
    }

    private OpenApiDocument loadDocument(OpenAPI staticModel, OpenAPI annotationModel, List<AddToOpenAPIDefinitionBuildItem> openAPIBuildItems) {
        OpenApiDocument document = this.prepareOpenApiDocument(staticModel, annotationModel, openAPIBuildItems);
        document.initialize();
        return document;
    }

    private void storeDocument(OutputTargetBuildItem out, SmallRyeOpenApiConfig smallRyeOpenApiConfig, OpenAPI staticModel, OpenAPI annotationModel, List<AddToOpenAPIDefinitionBuildItem> openAPIBuildItems) throws IOException {
        Config config = ConfigProvider.getConfig();
        OpenApiConfigImpl openApiConfig = new OpenApiConfigImpl(config);
        OpenApiDocument document = this.prepareOpenApiDocument(staticModel, annotationModel, openAPIBuildItems);
        document.filter(this.filter((OpenApiConfig)openApiConfig));
        document.initialize();
        for (Format format : Format.values()) {
            String name = "META-INF/quarkus-generated-openapi-doc." + format;
            byte[] schemaDocument = OpenApiSerializer.serialize((OpenAPI)document.get(), (Format)format).getBytes(StandardCharsets.UTF_8);
            this.storeGeneratedSchema(smallRyeOpenApiConfig, out, schemaDocument, format);
        }
    }

    private OpenApiDocument prepareOpenApiDocument(OpenAPI staticModel, OpenAPI annotationModel, List<AddToOpenAPIDefinitionBuildItem> openAPIBuildItems) {
        Config config = ConfigProvider.getConfig();
        OpenApiConfigImpl openApiConfig = new OpenApiConfigImpl(config);
        OpenAPI readerModel = OpenApiProcessor.modelFromReader((OpenApiConfig)openApiConfig, (ClassLoader)Thread.currentThread().getContextClassLoader());
        OpenApiDocument document = this.createDocument((OpenApiConfig)openApiConfig);
        if (annotationModel != null) {
            document.modelFromAnnotations(annotationModel);
        }
        document.modelFromReader(readerModel);
        document.modelFromStaticFile(staticModel);
        for (AddToOpenAPIDefinitionBuildItem openAPIBuildItem : openAPIBuildItems) {
            OASFilter otherExtensionFilter = openAPIBuildItem.getOASFilter();
            document.filter(otherExtensionFilter);
        }
        return document;
    }

    private OpenApiDocument createDocument(OpenApiConfig openApiConfig) {
        OpenApiDocument document = OpenApiDocument.INSTANCE;
        document.reset();
        document.config(openApiConfig);
        return document;
    }

    private OASFilter filter(OpenApiConfig openApiConfig) {
        return OpenApiProcessor.getFilter((OpenApiConfig)openApiConfig, (ClassLoader)Thread.currentThread().getContextClassLoader());
    }

    static {
        System.setProperty("mp.openapi.extensions.smallrye.defaultProduces", "application/json");
        System.setProperty("mp.openapi.extensions.smallrye.defaultConsumes", "application/json");
    }

    static class Result {
        final Format format;
        final Path path;

        Result(Format format, Path path) {
            this.format = format;
            this.path = path;
        }
    }
}

