/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.deployment;

import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.TransformedAnnotationsBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ConfigDescriptionBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.smallrye.reactivemessaging.deployment.ReactiveMessagingBuildTimeConfig;
import io.quarkus.smallrye.reactivemessaging.deployment.ReactiveMessagingDotNames;
import io.quarkus.smallrye.reactivemessaging.deployment.WiringHelper;
import io.quarkus.smallrye.reactivemessaging.deployment.items.ChannelBuildItem;
import io.quarkus.smallrye.reactivemessaging.deployment.items.ChannelDirection;
import io.quarkus.smallrye.reactivemessaging.deployment.items.ConnectorBuildItem;
import io.quarkus.smallrye.reactivemessaging.deployment.items.ConnectorManagedChannelBuildItem;
import io.quarkus.smallrye.reactivemessaging.deployment.items.InjectedChannelBuildItem;
import io.quarkus.smallrye.reactivemessaging.deployment.items.InjectedEmitterBuildItem;
import io.quarkus.smallrye.reactivemessaging.deployment.items.MediatorBuildItem;
import io.quarkus.smallrye.reactivemessaging.deployment.items.OrphanChannelBuildItem;
import io.smallrye.reactive.messaging.annotations.ConnectorAttribute;
import io.smallrye.reactive.messaging.providers.wiring.WiringException;
import jakarta.enterprise.inject.spi.DeploymentException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class WiringProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)"io.quarkus.smallrye-reactive-messaging.deployment.processor");

    @BuildStep
    void discoverConnectors(BeanDiscoveryFinishedBuildItem beans, CombinedIndexBuildItem index, BuildProducer<ConnectorBuildItem> builder) {
        beans.getBeans().stream().filter(bi -> bi.getQualifier(ReactiveMessagingDotNames.CONNECTOR).isPresent()).forEach(bi -> {
            if (WiringHelper.isInboundConnector(bi.getImplClazz())) {
                builder.produce((BuildItem)ConnectorBuildItem.createIncomingConnector(WiringHelper.getConnectorName(bi), WiringHelper.getConnectorAttributes(bi, index, ConnectorAttribute.Direction.INCOMING, ConnectorAttribute.Direction.INCOMING_AND_OUTGOING)));
            }
            if (WiringHelper.isOutboundConnector(bi.getImplClazz())) {
                builder.produce((BuildItem)ConnectorBuildItem.createOutgoingConnector(WiringHelper.getConnectorName(bi), WiringHelper.getConnectorAttributes(bi, index, ConnectorAttribute.Direction.OUTGOING, ConnectorAttribute.Direction.INCOMING_AND_OUTGOING)));
            }
        });
    }

    @BuildStep
    void extractComponents(BeanDiscoveryFinishedBuildItem beanDiscoveryFinished, TransformedAnnotationsBuildItem transformedAnnotations, BuildProducer<ChannelBuildItem> appChannels, BuildProducer<MediatorBuildItem> mediatorMethods, BuildProducer<InjectedEmitterBuildItem> emitters, BuildProducer<InjectedChannelBuildItem> channels, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors, BuildProducer<ConfigDescriptionBuildItem> configDescriptionBuildItemBuildProducer) {
        HashMap<String, AnnotationInstance> emitterFactories = new HashMap<String, AnnotationInstance>();
        for (BeanInfo bean : beanDiscoveryFinished.beanStream().classBeans()) {
            AnnotationInstance emitterFactory = transformedAnnotations.getAnnotation((AnnotationTarget)bean.getTarget().get(), ReactiveMessagingDotNames.EMITTER_FACTORY_FOR);
            if (emitterFactory != null) {
                emitterFactories.put(emitterFactory.value().asClass().name().toString(), emitterFactory);
            }
            for (MethodInfo method : ((AnnotationTarget)bean.getTarget().get()).asClass().methods()) {
                AnnotationInstance incoming = transformedAnnotations.getAnnotation((AnnotationTarget)method, ReactiveMessagingDotNames.INCOMING);
                AnnotationInstance incomings = transformedAnnotations.getAnnotation((AnnotationTarget)method, ReactiveMessagingDotNames.INCOMINGS);
                AnnotationInstance outgoing = transformedAnnotations.getAnnotation((AnnotationTarget)method, ReactiveMessagingDotNames.OUTGOING);
                AnnotationInstance blocking = transformedAnnotations.getAnnotation((AnnotationTarget)method, ReactiveMessagingDotNames.BLOCKING);
                if (incoming != null || incomings != null || outgoing != null) {
                    this.handleMethodAnnotatedWithIncoming(appChannels, validationErrors, configDescriptionBuildItemBuildProducer, method, incoming);
                    this.handleMethodAnnotationWithIncomings(appChannels, validationErrors, configDescriptionBuildItemBuildProducer, method, incomings);
                    this.handleMethodAnnotationWithOutgoing(appChannels, validationErrors, configDescriptionBuildItemBuildProducer, method, outgoing);
                    if (WiringHelper.isSynthetic(method)) continue;
                    mediatorMethods.produce((BuildItem)new MediatorBuildItem(bean, method));
                    LOGGER.debugf("Found mediator business method %s declared on %s", (Object)method, (Object)bean);
                    continue;
                }
                if (blocking == null) continue;
                validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new DeploymentException("@Blocking used on " + method + " which has no @Incoming or @Outgoing annotation")}));
            }
        }
        for (InjectionPointInfo injectionPoint : beanDiscoveryFinished.getInjectionPoints()) {
            Optional<AnnotationInstance> broadcast = WiringHelper.getAnnotation(transformedAnnotations, injectionPoint, ReactiveMessagingDotNames.BROADCAST);
            Optional<AnnotationInstance> channel = WiringHelper.getAnnotation(transformedAnnotations, injectionPoint, ReactiveMessagingDotNames.CHANNEL);
            Optional<AnnotationInstance> legacyChannel = WiringHelper.getAnnotation(transformedAnnotations, injectionPoint, ReactiveMessagingDotNames.LEGACY_CHANNEL);
            String injectionType = injectionPoint.getRequiredType().name().toString();
            AnnotationInstance emitterType = (AnnotationInstance)emitterFactories.get(injectionType);
            boolean isLegacyEmitter = injectionPoint.getRequiredType().name().equals((Object)ReactiveMessagingDotNames.LEGACY_EMITTER);
            if (emitterType != null) {
                if (isLegacyEmitter) {
                    this.handleEmitter(transformedAnnotations, appChannels, emitters, validationErrors, injectionPoint, emitterType, broadcast, legacyChannel, ReactiveMessagingDotNames.LEGACY_ON_OVERFLOW);
                    continue;
                }
                this.handleEmitter(transformedAnnotations, appChannels, emitters, validationErrors, injectionPoint, emitterType, broadcast, channel, ReactiveMessagingDotNames.ON_OVERFLOW);
                continue;
            }
            if (channel.isPresent()) {
                this.handleChannelInjection(appChannels, channels, channel.get());
            }
            if (!legacyChannel.isPresent()) continue;
            this.handleChannelInjection(appChannels, channels, legacyChannel.get());
        }
    }

    private void handleChannelInjection(BuildProducer<ChannelBuildItem> appChannels, BuildProducer<InjectedChannelBuildItem> channels, AnnotationInstance channel) {
        String name = channel.value().asString();
        if (name != null && !name.trim().isEmpty()) {
            WiringHelper.produceIncomingChannel(appChannels, name);
            channels.produce((BuildItem)InjectedChannelBuildItem.of(name));
        }
    }

    private void handleEmitter(TransformedAnnotationsBuildItem transformedAnnotations, BuildProducer<ChannelBuildItem> appChannels, BuildProducer<InjectedEmitterBuildItem> emitters, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors, InjectionPointInfo injectionPoint, AnnotationInstance emitterType, Optional<AnnotationInstance> broadcast, Optional<AnnotationInstance> annotation, DotName onOverflowAnnotation) {
        if (annotation.isEmpty()) {
            validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new DeploymentException("Invalid emitter injection - @Channel is required for " + injectionPoint.getTargetInfo())}));
        } else {
            String channelName = annotation.get().value().asString();
            Optional<AnnotationInstance> overflow = WiringHelper.getAnnotation(transformedAnnotations, injectionPoint, onOverflowAnnotation);
            this.createEmitter(appChannels, emitters, injectionPoint, channelName, emitterType, overflow, broadcast);
        }
    }

    private void handleMethodAnnotationWithOutgoing(BuildProducer<ChannelBuildItem> appChannels, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors, BuildProducer<ConfigDescriptionBuildItem> configDescriptionBuildItemBuildProducer, MethodInfo method, AnnotationInstance outgoing) {
        if (outgoing != null && outgoing.value().asString().isEmpty()) {
            validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new DeploymentException("Empty @Outgoing annotation on method " + method)}));
        }
        if (outgoing != null) {
            configDescriptionBuildItemBuildProducer.produce((BuildItem)new ConfigDescriptionBuildItem("mp.messaging.outgoing." + outgoing.value().asString() + ".connector", null, "The connector to use", null, null, ConfigPhase.BUILD_TIME));
            WiringHelper.produceOutgoingChannel(appChannels, outgoing.value().asString());
        }
    }

    private void handleMethodAnnotationWithIncomings(BuildProducer<ChannelBuildItem> appChannels, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors, BuildProducer<ConfigDescriptionBuildItem> configDescriptionBuildItemBuildProducer, MethodInfo method, AnnotationInstance incomings) {
        if (incomings != null) {
            for (AnnotationInstance instance : incomings.value().asNestedArray()) {
                if (instance.value().asString().isEmpty()) {
                    validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new DeploymentException("Empty @Incoming annotation on method " + method)}));
                }
                configDescriptionBuildItemBuildProducer.produce((BuildItem)new ConfigDescriptionBuildItem("mp.messaging.incoming." + instance.value().asString() + ".connector", null, "The connector to use", null, null, ConfigPhase.BUILD_TIME));
                WiringHelper.produceIncomingChannel(appChannels, instance.value().asString());
            }
        }
    }

    private void handleMethodAnnotatedWithIncoming(BuildProducer<ChannelBuildItem> appChannels, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors, BuildProducer<ConfigDescriptionBuildItem> configDescriptionBuildItemBuildProducer, MethodInfo method, AnnotationInstance incoming) {
        if (incoming != null && incoming.value().asString().isEmpty()) {
            validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new DeploymentException("Empty @Incoming annotation on method " + method)}));
        }
        if (incoming != null) {
            configDescriptionBuildItemBuildProducer.produce((BuildItem)new ConfigDescriptionBuildItem("mp.messaging.incoming." + incoming.value().asString() + ".connector", null, "The connector to use", null, null, ConfigPhase.BUILD_TIME));
            WiringHelper.produceIncomingChannel(appChannels, incoming.value().asString());
        }
    }

    @BuildStep
    public void detectOrphanChannels(List<ChannelBuildItem> channels, BuildProducer<OrphanChannelBuildItem> builder) {
        HashMap<String, ChannelBuildItem> inc = new HashMap<String, ChannelBuildItem>();
        HashMap<String, ChannelBuildItem> out = new HashMap<String, ChannelBuildItem>();
        for (ChannelBuildItem channel : channels) {
            if (channel.getDirection() == ChannelDirection.INCOMING) {
                inc.put(channel.getName(), channel);
                continue;
            }
            out.put(channel.getName(), channel);
        }
        HashSet orphanInboundChannels = new HashSet(inc.keySet());
        HashSet orphanOutboundChannels = new HashSet(out.keySet());
        orphanInboundChannels.removeAll(out.keySet());
        orphanOutboundChannels.removeAll(inc.keySet());
        for (String channel : orphanInboundChannels) {
            if (((ChannelBuildItem)((Object)inc.get(channel))).isManagedByAConnector()) continue;
            builder.produce((BuildItem)OrphanChannelBuildItem.of(ChannelDirection.INCOMING, channel));
        }
        for (String channel : orphanOutboundChannels) {
            if (((ChannelBuildItem)((Object)out.get(channel))).isManagedByAConnector()) continue;
            builder.produce((BuildItem)OrphanChannelBuildItem.of(ChannelDirection.OUTGOING, channel));
        }
    }

    @BuildStep
    void generateDocumentationItem(BuildProducer<ConfigDescriptionBuildItem> config, List<ConnectorManagedChannelBuildItem> channels, List<ConnectorBuildItem> connectors) {
        Parser markdownParser = Parser.builder().build();
        HtmlRenderer renderer = HtmlRenderer.builder().build();
        for (ConnectorManagedChannelBuildItem channel : channels) {
            ConnectorBuildItem connector = WiringHelper.find(connectors, channel.getConnector(), channel.getDirection());
            String prefix = "mp.messaging." + (channel.getDirection() == ChannelDirection.INCOMING ? "incoming" : "outgoing") + "." + channel.getName() + ".";
            if (connector == null) continue;
            for (ConnectorAttribute attribute : connector.getAttributes()) {
                ConfigDescriptionBuildItem cfg = new ConfigDescriptionBuildItem(prefix + attribute.name(), attribute.defaultValue().equalsIgnoreCase("<no-value>") ? null : attribute.defaultValue(), renderer.render(markdownParser.parse(attribute.description())), attribute.type(), Collections.emptyList(), ConfigPhase.RUN_TIME);
                config.produce((BuildItem)cfg);
            }
        }
    }

    @BuildStep
    public void autoConfigureConnectorForOrphansAndProduceManagedChannels(ReactiveMessagingBuildTimeConfig buildTimeConfig, BuildProducer<RunTimeConfigurationDefaultBuildItem> config, BuildProducer<ConnectorManagedChannelBuildItem> connectorManagedChannels, List<OrphanChannelBuildItem> orphans, List<ConnectorBuildItem> connectors, List<ChannelBuildItem> channels, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors) {
        String connector;
        HashSet<String> incomingConnectors = new HashSet<String>();
        HashSet<String> outgoingConnectors = new HashSet<String>();
        for (Object connector2 : connectors) {
            if (connector2.getDirection() == ChannelDirection.INCOMING) {
                incomingConnectors.add(connector2.getName());
                continue;
            }
            outgoingConnectors.add(connector2.getName());
        }
        if (incomingConnectors.size() == 1 && buildTimeConfig.autoConnectorAttachment) {
            connector = (String)incomingConnectors.iterator().next();
            for (OrphanChannelBuildItem orphan : orphans) {
                if (orphan.getDirection() != ChannelDirection.INCOMING) continue;
                config.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("mp.messaging.incoming." + orphan.getName() + ".connector", connector));
                LOGGER.infof("Configuring the channel '%s' to be managed by the connector '%s'", (Object)orphan.getName(), (Object)connector);
                connectorManagedChannels.produce((BuildItem)new ConnectorManagedChannelBuildItem(orphan.getName(), ChannelDirection.INCOMING, connector));
            }
        }
        if (outgoingConnectors.size() == 1 && buildTimeConfig.autoConnectorAttachment) {
            connector = (String)outgoingConnectors.iterator().next();
            for (OrphanChannelBuildItem orphan : orphans) {
                if (orphan.getDirection() != ChannelDirection.OUTGOING) continue;
                config.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("mp.messaging.outgoing." + orphan.getName() + ".connector", connector));
                LOGGER.infof("Configuring the channel '%s' to be managed by the connector '%s'", (Object)orphan.getName(), (Object)connector);
                connectorManagedChannels.produce((BuildItem)new ConnectorManagedChannelBuildItem(orphan.getName(), ChannelDirection.OUTGOING, connector));
            }
        }
        for (ChannelBuildItem channel : channels) {
            if (!channel.isManagedByAConnector()) continue;
            if (!WiringHelper.hasConnector(connectors, channel.getDirection(), channel.getConnector())) {
                errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new WiringException("The channel '" + channel.getName() + "' is configured with an unknown connector (" + channel.getConnector() + ")")}));
                continue;
            }
            connectorManagedChannels.produce((BuildItem)new ConnectorManagedChannelBuildItem(channel.getName(), channel.getDirection(), channel.getConnector()));
        }
    }

    private void createEmitter(BuildProducer<ChannelBuildItem> appChannels, BuildProducer<InjectedEmitterBuildItem> emitters, InjectionPointInfo injectionPoint, String channelName, AnnotationInstance emitter, Optional<AnnotationInstance> overflow, Optional<AnnotationInstance> broadcast) {
        LOGGER.debugf("Emitter injection point '%s' detected, channel name: '%s'", (Object)injectionPoint.getTargetInfo(), (Object)channelName);
        String emitterTypeName = emitter.value().asClass().name().toString();
        boolean hasBroadcast = false;
        int awaitSubscribers = -1;
        int bufferSize = -1;
        String strategy = null;
        if (broadcast.isPresent()) {
            hasBroadcast = true;
            AnnotationValue value = broadcast.get().value();
            int n = awaitSubscribers = value == null ? 0 : value.asInt();
        }
        if (overflow.isPresent()) {
            AnnotationInstance annotation = overflow.get();
            AnnotationValue maybeBufferSize = annotation.value("bufferSize");
            bufferSize = maybeBufferSize == null ? 0 : maybeBufferSize.asInt();
            strategy = annotation.value().asString();
        }
        WiringHelper.produceOutgoingChannel(appChannels, channelName);
        emitters.produce((BuildItem)InjectedEmitterBuildItem.of(channelName, emitterTypeName, strategy, bufferSize, hasBroadcast, awaitSubscribers));
    }
}

