/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.kafka;

import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import org.apache.kafka.common.TopicPartition;

@Embeddable
public class CheckpointEntityId
implements Serializable {
    private static final long serialVersionUID = -259817999246156947L;
    @Column(name="consumer_group_id", insertable=false)
    private String consumerGroupId;
    private String topic;
    private int partition;

    public CheckpointEntityId() {
    }

    public CheckpointEntityId(String consumerGroupId, TopicPartition topicPartition) {
        this.consumerGroupId = consumerGroupId;
        this.topic = topicPartition.topic();
        this.partition = topicPartition.partition();
    }

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public void setConsumerGroupId(String consumerGroupId) {
        this.consumerGroupId = consumerGroupId;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public int getPartition() {
        return this.partition;
    }

    public void setPartition(int partition) {
        this.partition = partition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CheckpointEntityId)) {
            return false;
        }
        CheckpointEntityId that = (CheckpointEntityId)o;
        return this.partition == that.getPartition() && Objects.equals(this.consumerGroupId, that.getConsumerGroupId()) && Objects.equals(this.topic, that.getTopic());
    }

    public int hashCode() {
        return Objects.hash(this.consumerGroupId, this.topic, this.partition);
    }

    public String toString() {
        return this.consumerGroupId + ":" + this.topic + ":" + this.partition;
    }
}

