/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.stork;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.stork.QuarkusStorkInfrastructure;
import io.quarkus.stork.StorkConfigProvider;
import io.quarkus.stork.StorkConfigUtil;
import io.quarkus.stork.StorkConfiguration;
import io.smallrye.stork.Stork;
import io.smallrye.stork.api.config.ServiceConfig;
import io.smallrye.stork.spi.StorkInfrastructure;
import io.vertx.core.Vertx;
import java.util.List;

@Recorder
public class SmallRyeStorkRecorder {
    public void initialize(ShutdownContext shutdown, RuntimeValue<Vertx> vertx, StorkConfiguration configuration) {
        List<ServiceConfig> serviceConfigs = StorkConfigUtil.toStorkServiceConfig(configuration);
        StorkConfigProvider.init(serviceConfigs);
        Stork.initialize((StorkInfrastructure)new QuarkusStorkInfrastructure((Vertx)vertx.getValue()));
        shutdown.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                Stork.shutdown();
            }
        });
    }
}

