/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;

public class PropertyTestUtil {
    private static final String LOG_FILE_PATH_PROPERTY = "quarkus.log.file.path";

    public static void setLogFileProperty() {
        System.setProperty(LOG_FILE_PATH_PROPERTY, PropertyTestUtil.getLogFileLocation());
    }

    public static void setLogFileProperty(String logFileName) {
        System.setProperty(LOG_FILE_PATH_PROPERTY, PropertyTestUtil.getLogFileLocation(logFileName));
    }

    public static String getLogFileLocation() {
        return PropertyTestUtil.getLogFileLocation(System.getProperty(LOG_FILE_PATH_PROPERTY, "quarkus.log"));
    }

    private static String getLogFileLocation(String logFileName) {
        if (Files.isDirectory(Paths.get("build", new String[0]), new LinkOption[0])) {
            return "build" + File.separator + logFileName;
        }
        return "target" + File.separator + logFileName;
    }
}

