/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.runtime.configuration.QuarkusConfigFactory;
import io.quarkus.test.common.NativeImageStartedNotifier;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import io.smallrye.config.SmallRyeConfig;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.ServiceLoader;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.wildfly.common.lock.Locks;

public class NativeImageLauncher
implements Closeable {
    private static final int DEFAULT_PORT = 8081;
    private static final int DEFAULT_HTTPS_PORT = 8444;
    private static final long DEFAULT_IMAGE_WAIT_TIME = 60L;
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows");
    private final Class<?> testClass;
    private final String profile;
    private Process quarkusProcess;
    private int port;
    private final int httpsPort;
    private final long imageWaitTime;
    private final Map<String, String> systemProps = new HashMap<String, String>();
    private List<NativeImageStartedNotifier> startedNotifiers;

    private NativeImageLauncher(Class<?> testClass, Config config) {
        this(testClass, ((OptionalInt)config.getValue("quarkus.http.test-port", OptionalInt.class)).orElse(8081), ((OptionalInt)config.getValue("quarkus.http.test-ssl-port", OptionalInt.class)).orElse(8444), ((OptionalLong)config.getValue("quarkus.test.native-image-wait-time", OptionalLong.class)).orElse(60L), config.getOptionalValue("quarkus.test.native-image-profile", String.class).orElse(null));
    }

    public NativeImageLauncher(Class<?> testClass) {
        this(testClass, NativeImageLauncher.installAndGetSomeConfig());
    }

    private static Config installAndGetSomeConfig() {
        SmallRyeConfig config = ConfigUtils.configBuilder((boolean)false).build();
        QuarkusConfigFactory.setConfig((SmallRyeConfig)config);
        ConfigProviderResolver cpr = ConfigProviderResolver.instance();
        try {
            Config installed = cpr.getConfig();
            if (installed != config) {
                cpr.releaseConfig(installed);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return config;
    }

    public NativeImageLauncher(Class<?> testClass, int port, int httpsPort, long imageWaitTime, String profile) {
        this.testClass = testClass;
        this.port = port;
        this.httpsPort = httpsPort;
        this.imageWaitTime = imageWaitTime;
        ArrayList<NativeImageStartedNotifier> startedNotifiers = new ArrayList<NativeImageStartedNotifier>();
        for (NativeImageStartedNotifier i : ServiceLoader.load(NativeImageStartedNotifier.class)) {
            startedNotifiers.add(i);
        }
        this.startedNotifiers = startedNotifiers;
        this.profile = profile;
    }

    public void start() throws IOException {
        System.setProperty("test.url", TestHTTPResourceManager.getUri());
        String path = System.getProperty("native.image.path");
        if (path == null) {
            path = NativeImageLauncher.guessPath(this.testClass);
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(path);
        args.add("-Dquarkus.http.port=" + this.port);
        args.add("-Dquarkus.http.ssl-port=" + this.httpsPort);
        args.add("-Dtest.url=" + TestHTTPResourceManager.getUri());
        args.add("-Dquarkus.log.file.path=" + PropertyTestUtil.getLogFileLocation());
        if (this.profile != null) {
            args.add("-Dquarkus.profile=" + this.profile);
        }
        for (Map.Entry<String, String> e : this.systemProps.entrySet()) {
            args.add("-D" + e.getKey() + "=" + e.getValue());
        }
        System.out.println("Executing " + args);
        this.quarkusProcess = Runtime.getRuntime().exec(args.toArray(new String[args.size()]));
        ProcessReader portCapturingProcessReader = null;
        if (this.port == 0) {
            portCapturingProcessReader = new PortCapturingProcessReader(this.quarkusProcess.getInputStream());
        }
        new Thread(portCapturingProcessReader != null ? portCapturingProcessReader : new ProcessReader(this.quarkusProcess.getInputStream())).start();
        new Thread(new ProcessReader(this.quarkusProcess.getErrorStream())).start();
        if (portCapturingProcessReader != null) {
            try {
                ((PortCapturingProcessReader)portCapturingProcessReader).awaitForPort();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (((PortCapturingProcessReader)portCapturingProcessReader).port == null) {
                this.quarkusProcess.destroy();
                throw new RuntimeException("Unable to determine actual running port as dynamic port was used");
            }
            this.waitForQuarkus(((PortCapturingProcessReader)portCapturingProcessReader).port);
            System.setProperty("quarkus.http.port", ((PortCapturingProcessReader)portCapturingProcessReader).port.toString());
            System.setProperty("quarkus.http.test-port", ((PortCapturingProcessReader)portCapturingProcessReader).port.toString());
            this.port = ((PortCapturingProcessReader)portCapturingProcessReader).port;
            NativeImageLauncher.installAndGetSomeConfig();
            System.setProperty("test.url", TestHTTPResourceManager.getUri());
        } else {
            this.waitForQuarkus(this.port);
        }
    }

    private static String guessPath(Class<?> testClass) {
        ClassLoader cl = testClass.getClassLoader();
        if (cl instanceof URLClassLoader) {
            URL[] urls;
            for (URL url : urls = ((URLClassLoader)cl).getURLs()) {
                String applicationNativeImagePath = NativeImageLauncher.guessPath(url);
                if (applicationNativeImagePath == null) continue;
                return applicationNativeImagePath;
            }
        } else {
            URL codeSourceLocation;
            String applicationNativeImagePath;
            CodeSource codeSource = testClass.getProtectionDomain().getCodeSource();
            if (codeSource != null && (applicationNativeImagePath = NativeImageLauncher.guessPath(codeSourceLocation = codeSource.getLocation())) != null) {
                return applicationNativeImagePath;
            }
        }
        throw new RuntimeException("Unable to automatically find native image, please set the native.image.path to the native executable you wish to test");
    }

    private static String guessPath(URL url) {
        block5: {
            block6: {
                block4: {
                    if (url == null) {
                        return null;
                    }
                    if (!url.getProtocol().equals("file") || !url.getPath().endsWith("test-classes/")) break block4;
                    File testClasses = new File(url.getPath());
                    for (File file : testClasses.getParentFile().listFiles()) {
                        if (!NativeImageLauncher.isNativeExecutable(file)) continue;
                        NativeImageLauncher.logGuessedPath(file.getAbsolutePath());
                        return file.getAbsolutePath();
                    }
                    break block5;
                }
                if (!url.getProtocol().equals("file") || !url.getPath().endsWith("test/")) break block6;
                File testClasses = new File(url.getPath());
                for (File file : testClasses.getParentFile().getParentFile().getParentFile().listFiles()) {
                    if (!NativeImageLauncher.isNativeExecutable(file)) continue;
                    NativeImageLauncher.logGuessedPath(file.getAbsolutePath());
                    return file.getAbsolutePath();
                }
                break block5;
            }
            if (!url.getProtocol().equals("file") || !url.getPath().contains("/target/surefire/")) break block5;
            String path = url.getPath();
            int index = path.lastIndexOf("/target/");
            File targetDir = new File(path.substring(0, index) + "/target/");
            for (File file : targetDir.listFiles()) {
                if (!NativeImageLauncher.isNativeExecutable(file)) continue;
                NativeImageLauncher.logGuessedPath(file.getAbsolutePath());
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    private static boolean isNativeExecutable(File file) {
        if (IS_WINDOWS) {
            return file.getName().endsWith("-runner.exe");
        }
        return file.getName().endsWith("-runner");
    }

    private static void logGuessedPath(String guessedPath) {
        System.err.println("======================================================================================");
        System.err.println("  native.image.path was not set, making a guess for the correct path of native image");
        System.err.println("  guessed path: " + guessedPath);
        System.err.println("======================================================================================");
    }

    private void waitForQuarkus(int port) {
        long bailout = System.currentTimeMillis() + this.imageWaitTime * 1000L;
        while (System.currentTimeMillis() < bailout) {
            if (!this.quarkusProcess.isAlive()) {
                throw new RuntimeException("Failed to start native image, process has exited");
            }
            try {
                Throwable throwable;
                Thread.sleep(100L);
                for (NativeImageStartedNotifier i : this.startedNotifiers) {
                    if (!i.isNativeImageStarted()) continue;
                    return;
                }
                try {
                    throwable = null;
                    try (Socket s = new Socket();){
                        s.connect(new InetSocketAddress("localhost", port));
                        Thread.sleep(100L);
                        return;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Exception s) {
                    throwable = null;
                    try (Socket s2 = new Socket();){
                        s2.connect(new InetSocketAddress("localhost", this.httpsPort));
                        return;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
            }
            catch (Exception exception) {
            }
        }
        this.quarkusProcess.destroyForcibly();
        throw new RuntimeException("Unable to start native image in " + this.imageWaitTime + "s");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDefaultSsl() {
        try (Socket s = new Socket();){
            s.connect(new InetSocketAddress("localhost", this.port));
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            return true;
        }
    }

    public void addSystemProperties(Map<String, String> systemProps) {
        this.systemProps.putAll(systemProps);
    }

    @Override
    public void close() {
        this.quarkusProcess.destroy();
    }

    private static final class PortCapturingProcessReader
    extends ProcessReader {
        private Integer port;
        private boolean portDetermined = false;
        private StringBuilder sb = new StringBuilder();
        private final Lock lock = Locks.reentrantLock();
        private final Condition portDeterminedCondition = this.lock.newCondition();
        private final Pattern portRegex = Pattern.compile("Listening on:\\s+https?://.*:(\\d+)");

        private PortCapturingProcessReader(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        protected void handleStart() {
            this.lock.lock();
        }

        @Override
        protected void handleString(String str) {
            if (this.portDetermined) {
                return;
            }
            this.sb.append(str);
            String currentOutput = this.sb.toString();
            Matcher regexMatcher = this.portRegex.matcher(currentOutput);
            if (!regexMatcher.find()) {
                if (currentOutput.contains("Exception")) {
                    this.portDetermined(null);
                }
                return;
            }
            this.portDetermined(Integer.valueOf(regexMatcher.group(1)));
        }

        private void portDetermined(Integer portValue) {
            this.port = portValue;
            try {
                this.portDetermined = true;
                this.sb = null;
                this.portDeterminedCondition.signal();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        protected void handleError(IOException e) {
            if (!this.portDetermined) {
                this.portDetermined(null);
            }
        }

        public void awaitForPort() throws InterruptedException {
            this.lock.lock();
            try {
                while (!this.portDetermined) {
                    this.portDeterminedCondition.await();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private static class ProcessReader
    implements Runnable {
        private final InputStream inputStream;

        private ProcessReader(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public void run() {
            this.handleStart();
            byte[] b = new byte[100];
            try {
                int i;
                while ((i = this.inputStream.read(b)) > 0) {
                    String str = new String(b, 0, i, StandardCharsets.UTF_8);
                    System.out.print(str);
                    this.handleString(str);
                }
            }
            catch (IOException e) {
                this.handleError(e);
            }
        }

        protected void handleStart() {
        }

        protected void handleString(String str) {
        }

        protected void handleError(IOException e) {
        }
    }
}

