/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.test.common.IntegrationTestStartedNotifier;
import io.quarkus.test.common.JarArtifactLauncher;
import io.quarkus.test.common.LauncherUtil;
import io.quarkus.test.common.ListeningAddress;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class DefaultJarLauncher
implements JarArtifactLauncher {
    private int httpPort;
    private int httpsPort;
    private long waitTimeSeconds;
    private String testProfile;
    private List<String> argLine;
    private Path jarPath;
    private final Map<String, String> systemProps = new HashMap<String, String>();
    private Process quarkusProcess;
    private boolean isSsl;

    @Override
    public void init(JarArtifactLauncher.JarInitContext initContext) {
        this.httpPort = initContext.httpPort();
        this.httpsPort = initContext.httpsPort();
        this.waitTimeSeconds = initContext.waitTime().getSeconds();
        this.testProfile = initContext.testProfile();
        this.argLine = initContext.argLine();
        this.jarPath = initContext.jarPath();
    }

    @Override
    public void start() throws IOException {
        Object result;
        System.setProperty("test.url", TestHTTPResourceManager.getUri());
        ArrayList<String> args = new ArrayList<String>();
        args.add("java");
        if (!this.argLine.isEmpty()) {
            args.addAll(this.argLine);
        }
        args.add("-Dquarkus.http.port=" + this.httpPort);
        args.add("-Dquarkus.http.ssl-port=" + this.httpsPort);
        args.add("-Dtest.url=" + TestHTTPResourceManager.getUri());
        Path logFile = PropertyTestUtil.getLogFilePath();
        args.add("-Dquarkus.log.file.path=" + logFile.toAbsolutePath().toString());
        args.add("-Dquarkus.log.file.enable=true");
        if (this.testProfile != null) {
            args.add("-Dquarkus.profile=" + this.testProfile);
        }
        for (Map.Entry<String, String> e : this.systemProps.entrySet()) {
            args.add("-D" + e.getKey() + "=" + e.getValue());
        }
        args.add("-jar");
        args.add(this.jarPath.toAbsolutePath().toString());
        System.out.println("Executing " + args);
        Files.deleteIfExists(logFile);
        Files.createDirectories(logFile.getParent(), new FileAttribute[0]);
        Function<IntegrationTestStartedNotifier.Context, IntegrationTestStartedNotifier.Result> startedFunction = LauncherUtil.createStartedFunction();
        this.quarkusProcess = LauncherUtil.launchProcess(args);
        if (startedFunction != null) {
            result = LauncherUtil.waitForStartedFunction(startedFunction, this.quarkusProcess, this.waitTimeSeconds, logFile);
            this.isSsl = result.isSsl();
        } else {
            result = LauncherUtil.waitForCapturedListeningData(this.quarkusProcess, logFile, this.waitTimeSeconds);
            LauncherUtil.updateConfigForPort(((ListeningAddress)result).getPort());
            this.isSsl = ((ListeningAddress)result).isSsl();
        }
    }

    @Override
    public boolean listensOnSsl() {
        return this.isSsl;
    }

    @Override
    public void includeAsSysProps(Map<String, String> systemProps) {
        this.systemProps.putAll(systemProps);
    }

    @Override
    public void close() {
        this.quarkusProcess.destroy();
    }
}

