/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.runtime;

import io.quarkus.security.credential.PasswordCredential;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.UsernamePasswordAuthenticationRequest;
import io.quarkus.undertow.runtime.QuarkusUndertowAccount;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.jboss.logging.Logger;

@Singleton
public class QuarkusIdentityManager
implements IdentityManager {
    @Inject
    Logger log;
    @Inject
    IdentityProviderManager ipm;

    public Account verify(Account account) {
        this.log.debugf("verify1: %s", (Object)account.getPrincipal().getName());
        return account;
    }

    public Account verify(String id, Credential credential) {
        this.log.debugf("verify2: %s - %s", (Object)id, credential.getClass());
        if (credential instanceof io.undertow.security.idm.PasswordCredential) {
            io.undertow.security.idm.PasswordCredential password = (io.undertow.security.idm.PasswordCredential)io.undertow.security.idm.PasswordCredential.class.cast(credential);
            UsernamePasswordAuthenticationRequest upar = new UsernamePasswordAuthenticationRequest(id, new PasswordCredential(password.getPassword()));
            return new QuarkusUndertowAccount(this.ipm.authenticateBlocking((AuthenticationRequest)upar));
        }
        return null;
    }

    public Account verify(Credential credential) {
        this.log.debugf("verify3: %s", credential.getClass());
        return null;
    }
}

