/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.runtime;

import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.smallrye.mutiny.Uni;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.SingleConstraintMatch;
import io.undertow.servlet.handlers.security.SecurityPathMatch;
import io.vertx.ext.web.RoutingContext;
import jakarta.inject.Singleton;
import java.util.function.Function;

@Singleton
public class ServletHttpSecurityPolicy
implements HttpSecurityPolicy {
    private volatile Deployment deployment;
    private volatile String contextPath;

    public Uni<HttpSecurityPolicy.CheckResult> checkPermission(RoutingContext request, Uni<SecurityIdentity> identity, HttpSecurityPolicy.AuthorizationRequestContext requestContext) {
        SecurityPathMatch match;
        SingleConstraintMatch mergedConstraint;
        String requestPath = request.normalizedPath();
        if (!requestPath.startsWith(this.contextPath)) {
            return Uni.createFrom().item((Object)HttpSecurityPolicy.CheckResult.PERMIT);
        }
        if (!this.contextPath.equals("/")) {
            requestPath = requestPath.substring(this.contextPath.length() - 1);
        }
        if ((mergedConstraint = (match = this.deployment.getSecurityPathMatches().getSecurityInfo(requestPath, request.request().method().name())).getMergedConstraint()).getRequiredRoles().isEmpty()) {
            SecurityInfo.EmptyRoleSemantic emptyRoleSemantic = mergedConstraint.getEmptyRoleSemantic();
            if (emptyRoleSemantic == SecurityInfo.EmptyRoleSemantic.PERMIT) {
                return Uni.createFrom().item((Object)HttpSecurityPolicy.CheckResult.PERMIT);
            }
            if (emptyRoleSemantic == SecurityInfo.EmptyRoleSemantic.DENY) {
                return Uni.createFrom().item((Object)HttpSecurityPolicy.CheckResult.DENY);
            }
            if (emptyRoleSemantic == SecurityInfo.EmptyRoleSemantic.AUTHENTICATE) {
                return identity.map((Function)new Function<SecurityIdentity, HttpSecurityPolicy.CheckResult>(){

                    @Override
                    public HttpSecurityPolicy.CheckResult apply(SecurityIdentity securityIdentity) {
                        if (securityIdentity.isAnonymous()) {
                            return HttpSecurityPolicy.CheckResult.DENY;
                        }
                        return HttpSecurityPolicy.CheckResult.PERMIT;
                    }
                });
            }
            return Uni.createFrom().failure((Throwable)new RuntimeException("Unknown empty role semantic " + emptyRoleSemantic));
        }
        return identity.map((Function)new Function<SecurityIdentity, HttpSecurityPolicy.CheckResult>(){

            @Override
            public HttpSecurityPolicy.CheckResult apply(SecurityIdentity securityIdentity) {
                for (String i : mergedConstraint.getRequiredRoles()) {
                    if (!securityIdentity.hasRole(i)) continue;
                    return HttpSecurityPolicy.CheckResult.PERMIT;
                }
                return HttpSecurityPolicy.CheckResult.DENY;
            }
        });
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    public ServletHttpSecurityPolicy setDeployment(Deployment deployment) {
        this.deployment = deployment;
        this.contextPath = deployment.getDeploymentInfo().getContextPath();
        if (!this.contextPath.endsWith("/")) {
            this.contextPath = this.contextPath + "/";
        }
        return this;
    }
}

