/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.config;

import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.devui.runtime.comms.JsonRpcMessage;
import io.quarkus.devui.runtime.comms.MessageType;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.context.ApplicationScoped;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

@ApplicationScoped
public class ConfigJsonRPCService {
    private static final Logger LOG = Logger.getLogger((String)ConfigJsonRPCService.class.getName());

    public JsonRpcMessage<Boolean> updateProperty(String name, String value) {
        DevConsoleManager.invoke((String)"config-update-property", Map.of("name", name, "value", value));
        return new JsonRpcMessage<Boolean>(true, MessageType.HotReload);
    }

    public boolean updateProperties(String content, String type) {
        if (type.equalsIgnoreCase("properties")) {
            Properties p = new Properties();
            StringReader sr = new StringReader(content);
            try {
                p.load(sr);
                Map<String, String> m = Map.of("content", content, "type", type);
                DevConsoleManager.invoke((String)"config-set-properties", m);
                boolean bl = true;
                sr.close();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        sr.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    LOG.error((Object)"Could not update properties", (Throwable)ex);
                    return false;
                }
            }
        }
        return false;
    }

    public JsonObject getAllValues() {
        JsonObject values = new JsonObject();
        Config config = ConfigProvider.getConfig();
        for (String name : config.getPropertyNames()) {
            values.put(name, (Object)config.getConfigValue(name).getValue());
        }
        return values;
    }

    public JsonObject getProjectProperties() {
        JsonObject response = new JsonObject();
        try {
            List resourcesDir = DevConsoleManager.getHotReplacementContext().getResourcesDir();
            if (resourcesDir.isEmpty()) {
                response.put("error", (Object)"Unable to manage configurations - no resource directory found");
            } else {
                Path path = (Path)resourcesDir.get(0);
                Path configPropertiesPath = path.resolve("application.properties");
                if (Files.exists(configPropertiesPath, new LinkOption[0])) {
                    response.put("type", (Object)"properties");
                    String value = new String(Files.readAllBytes(configPropertiesPath));
                    response.put("value", (Object)value);
                } else {
                    response.put("type", (Object)"properties");
                    response.put("value", (Object)"");
                }
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return response;
    }

    private Map<String, String> toMap(Properties prop) {
        return prop.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue()), (prev, next) -> next, HashMap::new));
    }
}

