/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.webjar;

import io.quarkus.builder.Version;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.runtime.ApplicationConfig;
import io.quarkus.vertx.http.deployment.webjar.WebJarResourcesFilter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InsertVariablesResourcesFilter
implements WebJarResourcesFilter {
    private static final String CSS = ".css";
    private final ApplicationConfig applicationConfig;
    private final ResolvedDependency appArtifact;

    public InsertVariablesResourcesFilter(ApplicationConfig applicationConfig, ResolvedDependency appArtifact) {
        this.applicationConfig = applicationConfig;
        this.appArtifact = appArtifact;
    }

    @Override
    public WebJarResourcesFilter.FilterResult apply(String fileName, InputStream stream) throws IOException {
        if (stream == null) {
            return new WebJarResourcesFilter.FilterResult(null, false);
        }
        if (fileName.endsWith(CSS)) {
            boolean changed;
            String applicationName = this.applicationConfig.name.orElse(this.appArtifact.getArtifactId());
            String applicationVersion = this.applicationConfig.version.orElse(this.appArtifact.getVersion());
            byte[] oldContentBytes = stream.readAllBytes();
            String oldContents = new String(oldContentBytes);
            String contents = InsertVariablesResourcesFilter.replaceHeaderVars(oldContents, applicationName, applicationVersion);
            String header = InsertVariablesResourcesFilter.replaceHeaderVars(this.applicationConfig.uiHeader.orElse(""), applicationName, applicationVersion);
            boolean bl = changed = (contents = contents.replace("{applicationHeader}", header)).length() != oldContents.length() || !contents.equals(oldContents);
            if (changed) {
                return new WebJarResourcesFilter.FilterResult(new ByteArrayInputStream(contents.getBytes()), true);
            }
            return new WebJarResourcesFilter.FilterResult(new ByteArrayInputStream(oldContentBytes), false);
        }
        return new WebJarResourcesFilter.FilterResult(stream, false);
    }

    private static String replaceHeaderVars(String contents, String applicationName, String applicationVersion) {
        contents = contents.replace("{applicationName}", applicationName);
        contents = contents.replace("{applicationVersion}", applicationVersion);
        contents = contents.replace("{quarkusVersion}", Version.getVersion());
        return contents;
    }
}

