/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devconsole.spi;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.recording.BytecodeRecorderImpl;
import io.quarkus.deployment.util.ArtifactInfoUtil;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.AbstractMap;
import java.util.Map;

public final class DevConsoleRouteBuildItem
extends MultiBuildItem {
    private final String groupId;
    private final String artifactId;
    private final String path;
    private final String method;
    private final Class<?> callerClass;
    private final Handler<RoutingContext> handler;
    private final boolean isBodyHandlerRequired;

    public DevConsoleRouteBuildItem(String groupId, String artifactId, String path, String method, Handler<RoutingContext> handler) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.path = path;
        this.method = method;
        this.handler = handler;
        this.callerClass = null;
        this.isBodyHandlerRequired = false;
    }

    public DevConsoleRouteBuildItem(String path, String method, Handler<RoutingContext> handler) {
        String callerClassName = new RuntimeException().getStackTrace()[1].getClassName();
        try {
            this.callerClass = Thread.currentThread().getContextClassLoader().loadClass(callerClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.groupId = null;
        this.artifactId = null;
        this.path = path;
        this.method = method;
        this.handler = handler;
        this.isBodyHandlerRequired = false;
    }

    public DevConsoleRouteBuildItem(String path, String method, Handler<RoutingContext> handler, boolean isBodyHandlerRequired) {
        String callerClassName = new RuntimeException().getStackTrace()[1].getClassName();
        try {
            this.callerClass = Thread.currentThread().getContextClassLoader().loadClass(callerClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.groupId = null;
        this.artifactId = null;
        this.path = path;
        this.method = method;
        this.handler = handler;
        this.isBodyHandlerRequired = isBodyHandlerRequired;
    }

    public Map.Entry<String, String> groupIdAndArtifactId(CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (this.callerClass == null) {
            return new AbstractMap.SimpleEntry<String, String>(this.groupId, this.artifactId);
        }
        return ArtifactInfoUtil.groupIdAndArtifactId(this.callerClass, (CurateOutcomeBuildItem)curateOutcomeBuildItem);
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public Handler<RoutingContext> getHandler() {
        return this.handler;
    }

    public boolean isDeploymentSide() {
        return !(this.handler instanceof BytecodeRecorderImpl.ReturnedProxy);
    }

    public boolean isBodyHandlerRequired() {
        return this.isBodyHandlerRequired;
    }
}

