/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.client.runtime;

import io.netty.channel.EventLoopGroup;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.vertx.core.runtime.VertxCoreRecorder;
import io.quarkus.websockets.client.runtime.ExecutorSupplier;
import io.quarkus.websockets.client.runtime.ServerWebSocketContainerFactory;
import io.quarkus.websockets.client.runtime.WebSocketPrincipal;
import io.undertow.websockets.ServerWebSocketContainer;
import io.undertow.websockets.UndertowContainerProvider;
import io.undertow.websockets.UndertowSession;
import io.undertow.websockets.WebSocketDeploymentInfo;
import io.undertow.websockets.util.ContextSetupHandler;
import io.undertow.websockets.util.ObjectFactory;
import io.undertow.websockets.util.ObjectHandle;
import io.undertow.websockets.util.ObjectIntrospecter;
import io.vertx.core.impl.VertxInternal;
import jakarta.enterprise.inject.Instance;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.server.ServerApplicationConfig;
import jakarta.websocket.server.ServerEndpointConfig;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class WebsocketCoreRecorder {
    private static final Logger log = Logger.getLogger(WebsocketCoreRecorder.class);

    public void setupWorker(Executor executor) {
        ExecutorSupplier.executor = executor;
    }

    public RuntimeValue<WebSocketDeploymentInfo> createDeploymentInfo(Set<String> annotatedEndpoints, Set<String> endpoints, Set<String> serverApplicationConfigClasses, int maxFrameSize, boolean dispatchToWorker) {
        WebSocketDeploymentInfo container = new WebSocketDeploymentInfo();
        container.setMaxFrameSize(maxFrameSize);
        container.setDispatchToWorkerThread(dispatchToWorker);
        container.setExecutor((Supplier)new ExecutorSupplier());
        HashSet allScannedEndpointImplementations = new HashSet();
        for (String string : endpoints) {
            try {
                allScannedEndpointImplementations.add(Class.forName(string, true, Thread.currentThread().getContextClassLoader()));
            }
            catch (Exception e) {
                log.error((Object)("Could not initialize websocket class " + string), (Throwable)e);
            }
        }
        HashSet allScannedAnnotatedEndpoints = new HashSet();
        for (String i : annotatedEndpoints) {
            try {
                allScannedAnnotatedEndpoints.add(Class.forName(i, true, Thread.currentThread().getContextClassLoader()));
            }
            catch (Exception e) {
                log.error((Object)("Could not initialize websocket class " + i), (Throwable)e);
            }
        }
        HashSet hashSet = new HashSet();
        HashSet serverEndpointConfigurations = new HashSet();
        HashSet<ServerApplicationConfig> configInstances = new HashSet<ServerApplicationConfig>();
        for (String string : serverApplicationConfigClasses) {
            try {
                configInstances.add((ServerApplicationConfig)Class.forName(string, true, Thread.currentThread().getContextClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                log.error((Object)("Could not initialize websocket config class " + string), (Throwable)e);
            }
        }
        if (!configInstances.isEmpty()) {
            for (ServerApplicationConfig serverApplicationConfig : configInstances) {
                Set endpointConfigs;
                Set returnedEndpoints = serverApplicationConfig.getAnnotatedEndpointClasses(allScannedAnnotatedEndpoints);
                if (returnedEndpoints != null) {
                    hashSet.addAll(returnedEndpoints);
                }
                if ((endpointConfigs = serverApplicationConfig.getEndpointConfigs(allScannedEndpointImplementations)) == null) continue;
                serverEndpointConfigurations.addAll(endpointConfigs);
            }
        } else {
            hashSet.addAll(allScannedAnnotatedEndpoints);
        }
        for (Class clazz : hashSet) {
            if (clazz == null) continue;
            container.addEndpoint(clazz);
        }
        for (ServerEndpointConfig serverEndpointConfig : serverEndpointConfigurations) {
            if (serverEndpointConfig == null) continue;
            container.addEndpoint(serverEndpointConfig);
        }
        return new RuntimeValue((Object)container);
    }

    public RuntimeValue<ServerWebSocketContainer> createServerContainer(final BeanContainer beanContainer, RuntimeValue<WebSocketDeploymentInfo> infoVal, ServerWebSocketContainerFactory serverContainerFactory) throws DeploymentException {
        WebSocketDeploymentInfo info = (WebSocketDeploymentInfo)infoVal.getValue();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ManagedContext requestContext = Arc.container().requestContext();
        if (serverContainerFactory == null) {
            serverContainerFactory = ServerWebSocketContainer::new;
        }
        InjectableInstance currentIdentityAssociation = Arc.container().select(CurrentIdentityAssociation.class, new Annotation[0]);
        ServerWebSocketContainer container = serverContainerFactory.create(new ObjectIntrospecter(){

            public <T> ObjectFactory<T> createInstanceFactory(Class<T> clazz) {
                final BeanContainer.Factory factory = beanContainer.beanInstanceFactory(clazz, new Annotation[0]);
                return new ObjectFactory<T>(){

                    public ObjectHandle<T> createInstance() {
                        final BeanContainer.Instance instance = factory.create();
                        return new ObjectHandle<T>(){

                            public T getInstance() {
                                return instance.get();
                            }

                            public void release() {
                                instance.close();
                            }
                        };
                    }
                };
            }
        }, Thread.currentThread().getContextClassLoader(), new Supplier<EventLoopGroup>(){

            @Override
            public EventLoopGroup get() {
                return ((VertxInternal)VertxCoreRecorder.getVertx().get()).getEventLoopGroup();
            }
        }, Collections.singletonList(new ContextSetupHandler((Instance)currentIdentityAssociation, cl, requestContext){
            final /* synthetic */ Instance val$currentIdentityAssociation;
            final /* synthetic */ ClassLoader val$cl;
            final /* synthetic */ ManagedContext val$requestContext;
            {
                this.val$currentIdentityAssociation = instance;
                this.val$cl = classLoader;
                this.val$requestContext = managedContext;
            }

            public <T, C> ContextSetupHandler.Action<T, C> create(final ContextSetupHandler.Action<T, C> action) {
                return new ContextSetupHandler.Action<T, C>(){

                    CurrentIdentityAssociation getCurrentIdentityAssociation() {
                        if (val$currentIdentityAssociation.isResolvable()) {
                            return (CurrentIdentityAssociation)val$currentIdentityAssociation.get();
                        }
                        return null;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public T call(C context, UndertowSession session) throws Exception {
                        CurrentIdentityAssociation current;
                        Principal p;
                        boolean required;
                        ClassLoader old = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(val$cl);
                        boolean bl = required = !val$requestContext.isActive();
                        if (required) {
                            val$requestContext.activate();
                        }
                        if ((p = session.getUserPrincipal()) instanceof WebSocketPrincipal && (current = this.getCurrentIdentityAssociation()) != null) {
                            current.setIdentity(((WebSocketPrincipal)p).getSecurityIdentity());
                        }
                        try {
                            Object object = action.call(context, session);
                            return object;
                        }
                        finally {
                            try {
                                if (required) {
                                    val$requestContext.terminate();
                                }
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(old);
                            }
                        }
                    }
                };
            }
        }), info.isDispatchToWorkerThread(), null, null, info.getExecutor(), Collections.emptyList(), info.getMaxFrameSize(), new Supplier<Principal>((Instance)currentIdentityAssociation){
            final /* synthetic */ Instance val$currentIdentityAssociation;
            {
                this.val$currentIdentityAssociation = instance;
            }

            @Override
            public Principal get() {
                if (this.val$currentIdentityAssociation.isResolvable()) {
                    return new WebSocketPrincipal(((CurrentIdentityAssociation)this.val$currentIdentityAssociation.get()).getIdentity());
                }
                return null;
            }
        });
        for (Class i : info.getAnnotatedEndpoints()) {
            container.addEndpoint(i);
        }
        for (Class i : info.getProgramaticEndpoints()) {
            container.addEndpoint((ServerEndpointConfig)i);
        }
        UndertowContainerProvider.setDefaultContainer((ServerWebSocketContainer)container);
        return new RuntimeValue((Object)container);
    }
}

