/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.transaction.core.datasource;

import com.google.common.base.Optional;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.util.ReflectiveUtil;
import io.shardingsphere.transaction.api.TransactionType;
import io.shardingsphere.transaction.api.TransactionTypeHolder;
import io.shardingsphere.transaction.core.loader.TransactionalDataSourceConverterSPILoader;
import io.shardingsphere.transaction.spi.TransactionalDataSourceConverter;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public final class ShardingTransactionalDataSource
implements AutoCloseable {
    private final Map<String, DataSource> originalDataSourceMap;
    private final Map<TransactionType, Map<String, DataSource>> transactionalDataSourceMap;

    public ShardingTransactionalDataSource(DatabaseType databaseType, Map<String, DataSource> dataSourceMap) {
        this.originalDataSourceMap = dataSourceMap;
        this.transactionalDataSourceMap = new HashMap<TransactionType, Map<String, DataSource>>(TransactionType.values().length, 1.0f);
        for (TransactionType each : TransactionType.values()) {
            Optional<TransactionalDataSourceConverter> converter = TransactionalDataSourceConverterSPILoader.findConverter(each);
            if (!converter.isPresent()) continue;
            this.transactionalDataSourceMap.put(each, ((TransactionalDataSourceConverter)converter.get()).convert(databaseType, dataSourceMap));
        }
    }

    public Map<String, DataSource> getDataSourceMap() {
        return this.transactionalDataSourceMap.containsKey((Object)TransactionTypeHolder.get()) ? this.transactionalDataSourceMap.get((Object)TransactionTypeHolder.get()) : this.originalDataSourceMap;
    }

    @Override
    public void close() {
        this.close(this.originalDataSourceMap);
        for (Map.Entry<TransactionType, Map<String, DataSource>> entry : this.transactionalDataSourceMap.entrySet()) {
            this.close(entry.getValue());
        }
    }

    private void close(Map<String, DataSource> dataSourceMap) {
        for (DataSource each : dataSourceMap.values()) {
            try {
                ReflectiveUtil.findMethod((Object)each, (String)"close", (Class[])new Class[0]).invoke((Object)each, new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {}
        }
    }

    @ConstructorProperties(value={"originalDataSourceMap", "transactionalDataSourceMap"})
    public ShardingTransactionalDataSource(Map<String, DataSource> originalDataSourceMap, Map<TransactionType, Map<String, DataSource>> transactionalDataSourceMap) {
        this.originalDataSourceMap = originalDataSourceMap;
        this.transactionalDataSourceMap = transactionalDataSourceMap;
    }

    public Map<String, DataSource> getOriginalDataSourceMap() {
        return this.originalDataSourceMap;
    }
}

